/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleChangeRecordEmitter;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleSchemaChangeEventEmitter;
import io.debezium.connector.oracle.OracleStreamingChangeEventSource;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.sql.SQLException;
import oracle.streams.ChunkColumnValue;
import oracle.streams.DDLLCR;
import oracle.streams.LCR;
import oracle.streams.RowLCR;
import oracle.streams.StreamsException;
import oracle.streams.XStreamLCRCallbackHandler;
import oracle.streams.XStreamUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LcrEventHandler
implements XStreamLCRCallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleStreamingChangeEventSource.class);
    private final ErrorHandler errorHandler;
    private final EventDispatcher dispatcher;
    private final Clock clock;
    private final RelationalDatabaseSchema schema;
    private final OracleOffsetContext offsetContext;

    public LcrEventHandler(ErrorHandler errorHandler, EventDispatcher dispatcher, Clock clock, RelationalDatabaseSchema schema, OracleOffsetContext offsetContext) {
        this.errorHandler = errorHandler;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
        this.offsetContext = offsetContext;
    }

    public void processLCR(LCR lcr) throws StreamsException {
        long scn = this.convertPositionToScn(lcr.getPosition());
        if (scn <= this.offsetContext.getScn()) {
            LOGGER.debug("Ignoring change event with already processed SCN {}", (Object)scn);
            return;
        }
        this.offsetContext.setScn(scn);
        this.offsetContext.setTransactionId(lcr.getTransactionId());
        this.offsetContext.setSourceTime(lcr.getSourceTime().timestampValue().toInstant());
        try {
            if (lcr instanceof RowLCR) {
                this.dispatchDataChangeEvent((RowLCR)lcr);
            } else if (lcr instanceof DDLLCR) {
                this.dispatchSchemaChangeEvent((DDLLCR)lcr);
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOGGER.info("Received signal to stop, event loop will halt");
        }
        catch (Exception e) {
            this.errorHandler.setProducerThrowable((Throwable)e);
        }
    }

    private long convertPositionToScn(byte[] position) {
        try {
            return XStreamUtility.getSCNFromPosition((byte[])position).longValue();
        }
        catch (SQLException | StreamsException e) {
            throw new RuntimeException(e);
        }
    }

    private void dispatchDataChangeEvent(RowLCR lcr) throws InterruptedException {
        LOGGER.debug("Processing DML event {}", (Object)lcr);
        if ("COMMIT".equals(lcr.getCommandType())) {
            return;
        }
        TableId tableId = this.getTableId((LCR)lcr);
        this.dispatcher.dispatchDataChangeEvent((DataCollectionId)tableId, () -> new OracleChangeRecordEmitter(this.offsetContext, lcr, this.schema.getTable(tableId), this.clock), DataChangeEvent::new);
    }

    private void dispatchSchemaChangeEvent(DDLLCR ddlLcr) throws InterruptedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing DDL event {}", (Object)ddlLcr.getDDLText());
        }
        TableId tableId = this.getTableId((LCR)ddlLcr);
        this.dispatcher.dispatchSchemaChangeEvent((DataCollectionId)tableId, () -> new OracleSchemaChangeEventEmitter(this.offsetContext, tableId, ddlLcr));
    }

    private TableId getTableId(LCR lcr) {
        return new TableId(lcr.getSourceDatabaseName(), lcr.getObjectOwner(), lcr.getObjectName());
    }

    public void processChunk(ChunkColumnValue arg0) throws StreamsException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public LCR createLCR() throws StreamsException {
        throw new UnsupportedOperationException("Should never be called");
    }

    public ChunkColumnValue createChunk() throws StreamsException {
        throw new UnsupportedOperationException("Should never be called");
    }
}

