/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.oracle.LcrPosition;
import io.debezium.connector.oracle.Module;
import io.debezium.connector.oracle.OracleSourceInfoStructMaker;
import io.debezium.document.Document;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.KafkaDatabaseHistory;
import org.apache.kafka.common.config.ConfigDef;

public class OracleConnectorConfig
extends HistorizedRelationalDatabaseConnectorConfig {
    public static final String DATABASE_CONFIG_PREFIX = "database.";
    public static final Field DATABASE_NAME = Field.create((String)("database." + JdbcConfiguration.DATABASE)).withDisplayName("Database name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("The name of the database the connector should be monitoring. When working with a multi-tenant set-up, must be set to the CDB name.");
    public static final Field PDB_NAME = Field.create((String)"database.pdb.name").withDisplayName("PDB name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("Name of the pluggable database when working with a multi-tenant set-up. The CDB name must be given via " + DATABASE_NAME.name() + " in this case.");
    public static final Field XSTREAM_SERVER_NAME = Field.create((String)"database.out.server.name").withDisplayName("XStream out server name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Name of the XStream Out server to connect to.");
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should run a snapshot only when no offsets are available for the logical server name; 'initial_schema_only' to specify the connector should run a snapshot of the schema when no offsets are available for the logical server name. ");
    public static final Field TABLENAME_CASE_INSENSITIVE = Field.create((String)"database.tablename.case.insensitive").withDisplayName("Case insensitive table names").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withImportance(ConfigDef.Importance.LOW).withDescription("Case insensitive table names; set to 'true' for Oracle 11g, 'false' (default) otherwise.");
    public static final Field ORACLE_VERSION = Field.create((String)"database.oracle.version").withDisplayName("Oracle version, 11 or 12+").withEnum(OracleVersion.class, (Enum)OracleVersion.V12Plus).withImportance(ConfigDef.Importance.LOW).withDescription("For default Oracle 12+, use default pos_version value v2, for Oracle 11, use pos_version value v1.");
    public static final Field SERVER_NAME = RelationalDatabaseConnectorConfig.SERVER_NAME.withValidation(new Field.Validator[]{CommonConnectorConfig::validateServerNameIsDifferentFromHistoryTopicName});
    public static Field.Set ALL_FIELDS = Field.setOf((Field[])new Field[]{SERVER_NAME, DATABASE_NAME, PDB_NAME, XSTREAM_SERVER_NAME, SNAPSHOT_MODE, HistorizedRelationalDatabaseConnectorConfig.DATABASE_HISTORY, RelationalDatabaseConnectorConfig.TABLE_WHITELIST, RelationalDatabaseConnectorConfig.TABLE_BLACKLIST, RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN, CommonConnectorConfig.POLL_INTERVAL_MS, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.MAX_QUEUE_SIZE, CommonConnectorConfig.SNAPSHOT_DELAY_MS, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX, TABLENAME_CASE_INSENSITIVE, ORACLE_VERSION});
    private final String databaseName;
    private final String pdbName;
    private final String xoutServerName;
    private final SnapshotMode snapshotMode;
    private final boolean tablenameCaseInsensitive;
    private final OracleVersion oracleVersion;

    public OracleConnectorConfig(Configuration config) {
        super(config, config.getString(SERVER_NAME), (Tables.TableFilter)new SystemTablesPredicate());
        this.databaseName = config.getString(DATABASE_NAME);
        this.pdbName = config.getString(PDB_NAME);
        this.xoutServerName = config.getString(XSTREAM_SERVER_NAME);
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE));
        this.tablenameCaseInsensitive = config.getBoolean(TABLENAME_CASE_INSENSITIVE);
        this.oracleVersion = OracleVersion.parse(config.getString(ORACLE_VERSION));
    }

    public static ConfigDef configDef() {
        ConfigDef config = new ConfigDef();
        Field.group((ConfigDef)config, (String)"Oracle", (Field[])new Field[]{SERVER_NAME, DATABASE_NAME, PDB_NAME, XSTREAM_SERVER_NAME, SNAPSHOT_MODE});
        Field.group((ConfigDef)config, (String)"History Storage", (Field[])new Field[]{KafkaDatabaseHistory.BOOTSTRAP_SERVERS, KafkaDatabaseHistory.TOPIC, KafkaDatabaseHistory.RECOVERY_POLL_ATTEMPTS, KafkaDatabaseHistory.RECOVERY_POLL_INTERVAL_MS, HistorizedRelationalDatabaseConnectorConfig.DATABASE_HISTORY});
        Field.group((ConfigDef)config, (String)"Events", (Field[])new Field[]{RelationalDatabaseConnectorConfig.TABLE_WHITELIST, RelationalDatabaseConnectorConfig.TABLE_BLACKLIST, RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX});
        Field.group((ConfigDef)config, (String)"Connector", (Field[])new Field[]{CommonConnectorConfig.POLL_INTERVAL_MS, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.MAX_QUEUE_SIZE, CommonConnectorConfig.SNAPSHOT_DELAY_MS});
        return config;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public String getXoutServerName() {
        return this.xoutServerName;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public boolean getTablenameCaseInsensitive() {
        return this.tablenameCaseInsensitive;
    }

    public OracleVersion getOracleVersion() {
        return this.oracleVersion;
    }

    protected HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                LcrPosition recordedPosition = LcrPosition.valueOf(recorded.getString((CharSequence)"lcr_position"));
                LcrPosition desiredPosition = LcrPosition.valueOf(desired.getString((CharSequence)"lcr_position"));
                Long recordedScn = recordedPosition != null ? recordedPosition.getScn() : recorded.getLong((CharSequence)"scn").longValue();
                Long desiredScn = desiredPosition != null ? desiredPosition.getScn() : desired.getLong((CharSequence)"scn").longValue();
                return recordedPosition != null && desiredPosition != null ? recordedPosition.compareTo(desiredPosition) < 1 : recordedScn.compareTo(desiredScn) < 1;
            }
        };
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return new OracleSourceInfoStructMaker(Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    public String getContextName() {
        return Module.contextName();
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        private SystemTablesPredicate() {
        }

        public boolean isIncluded(TableId t) {
            return !t.schema().toLowerCase().equals("appqossys") && !t.schema().toLowerCase().equals("audsys") && !t.schema().toLowerCase().equals("ctxsys") && !t.schema().toLowerCase().equals("dvsys") && !t.schema().toLowerCase().equals("dbsfwuser") && !t.schema().toLowerCase().equals("dbsnmp") && !t.schema().toLowerCase().equals("gsmadmin_internal") && !t.schema().toLowerCase().equals("lbacsys") && !t.schema().toLowerCase().equals("mdsys") && !t.schema().toLowerCase().equals("ojvmsys") && !t.schema().toLowerCase().equals("olapsys") && !t.schema().toLowerCase().equals("orddata") && !t.schema().toLowerCase().equals("ordsys") && !t.schema().toLowerCase().equals("outln") && !t.schema().toLowerCase().equals("sys") && !t.schema().toLowerCase().equals("system") && !t.schema().toLowerCase().equals("wmsys") && !t.schema().toLowerCase().equals("xdb");
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        INITIAL("initial", true),
        INITIAL_SCHEMA_ONLY("initial_schema_only", false);

        private final String value;
        private final boolean includeData;

        private SnapshotMode(String value, boolean includeData) {
            this.value = value;
            this.includeData = includeData;
        }

        public String getValue() {
            return this.value;
        }

        public boolean includeData() {
            return this.includeData;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum OracleVersion implements EnumeratedValue
    {
        V11("11"),
        V12Plus("12+");

        private final String version;

        private OracleVersion(String version) {
            this.version = version;
        }

        public String getValue() {
            return this.version;
        }

        public int getPosVersion() {
            switch (this.version) {
                case "11": {
                    return 1;
                }
                case "12+": {
                    return 2;
                }
            }
            return 2;
        }

        public static OracleVersion parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (OracleVersion option : OracleVersion.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static OracleVersion parse(String value, String defaultValue) {
            OracleVersion option = OracleVersion.parse(value);
            if (option == null && defaultValue != null) {
                option = OracleVersion.parse(defaultValue);
            }
            return option;
        }
    }
}

