/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.SnapshotChangeEventSourceMetrics;
import io.debezium.pipeline.metrics.StreamingChangeEventSourceMetrics;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.util.Threads;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ChangeEventSourceCoordinator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeEventSourceCoordinator.class);
    private static final Duration SHUTDOWN_WAIT_TIMEOUT = Duration.ofSeconds(90L);
    private final OffsetContext previousOffset;
    private final ErrorHandler errorHandler;
    private final ChangeEventSourceFactory changeEventSourceFactory;
    private final ExecutorService executor;
    private final EventDispatcher<?> eventDispatcher;
    private final RelationalDatabaseSchema schema;
    private volatile boolean running;
    private volatile StreamingChangeEventSource streamingSource;
    private SnapshotChangeEventSourceMetrics snapshotMetrics;
    private StreamingChangeEventSourceMetrics streamingMetrics;

    public ChangeEventSourceCoordinator(OffsetContext previousOffset, ErrorHandler errorHandler, Class<? extends SourceConnector> connectorType, String logicalName, ChangeEventSourceFactory changeEventSourceFactory, EventDispatcher<?> eventDispatcher, RelationalDatabaseSchema schema) {
        this.previousOffset = previousOffset;
        this.errorHandler = errorHandler;
        this.changeEventSourceFactory = changeEventSourceFactory;
        this.executor = Threads.newSingleThreadExecutor(connectorType, logicalName, "change-event-source-coordinator");
        this.eventDispatcher = eventDispatcher;
        this.schema = schema;
    }

    public synchronized <T extends CdcSourceTaskContext> void start(T taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider) {
        this.snapshotMetrics = new SnapshotChangeEventSourceMetrics(taskContext, changeEventQueueMetrics, metadataProvider);
        this.streamingMetrics = new StreamingChangeEventSourceMetrics(taskContext, changeEventQueueMetrics, metadataProvider);
        this.running = true;
        this.executor.submit(() -> {
            try {
                this.snapshotMetrics.register(LOGGER);
                this.streamingMetrics.register(LOGGER);
                ChangeEventSourceContextImpl context = new ChangeEventSourceContextImpl();
                SnapshotChangeEventSource snapshotSource = this.changeEventSourceFactory.getSnapshotChangeEventSource(this.previousOffset, this.snapshotMetrics);
                this.eventDispatcher.setEventListener(this.snapshotMetrics);
                SnapshotResult snapshotResult = snapshotSource.execute(context);
                this.schema.assureNonEmptySchema();
                if (this.running && snapshotResult.getStatus() == SnapshotResult.SnapshotResultStatus.COMPLETED) {
                    this.streamingSource = this.changeEventSourceFactory.getStreamingChangeEventSource(snapshotResult.getOffset());
                    this.eventDispatcher.setEventListener(this.streamingMetrics);
                    this.streamingMetrics.connected(true);
                    this.streamingSource.execute(context);
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                LOGGER.warn("Change event source executor was interrupted", (Throwable)e);
            }
            catch (Throwable e) {
                this.errorHandler.setProducerThrowable(e);
            }
            finally {
                this.streamingMetrics.connected(false);
            }
        });
    }

    public void commitOffset(Map<String, ?> offset) {
        if (this.streamingSource != null && offset != null) {
            this.streamingSource.commitOffset(offset);
        }
    }

    public synchronized void stop() throws InterruptedException {
        this.running = false;
        this.executor.shutdown();
        Thread.interrupted();
        boolean isShutdown = this.executor.awaitTermination(SHUTDOWN_WAIT_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        if (!isShutdown) {
            LOGGER.warn("Coordinator didn't stop in the expected time, shutting down executor now");
            this.executor.shutdownNow();
            this.executor.awaitTermination(SHUTDOWN_WAIT_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        }
        this.snapshotMetrics.unregister(LOGGER);
        this.streamingMetrics.unregister(LOGGER);
    }

    private class ChangeEventSourceContextImpl
    implements ChangeEventSource.ChangeEventSourceContext {
        private ChangeEventSourceContextImpl() {
        }

        @Override
        public boolean isRunning() {
            return ChangeEventSourceCoordinator.this.running;
        }
    }
}

