/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.outbox;

import io.debezium.annotation.Incubating;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.data.Envelope;
import io.debezium.transforms.outbox.EventRouterConfigDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.RegexRouter;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating
public class EventRouter<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventRouter.class);
    private static final String ENVELOPE_EVENT_TYPE = "eventType";
    private static final String ENVELOPE_PAYLOAD = "payload";
    private final ExtractField<R> afterExtractor = new ExtractField.Value();
    private final RegexRouter<R> regexRouter = new RegexRouter();
    private EventRouterConfigDefinition.InvalidOperationBehavior invalidOperationBehavior;
    private String fieldEventId;
    private String fieldEventKey;
    private String fieldEventType;
    private String fieldEventTimestamp;
    private String fieldPayload;
    private String fieldPayloadId;
    private String fieldSchemaVersion;
    private String routeByField;
    private List<EventRouterConfigDefinition.AdditionalField> additionalFields;
    private Schema defaultValueSchema;
    private final Map<Integer, Schema> versionedValueSchema = new HashMap<Integer, Schema>();

    public R apply(R r) {
        if (r.value() == null) {
            LOGGER.info("Tombstone message {} ignored", r.key());
            return null;
        }
        Struct debeziumEventValue = Requirements.requireStruct((Object)r.value(), (String)"Detect Debezium Operation");
        String op = debeziumEventValue.getString("op");
        if (op.equals(Envelope.Operation.DELETE.code())) {
            LOGGER.info("Delete message {} ignored", r.key());
            return null;
        }
        if (op.equals(Envelope.Operation.UPDATE.code())) {
            this.handleUnexpectedOperation(r);
            return null;
        }
        ConnectRecord afterRecord = this.afterExtractor.apply(r);
        Struct eventStruct = Requirements.requireStruct((Object)afterRecord.value(), (String)"Read Outbox Event");
        Schema eventValueSchema = afterRecord.valueSchema();
        Long timestamp = this.fieldEventTimestamp == null ? debeziumEventValue.getInt64("ts_ms") : eventStruct.getInt64(this.fieldEventTimestamp);
        Object eventId = eventStruct.get(this.fieldEventId);
        Object eventType = eventStruct.get(this.fieldEventType);
        Object payload = eventStruct.get(this.fieldPayload);
        Object payloadId = eventStruct.get(this.fieldPayloadId);
        Headers headers = r.headers();
        headers.add("id", eventId, eventValueSchema.field(this.fieldEventId).schema());
        Schema valueSchema = this.fieldSchemaVersion == null ? this.getValueSchema(eventValueSchema) : this.getValueSchema(eventValueSchema, eventStruct.getInt32(this.fieldSchemaVersion));
        Struct value = new Struct(valueSchema).put(ENVELOPE_EVENT_TYPE, eventType).put(ENVELOPE_PAYLOAD, payload);
        this.additionalFields.forEach(additionalField -> {
            switch (additionalField.getPlacement()) {
                case ENVELOPE: {
                    value.put(additionalField.getAlias(), eventStruct.get(additionalField.getField()));
                    break;
                }
                case HEADER: {
                    headers.add(additionalField.getAlias(), eventStruct.get(additionalField.getField()), eventValueSchema.field(additionalField.getField()).schema());
                }
            }
        });
        ConnectRecord newRecord = r.newRecord(eventStruct.getString(this.routeByField).toLowerCase(), null, Schema.STRING_SCHEMA, this.defineRecordKey(eventStruct, payloadId), valueSchema, (Object)value, timestamp, (Iterable)headers);
        return (R)this.regexRouter.apply(newRecord);
    }

    private Object defineRecordKey(Struct eventStruct, Object fallbackKey) {
        Object eventKey = null;
        if (this.fieldEventKey != null) {
            eventKey = eventStruct.get(this.fieldEventKey);
        }
        return eventKey != null ? eventKey : fallbackKey;
    }

    private void handleUnexpectedOperation(R r) {
        switch (this.invalidOperationBehavior) {
            case SKIP_AND_WARN: {
                LOGGER.warn("Unexpected update message received {} and ignored", r.key());
                break;
            }
            case SKIP_AND_ERROR: {
                LOGGER.error("Unexpected update message received {} and ignored", r.key());
                break;
            }
            case FATAL: {
                throw new IllegalStateException(String.format("Unexpected update message received %s, fail.", r.key()));
            }
        }
    }

    public ConfigDef config() {
        return EventRouterConfigDefinition.configDef();
    }

    public void close() {
    }

    public void configure(Map<String, ?> configMap) {
        Configuration config = Configuration.from(configMap);
        Field.Set allFields = Field.setOf(EventRouterConfigDefinition.CONFIG_FIELDS);
        if (!config.validateAndRecord(allFields, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Unable to validate config.");
        }
        this.invalidOperationBehavior = EventRouterConfigDefinition.InvalidOperationBehavior.parse(config.getString(EventRouterConfigDefinition.OPERATION_INVALID_BEHAVIOR));
        this.fieldEventId = config.getString(EventRouterConfigDefinition.FIELD_EVENT_ID);
        this.fieldEventKey = config.getString(EventRouterConfigDefinition.FIELD_EVENT_KEY);
        this.fieldEventType = config.getString(EventRouterConfigDefinition.FIELD_EVENT_TYPE);
        this.fieldEventTimestamp = config.getString(EventRouterConfigDefinition.FIELD_EVENT_TIMESTAMP);
        this.fieldPayload = config.getString(EventRouterConfigDefinition.FIELD_PAYLOAD);
        this.fieldPayloadId = config.getString(EventRouterConfigDefinition.FIELD_PAYLOAD_ID);
        this.fieldSchemaVersion = config.getString(EventRouterConfigDefinition.FIELD_SCHEMA_VERSION);
        this.routeByField = config.getString(EventRouterConfigDefinition.ROUTE_BY_FIELD);
        HashMap<String, String> regexRouterConfig = new HashMap<String, String>();
        regexRouterConfig.put("regex", config.getString(EventRouterConfigDefinition.ROUTE_TOPIC_REGEX));
        regexRouterConfig.put("replacement", config.getString(EventRouterConfigDefinition.ROUTE_TOPIC_REPLACEMENT));
        this.regexRouter.configure(regexRouterConfig);
        HashMap<String, String> afterExtractorConfig = new HashMap<String, String>();
        afterExtractorConfig.put("field", "after");
        this.afterExtractor.configure(afterExtractorConfig);
        this.additionalFields = EventRouterConfigDefinition.parseAdditionalFieldsConfig(config);
    }

    private Schema getValueSchema(Schema debeziumEventSchema) {
        if (this.defaultValueSchema == null) {
            this.defaultValueSchema = this.getSchemaBuilder(debeziumEventSchema).build();
        }
        return this.defaultValueSchema;
    }

    private Schema getValueSchema(Schema debeziumEventSchema, Integer version) {
        if (!this.versionedValueSchema.containsKey(version)) {
            Schema schema = this.getSchemaBuilder(debeziumEventSchema).version(version).build();
            this.versionedValueSchema.put(version, schema);
        }
        return this.versionedValueSchema.get(version);
    }

    private SchemaBuilder getSchemaBuilder(Schema debeziumEventSchema) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        schemaBuilder.field(ENVELOPE_EVENT_TYPE, debeziumEventSchema.field(this.fieldEventType).schema()).field(ENVELOPE_PAYLOAD, debeziumEventSchema.field(this.fieldPayload).schema());
        this.additionalFields.forEach(additionalField -> {
            if (additionalField.getPlacement() == EventRouterConfigDefinition.AdditionalFieldPlacement.ENVELOPE) {
                schemaBuilder.field(additionalField.getAlias(), debeziumEventSchema.field(additionalField.getField()).schema());
            }
        });
        return schemaBuilder;
    }
}

