/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogSnapshotSourceIT;
import io.debezium.connector.mysql.MySqlCommon;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.data.KeyValueStore;
import io.debezium.data.SchemaChangeHistory;
import io.debezium.data.VerifyRecord;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class SnapshotSourceIT
extends BinlogSnapshotSourceIT<MySqlConnector>
implements MySqlCommon {
    @Test
    public void snapshotWithBackupLocksShouldNotWaitForReads() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.simpleConfig().with(MySqlConnectorConfig.USER, "cloud")).with(MySqlConnectorConfig.PASSWORD, "cloudpass")).with(MySqlConnectorConfig.SNAPSHOT_LOCKING_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotLockingMode.MINIMAL_PERCONA)).build();
        if (!this.isPerconaServer()) {
            return;
        }
        MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
        final JdbcConnection connection = db.connect();
        final CountDownLatch latch = new CountDownLatch(1);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    connection.executeWithoutCommitting(new String[]{"SELECT *, SLEEP(20) FROM products_on_hand WHERE product_id=101"});
                    latch.countDown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        latch.await(10L, TimeUnit.SECONDS);
        this.start(MySqlConnector.class, this.config);
        SnapshotSourceIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        int recordCount = 28;
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(28);
        Assertions.assertThat((List)sourceRecords.allRecordsInOrder()).hasSize(28);
        connection.connection().close();
    }

    @Test
    public void shouldCreateSnapshotOfSingleDatabaseUsingInsertEvents() throws Exception {
        this.config = ((Configuration.Builder)this.simpleConfig().with(BinlogConnectorConfig.DATABASE_INCLUDE_LIST, "connector_(.*)_" + this.DATABASE.getIdentifier())).with("transforms", "snapshotasinsert").with("transforms.snapshotasinsert.type", "io.debezium.connector.mysql.transforms.ReadToInsertEvent").build();
        this.start(this.getConnectorClass(), this.config);
        SnapshotSourceIT.waitForSnapshotToBeCompleted((String)this.getConnectorName(), (String)this.DATABASE.getServerName());
        KeyValueStore store = KeyValueStore.createForTopicsBeginningWith((String)(this.DATABASE.getServerName() + "."));
        SchemaChangeHistory schemaChanges = new SchemaChangeHistory(this.DATABASE.getServerName());
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(55);
        sourceRecords.allRecordsInOrder().forEach(record -> {
            VerifyRecord.isValid((SourceRecord)record);
            VerifyRecord.hasNoSourceQuery((SourceRecord)record);
            store.add(record);
            schemaChanges.add(record);
        });
        Assertions.assertThat((int)schemaChanges.recordCount()).isEqualTo(0);
        Assertions.assertThat((Iterable)store.databases()).containsOnly((Object[])new String[]{this.DATABASE.getDatabaseName(), this.OTHER_DATABASE.getDatabaseName()});
        Assertions.assertThat((int)store.collectionCount()).isEqualTo(9);
        KeyValueStore.Collection products = store.collection(this.DATABASE.getDatabaseName(), this.productsTableName());
        Assertions.assertThat((long)products.numberOfCreates()).isEqualTo(9L);
        Assertions.assertThat((long)products.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfReads()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)products.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)products.numberOfValueSchemaChanges()).isEqualTo(1L);
        KeyValueStore.Collection products_on_hand = store.collection(this.DATABASE.getDatabaseName(), "products_on_hand");
        Assertions.assertThat((long)products_on_hand.numberOfCreates()).isEqualTo(9L);
        Assertions.assertThat((long)products_on_hand.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfReads()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)products_on_hand.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)products_on_hand.numberOfValueSchemaChanges()).isEqualTo(1L);
        KeyValueStore.Collection customers = store.collection(this.DATABASE.getDatabaseName(), "customers");
        Assertions.assertThat((long)customers.numberOfCreates()).isEqualTo(4L);
        Assertions.assertThat((long)customers.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfReads()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)customers.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)customers.numberOfValueSchemaChanges()).isEqualTo(1L);
        KeyValueStore.Collection orders = store.collection(this.DATABASE.getDatabaseName(), "orders");
        Assertions.assertThat((long)orders.numberOfCreates()).isEqualTo(5L);
        Assertions.assertThat((long)orders.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfReads()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)orders.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)orders.numberOfValueSchemaChanges()).isEqualTo(1L);
        KeyValueStore.Collection timetest = store.collection(this.DATABASE.getDatabaseName(), "dbz_342_timetest");
        Assertions.assertThat((long)timetest.numberOfCreates()).isEqualTo(1L);
        Assertions.assertThat((long)timetest.numberOfUpdates()).isEqualTo(0L);
        Assertions.assertThat((long)timetest.numberOfDeletes()).isEqualTo(0L);
        Assertions.assertThat((long)timetest.numberOfReads()).isEqualTo(0L);
        Assertions.assertThat((long)timetest.numberOfTombstones()).isEqualTo(0L);
        Assertions.assertThat((long)timetest.numberOfKeySchemaChanges()).isEqualTo(1L);
        Assertions.assertThat((long)timetest.numberOfValueSchemaChanges()).isEqualTo(1L);
        ArrayList timerecords = new ArrayList();
        timetest.forEach(val -> timerecords.add(((Struct)val.value()).getStruct("after")));
        Struct after = (Struct)timerecords.get(0);
        String expected = this.isMariaDb() ? "PT517H51M04.77S" : "PT517H51M04.78S";
        Assertions.assertThat((Object)after.get("c1")).isEqualTo((Object)this.toMicroSeconds(expected));
        Assertions.assertThat((Object)after.get("c2")).isEqualTo((Object)this.toMicroSeconds("-PT13H14M50S"));
        Assertions.assertThat((Object)after.get("c3")).isEqualTo((Object)this.toMicroSeconds("-PT733H0M0.001S"));
        Assertions.assertThat((Object)after.get("c4")).isEqualTo((Object)this.toMicroSeconds("-PT1H59M59.001S"));
        Assertions.assertThat((Object)after.get("c5")).isEqualTo((Object)this.toMicroSeconds("-PT838H59M58.999999S"));
        Assertions.assertThat((Object)after.get("c6")).isEqualTo((Object)this.toMicroSeconds("-PT00H20M38.000000S"));
        Assertions.assertThat((Object)after.get("c7")).isEqualTo((Object)this.toMicroSeconds("-PT01H01M01.000001S"));
        Assertions.assertThat((Object)after.get("c8")).isEqualTo((Object)this.toMicroSeconds("-PT01H01M01.000000S"));
        Assertions.assertThat((Object)after.get("c9")).isEqualTo((Object)this.toMicroSeconds("-PT01H01M00.000000S"));
        Assertions.assertThat((Object)after.get("c10")).isEqualTo((Object)this.toMicroSeconds("-PT01H00M00.000000S"));
        Assertions.assertThat((Object)after.get("c11")).isEqualTo((Object)this.toMicroSeconds("-PT00H00M00.000000S"));
    }

    protected Field getSnapshotLockingModeField() {
        return MySqlConnectorConfig.SNAPSHOT_LOCKING_MODE;
    }

    protected String getSnapshotLockingModeMinimal() {
        return MySqlConnectorConfig.SnapshotLockingMode.MINIMAL.getValue();
    }

    protected String getSnapshotLockingModeNone() {
        return MySqlConnectorConfig.SnapshotLockingMode.NONE.getValue();
    }
}

