/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.binlog.BinlogReadOnlyIncrementalSnapshotIT;
import io.debezium.connector.binlog.junit.SkipTestDependingOnGtidModeRule;
import io.debezium.connector.binlog.junit.SkipWhenGtidModeIs;
import io.debezium.connector.mysql.MySqlCommon;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.jdbc.MySqlBinaryProtocolFieldReader;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.errors.ConnectException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenGtidModeIs(value=SkipWhenGtidModeIs.GtidMode.OFF, reason="Read only connection requires GTID_MODE to be ON")
public class ReadOnlyIncrementalSnapshotIT
extends BinlogReadOnlyIncrementalSnapshotIT<MySqlConnector>
implements MySqlCommon {
    @Rule
    public TestRule skipTest = new SkipTestDependingOnGtidModeRule();

    protected Class<?> getFieldReader() {
        return MySqlBinaryProtocolFieldReader.class;
    }

    @Test(expected=ConnectException.class)
    @SkipWhenGtidModeIs(value=SkipWhenGtidModeIs.GtidMode.ON, reason="Read only connection requires GTID_MODE to be ON")
    public void shouldFailIfGtidModeIsOff() throws Exception {
        this.populateTable();
        AtomicReference exception = new AtomicReference();
        this.startConnector((success, message, error) -> exception.set(error));
        this.waitForEngineShutdown();
        this.stopConnector();
        Throwable e = (Throwable)exception.get();
        if (e != null) {
            throw (RuntimeException)e;
        }
    }
}

