/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.binlog.BinlogConnectorIT;
import io.debezium.connector.mysql.MySqlCommon;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.config.Config;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class MySqlConnectorIT
extends BinlogConnectorIT<MySqlConnector, MySqlPartition, MySqlOffsetContext>
implements MySqlCommon {
    @Test
    public void shouldNotStartWithUnknownJdbcDriver() {
        Configuration config = ((Configuration.Builder)this.getDatabase().defaultConfig().with(MySqlConnectorConfig.JDBC_DRIVER, "foo.bar")).build();
        AtomicBoolean successResult = new AtomicBoolean();
        AtomicReference message = new AtomicReference();
        this.start(MySqlConnector.class, config, (success, msg, error) -> {
            successResult.set(success);
            message.set(msg);
        });
        Assertions.assertThat((boolean)successResult.get()).isEqualTo(false);
        Assertions.assertThat((String)((String)message.get())).contains(new CharSequence[]{"java.lang.ClassNotFoundException: foo.bar"});
        this.assertConnectorNotRunning();
    }

    @Test
    public void shouldNotStartWithWrongProtocol() {
        Configuration config = ((Configuration.Builder)this.getDatabase().defaultConfig().with(MySqlConnectorConfig.JDBC_PROTOCOL, "foo:bar")).build();
        AtomicBoolean successResult = new AtomicBoolean();
        AtomicReference message = new AtomicReference();
        this.start(MySqlConnector.class, config, (success, msg, error) -> {
            successResult.set(success);
            message.set(msg);
        });
        Assertions.assertThat((boolean)successResult.get()).isEqualTo(false);
        Assertions.assertThat((String)((String)message.get())).contains(new CharSequence[]{"Unable to obtain a JDBC connection"});
        this.assertConnectorNotRunning();
    }

    protected Config validateConfiguration(Configuration configuration) {
        return new MySqlConnector().validate(configuration.asMap());
    }

    protected void assertInvalidConfiguration(Config result) {
        super.assertInvalidConfiguration(result);
        this.assertNoConfigurationErrors(result, new Field[]{MySqlConnectorConfig.SNAPSHOT_LOCKING_MODE});
    }

    protected void assertValidConfiguration(Config result) {
        super.assertValidConfiguration(result);
        this.validateConfigField(result, MySqlConnectorConfig.SNAPSHOT_LOCKING_MODE, MySqlConnectorConfig.SnapshotLockingMode.MINIMAL);
    }

    protected Field getSnapshotLockingModeField() {
        return MySqlConnectorConfig.SNAPSHOT_LOCKING_MODE;
    }

    protected String getSnapshotLockingModeNone() {
        return MySqlConnectorConfig.SnapshotLockingMode.NONE.getValue();
    }

    protected void assertSnapshotLockingModeIsNone(Configuration config) {
        Assertions.assertThat((Comparable)((MySqlConnectorConfig.SnapshotLockingMode)new MySqlConnectorConfig(config).getSnapshotLockingMode().get())).isEqualTo((Object)MySqlConnectorConfig.SnapshotLockingMode.NONE);
    }

    protected MySqlPartition createPartition(String serverName, String databaseName) {
        return new MySqlPartition(serverName, databaseName);
    }

    protected MySqlOffsetContext loadOffsets(Configuration configuration, Map<String, ?> offsets) {
        return new MySqlOffsetContext.Loader(new MySqlConnectorConfig(configuration)).load(offsets);
    }

    protected void assertBinlogPosition(long offsetPosition, long beforeInsertsPosition) {
        Assertions.assertThat((long)offsetPosition).isGreaterThan(beforeInsertsPosition);
    }
}

