/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.event.DeleteRowsEventData;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.EventHeader;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.QueryEventData;
import com.github.shyiko.mysql.binlog.event.RotateEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.TransactionPayloadEventData;
import com.github.shyiko.mysql.binlog.event.UpdateRowsEventData;
import com.github.shyiko.mysql.binlog.event.WriteRowsEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializationException;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.GtidEventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import com.github.shyiko.mysql.binlog.network.AuthenticationException;
import com.github.shyiko.mysql.binlog.network.DefaultSSLSocketFactory;
import com.github.shyiko.mysql.binlog.network.SSLMode;
import com.github.shyiko.mysql.binlog.network.SSLSocketFactory;
import com.github.shyiko.mysql.binlog.network.ServerException;
import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.binlog.BinlogChangeRecordEmitter;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogDatabaseSchema;
import io.debezium.connector.binlog.BinlogOffsetContext;
import io.debezium.connector.binlog.BinlogPartition;
import io.debezium.connector.binlog.BinlogSourceInfo;
import io.debezium.connector.binlog.BinlogTaskContext;
import io.debezium.connector.binlog.EventBuffer;
import io.debezium.connector.binlog.event.EventDataDeserializationExceptionData;
import io.debezium.connector.binlog.event.RowDeserializers;
import io.debezium.connector.binlog.event.StopEventDataDeserializer;
import io.debezium.connector.binlog.event.TransactionPayloadDeserializer;
import io.debezium.connector.binlog.gtid.GtidSet;
import io.debezium.connector.binlog.jdbc.BinlogConnectorConnection;
import io.debezium.connector.binlog.metrics.BinlogStreamingChangeEventSourceMetrics;
import io.debezium.data.Envelope;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.snapshot.mode.NeverSnapshotter;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.time.Conversions;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class BinlogStreamingChangeEventSource<P extends BinlogPartition, O extends BinlogOffsetContext>
implements StreamingChangeEventSource<P, O> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinlogStreamingChangeEventSource.class);
    private static final String KEEPALIVE_THREAD_NAME = "blc-keepalive";
    private static final String SET_STATEMENT_REGEX = "SET STATEMENT .* FOR";
    private final BinaryLogClient client;
    private final BinlogStreamingChangeEventSourceMetrics<?, P> metrics;
    private final BinlogTaskContext<?> taskContext;
    private final BinlogDatabaseSchema schema;
    private final BinlogConnectorConfig connectorConfig;
    private final BinlogConnectorConnection connection;
    private final EventDispatcher<P, TableId> eventDispatcher;
    private final Clock clock;
    private final ErrorHandler errorHandler;
    private final CommonConnectorConfig.EventProcessingFailureHandlingMode eventDeserializationFailureHandlingMode;
    private final CommonConnectorConfig.EventProcessingFailureHandlingMode inconsistentSchemaHandlingMode;
    private final SnapshotterService snapshotterService;
    private final Predicate<String> gtidDmlSourceFilter;
    private final boolean isGtidModeEnabled;
    private final AtomicLong totalRecordCounter = new AtomicLong();
    private final Map<String, Thread> binaryLogClientThreads = new ConcurrentHashMap<String, Thread>(4);
    private final EnumMap<EventType, BlockingConsumer<Event>> eventHandlers = new EnumMap(EventType.class);
    private final float heartbeatIntervalFactor = 0.8f;
    private int startingRowNumber = 0;
    private long initialEventsToSkip = 0L;
    private boolean skipEvent = false;
    private boolean ignoreDmlEventByGtidSource = false;
    private volatile Map<String, ?> lastOffset = null;
    private O effectiveOffsetContext;
    protected Instant eventTimestamp;

    public BinlogStreamingChangeEventSource(BinlogConnectorConfig connectorConfig, BinlogConnectorConnection connection, EventDispatcher<P, TableId> dispatcher, ErrorHandler errorHandler, Clock clock, BinlogTaskContext<?> taskContext, BinlogDatabaseSchema schema, BinlogStreamingChangeEventSourceMetrics<?, P> metrics, SnapshotterService snapshotterService) {
        this.taskContext = taskContext;
        this.connectorConfig = connectorConfig;
        this.schema = schema;
        this.connection = connection;
        this.clock = clock;
        this.eventDispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.metrics = metrics;
        this.eventDeserializationFailureHandlingMode = connectorConfig.getEventProcessingFailureHandlingMode();
        this.inconsistentSchemaHandlingMode = connectorConfig.getInconsistentSchemaFailureHandlingMode();
        this.snapshotterService = snapshotterService;
        this.client = this.createBinaryLogClient(taskContext, connectorConfig, this.binaryLogClientThreads, connection);
        this.gtidDmlSourceFilter = this.getGtidDmlSourceFilter();
        this.isGtidModeEnabled = connection.isGtidModeEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context, P partition, O offsetContext) throws InterruptedException {
        BinaryLogClient.EventListener listener;
        if (!(this.snapshotterService.getSnapshotter() instanceof NeverSnapshotter)) {
            this.taskContext.getSchema().assureNonEmptySchema();
        }
        EnumSet skippedOperations = this.connectorConfig.getSkippedOperations();
        this.eventHandlers.put(EventType.STOP, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleServerStop(this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.HEARTBEAT, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleServerHeartbeat(partition, this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.INCIDENT, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleServerIncident(partition, this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.ROTATE, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleRotateLogsEvent(this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.TABLE_MAP, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleUpdateTableMetadata(partition, this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.QUERY, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleQueryEvent(partition, this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.TRANSACTION_PAYLOAD, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleTransactionPayload(partition, this.effectiveOffsetContext, (Event)event)));
        if (!skippedOperations.contains(Envelope.Operation.CREATE)) {
            this.eventHandlers.put(EventType.WRITE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleInsert(partition, this.effectiveOffsetContext, (Event)event)));
            this.eventHandlers.put(EventType.EXT_WRITE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleInsert(partition, this.effectiveOffsetContext, (Event)event)));
        }
        if (!skippedOperations.contains(Envelope.Operation.UPDATE)) {
            this.eventHandlers.put(EventType.UPDATE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleUpdate(partition, this.effectiveOffsetContext, (Event)event)));
            this.eventHandlers.put(EventType.EXT_UPDATE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleUpdate(partition, this.effectiveOffsetContext, (Event)event)));
        }
        if (!skippedOperations.contains(Envelope.Operation.DELETE)) {
            this.eventHandlers.put(EventType.DELETE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleDelete(partition, this.effectiveOffsetContext, (Event)event)));
            this.eventHandlers.put(EventType.EXT_DELETE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleDelete(partition, this.effectiveOffsetContext, (Event)event)));
        }
        this.eventHandlers.put(EventType.VIEW_CHANGE, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.viewChange(this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.XA_PREPARE, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.prepareTransaction(this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.XID, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleTransactionCompletion(partition, this.effectiveOffsetContext, (Event)event)));
        if (this.connectorConfig.isSqlQueryIncluded()) {
            EventType eventType = this.getIncludeQueryEventType();
            this.eventHandlers.put(eventType, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleRecordingQuery(this.effectiveOffsetContext, (Event)event)));
        }
        if (this.connectorConfig.getBufferSizeForStreamingChangeEventSource() == 0) {
            listener = event -> this.handleEvent(partition, this.effectiveOffsetContext, context, event);
        } else {
            EventBuffer buffer = new EventBuffer(this.connectorConfig.getBufferSizeForStreamingChangeEventSource(), this, context);
            listener = event -> buffer.add(partition, this.effectiveOffsetContext, event);
        }
        this.client.registerEventListener(listener);
        this.client.registerLifecycleListener((BinaryLogClient.LifecycleListener)new ReaderThreadLifecycleListener(this, this.effectiveOffsetContext));
        this.client.registerEventListener(event -> this.onEvent(this.effectiveOffsetContext, event));
        if (LOGGER.isDebugEnabled()) {
            this.client.registerEventListener(event -> this.logEvent(this.effectiveOffsetContext, event));
        }
        this.metrics.setIsGtidModeEnabled(this.isGtidModeEnabled);
        if (this.isGtidModeEnabled) {
            this.eventHandlers.put(this.getGtidEventType(), (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleGtidEvent(partition, this.effectiveOffsetContext, (Event)event, this.gtidDmlSourceFilter)));
            GtidSet availableServerGtidSet = this.connection.knownGtidSet();
            GtidSet purgedServerGtidSet = this.connection.purgedGtidSet();
            LOGGER.info("GTID set purged on server: '{}'", (Object)purgedServerGtidSet);
            GtidSet filteredGtidSet = this.connection.filterGtidSet(this.connectorConfig.getGtidSourceFilter(), ((BinlogOffsetContext)((Object)this.effectiveOffsetContext)).gtidSet(), availableServerGtidSet, purgedServerGtidSet);
            if (filteredGtidSet != null) {
                LOGGER.info("Registering binlog reader with GTID set: '{}'", (Object)filteredGtidSet);
                String filteredGtidSetStr = filteredGtidSet.toString();
                this.client.setGtidSet(filteredGtidSetStr);
                ((BinlogOffsetContext)((Object)this.effectiveOffsetContext)).setCompletedGtidSet(filteredGtidSetStr);
                this.initializeGtidSet(filteredGtidSetStr);
            } else {
                this.client.setBinlogFilename(((BinlogSourceInfo)((Object)((BinlogOffsetContext)((Object)this.effectiveOffsetContext)).getSource())).binlogFilename());
                this.client.setBinlogPosition(((BinlogSourceInfo)((Object)((BinlogOffsetContext)((Object)this.effectiveOffsetContext)).getSource())).binlogPosition());
                this.initializeGtidSet("");
            }
        } else {
            this.client.setBinlogFilename(((BinlogSourceInfo)((Object)((BinlogOffsetContext)((Object)this.effectiveOffsetContext)).getSource())).binlogFilename());
            this.client.setBinlogPosition(((BinlogSourceInfo)((Object)((BinlogOffsetContext)((Object)this.effectiveOffsetContext)).getSource())).binlogPosition());
        }
        this.initialEventsToSkip = ((BinlogOffsetContext)((Object)this.effectiveOffsetContext)).eventsToSkipUponRestart();
        LOGGER.info("Skip {} events on streaming start", (Object)this.initialEventsToSkip);
        this.startingRowNumber = ((BinlogOffsetContext)((Object)this.effectiveOffsetContext)).rowsToSkipUponRestart();
        LOGGER.info("Skip {} rows on streaming start", (Object)this.startingRowNumber);
        this.skipEvent = false;
        try {
            if (context.isRunning()) {
                long timeout = this.connectorConfig.getConnectionTimeout().toMillis();
                long started = this.clock.currentTimeInMillis();
                try {
                    LOGGER.debug("Attempting to establish binlog reader connection with timeout of {} ms", (Object)timeout);
                    this.client.connect(timeout);
                    if (this.client.isKeepAlive()) {
                        LOGGER.info("Waiting for keepalive thread to start");
                        Metronome metronome = Metronome.parker((Duration)Duration.ofMillis(100L), (Clock)this.clock);
                        int waitAttempts = 50;
                        boolean keepAliveThreadRunning = false;
                        while (!keepAliveThreadRunning && waitAttempts-- > 0) {
                            for (Thread t : this.binaryLogClientThreads.values()) {
                                if (!t.getName().startsWith(KEEPALIVE_THREAD_NAME) || !t.isAlive()) continue;
                                LOGGER.info("Keepalive thread is running");
                                keepAliveThreadRunning = true;
                            }
                            metronome.pause();
                        }
                    }
                }
                catch (TimeoutException e) {
                    long duration = this.clock.currentTimeInMillis() - started;
                    if ((double)duration > 0.9 * (double)timeout) {
                        double actualSeconds = TimeUnit.MILLISECONDS.toSeconds(duration);
                        throw new DebeziumException(String.format("Timed out after %f seconds while waiting to connect to database at %s:%d with user '%s'", actualSeconds, this.connectorConfig.getHostName(), this.connectorConfig.getPort(), this.connectorConfig.getUserName()), (Throwable)e);
                    }
                }
                catch (AuthenticationException e) {
                    throw new DebeziumException(String.format("Failed to authenticate to the database at %s:%d with user '%s'", this.connectorConfig.getHostName(), this.connectorConfig.getPort(), this.connectorConfig.getUserName()), (Throwable)e);
                }
                catch (Throwable e) {
                    throw new DebeziumException(String.format("Unable to connect to the database at %s:%d with user '%s': %s", this.connectorConfig.getHostName(), this.connectorConfig.getPort(), this.connectorConfig.getUserName(), e.getMessage()), e);
                }
            }
            while (context.isRunning()) {
                Thread.sleep(100L);
                this.waitWhenStreamingPaused(context);
            }
        }
        finally {
            try {
                this.client.disconnect();
            }
            catch (Exception e) {
                LOGGER.info("Exception while stopping binary log client", (Throwable)e);
            }
        }
    }

    public O getOffsetContext() {
        return this.effectiveOffsetContext;
    }

    protected void setEffectiveOffsetContext(O offsetContext) {
        this.effectiveOffsetContext = offsetContext;
    }

    protected void setIgnoreDmlEventByGtidSource(boolean ignoreDmlEventByGtidSource) {
        this.ignoreDmlEventByGtidSource = ignoreDmlEventByGtidSource;
    }

    protected void setGtidChanged(String gtid) {
        this.metrics.onGtidChange(gtid);
    }

    protected boolean isGtidModeEnabled() {
        return this.isGtidModeEnabled;
    }

    protected BinaryLogClient createBinaryLogClient(BinlogTaskContext<?> taskContext, BinlogConnectorConfig connectorConfig, Map<String, Thread> clientThreads, BinlogConnectorConnection connection) {
        SSLSocketFactory sslSocketFactory;
        BinaryLogClient client = taskContext.getBinaryLogClient();
        client.setThreadFactory(Threads.threadFactory(this.getConnectorClass(), (String)connectorConfig.getLogicalName(), (String)"binlog-client", (boolean)false, (boolean)false, x -> clientThreads.put(x.getName(), (Thread)x)));
        client.setServerId(connectorConfig.getServerId());
        client.setSSLMode(this.sslModeFor(connectorConfig.getSslMode()));
        if (connectorConfig.isSslModeEnabled() && (sslSocketFactory = this.getBinlogSslSocketFactory(connectorConfig, connection)) != null) {
            client.setSslSocketFactory(sslSocketFactory);
        }
        client.setUseNonGracefulDisconnect(connectorConfig.usesNonGracefulDisconnect());
        this.configureReplicaCompatibility(client);
        Configuration configuration = connectorConfig.getConfig();
        long keepAliveInterval = configuration.getLong(BinlogConnectorConfig.KEEP_ALIVE_INTERVAL_MS);
        client.setKeepAlive(configuration.getBoolean(BinlogConnectorConfig.KEEP_ALIVE));
        client.setKeepAliveInterval(keepAliveInterval);
        client.setHeartbeatInterval((long)((float)keepAliveInterval * 0.8f));
        client.setEventDeserializer(this.createEventDeserializer());
        return client;
    }

    protected void configureReplicaCompatibility(BinaryLogClient client) {
    }

    protected EventDeserializer createEventDeserializer() {
        final HashMap<Long, TableMapEventData> tableMapEventByTableId = new HashMap<Long, TableMapEventData>();
        EventDeserializer eventDeserializer = new EventDeserializer(){

            public Event nextEvent(ByteArrayInputStream inputStream) throws IOException {
                try {
                    Event event = super.nextEvent(inputStream);
                    if (event.getHeader().getEventType() == EventType.TABLE_MAP) {
                        TableMapEventData tableMapEvent = (TableMapEventData)event.getData();
                        tableMapEventByTableId.put(tableMapEvent.getTableId(), tableMapEvent);
                    }
                    if (event.getHeader().getEventType() == EventType.TRANSACTION_PAYLOAD) {
                        TransactionPayloadEventData transactionPayloadEventData = (TransactionPayloadEventData)event.getData();
                        for (Event uncompressedEvent : transactionPayloadEventData.getUncompressedEvents()) {
                            if (uncompressedEvent.getHeader().getEventType() != EventType.TABLE_MAP || uncompressedEvent.getData() == null) continue;
                            TableMapEventData tableMapEvent = (TableMapEventData)uncompressedEvent.getData();
                            tableMapEventByTableId.put(tableMapEvent.getTableId(), tableMapEvent);
                        }
                    }
                    if (event.getHeader().getEventType() == EventType.ROTATE && event.getHeader().getTimestamp() != 0L) {
                        tableMapEventByTableId.clear();
                    }
                    return event;
                }
                catch (EventDataDeserializationException edde) {
                    if (edde.getCause() instanceof IOException) {
                        throw edde;
                    }
                    EventHeaderV4 header = new EventHeaderV4();
                    header.setEventType(EventType.INCIDENT);
                    header.setTimestamp(edde.getEventHeader().getTimestamp());
                    header.setServerId(edde.getEventHeader().getServerId());
                    if (edde.getEventHeader() instanceof EventHeaderV4) {
                        header.setEventLength(((EventHeaderV4)edde.getEventHeader()).getEventLength());
                        header.setNextPosition(((EventHeaderV4)edde.getEventHeader()).getNextPosition());
                        header.setFlags(((EventHeaderV4)edde.getEventHeader()).getFlags());
                    }
                    EventDataDeserializationExceptionData data = new EventDataDeserializationExceptionData(edde);
                    return new Event((EventHeader)header, (EventData)data);
                }
            }
        };
        eventDeserializer.setEventDataDeserializer(EventType.STOP, (EventDataDeserializer)new StopEventDataDeserializer());
        eventDeserializer.setEventDataDeserializer(EventType.GTID, (EventDataDeserializer)new GtidEventDataDeserializer());
        eventDeserializer.setEventDataDeserializer(EventType.WRITE_ROWS, (EventDataDeserializer)new RowDeserializers.WriteRowsDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode));
        eventDeserializer.setEventDataDeserializer(EventType.UPDATE_ROWS, (EventDataDeserializer)new RowDeserializers.UpdateRowsDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode));
        eventDeserializer.setEventDataDeserializer(EventType.DELETE_ROWS, (EventDataDeserializer)new RowDeserializers.DeleteRowsDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_WRITE_ROWS, (EventDataDeserializer)new RowDeserializers.WriteRowsDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode).setMayContainExtraInformation(true));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_UPDATE_ROWS, (EventDataDeserializer)new RowDeserializers.UpdateRowsDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode).setMayContainExtraInformation(true));
        eventDeserializer.setEventDataDeserializer(EventType.EXT_DELETE_ROWS, (EventDataDeserializer)new RowDeserializers.DeleteRowsDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode).setMayContainExtraInformation(true));
        eventDeserializer.setEventDataDeserializer(EventType.TRANSACTION_PAYLOAD, (EventDataDeserializer)new TransactionPayloadDeserializer(tableMapEventByTableId, this.eventDeserializationFailureHandlingMode));
        return eventDeserializer;
    }

    protected void onEvent(O offsetContext, Event event) {
        long ts = 0L;
        if (event.getHeader().getEventType() == EventType.HEARTBEAT) {
            this.metrics.setMilliSecondsBehindSource(ts);
            return;
        }
        long eventTs = event.getHeader().getTimestamp();
        if (eventTs == 0L) {
            LOGGER.trace("Received unexpected event with 0 timestamp: {}", (Object)event);
            return;
        }
        this.setEventTimestamp(event, eventTs);
        ts = this.clock.currentTimeInMillis() - this.eventTimestamp.toEpochMilli();
        LOGGER.trace("Current milliseconds behind source: {} ms", (Object)ts);
        this.metrics.setMilliSecondsBehindSource(ts);
    }

    protected abstract void setEventTimestamp(Event var1, long var2);

    protected void ignoreEvent(O offsetContext, Event event) {
        LOGGER.trace("Ignoring event due to missing handler: {}", (Object)event);
    }

    protected void handleEvent(P partition, O offsetContext, ChangeEventSource.ChangeEventSourceContext context, Event event) {
        if (event == null) {
            return;
        }
        EventHeader eventHeader = event.getHeader();
        ((BinlogOffsetContext)((Object)offsetContext)).setBinlogServerId(eventHeader.getServerId());
        EventType eventType = eventHeader.getEventType();
        if (eventType == EventType.ROTATE) {
            EventData eventData = event.getData();
            RotateEventData rotateEventData = eventData instanceof EventDeserializer.EventDataWrapper ? (RotateEventData)((EventDeserializer.EventDataWrapper)eventData).getInternal() : (RotateEventData)eventData;
            ((BinlogOffsetContext)((Object)offsetContext)).setBinlogStartPoint(rotateEventData.getBinlogFilename(), rotateEventData.getBinlogPosition());
        } else if (eventHeader instanceof EventHeaderV4) {
            EventHeaderV4 trackableEventHeader = (EventHeaderV4)eventHeader;
            ((BinlogOffsetContext)((Object)offsetContext)).setEventPosition(trackableEventHeader.getPosition(), trackableEventHeader.getEventLength());
        }
        try {
            this.waitWhenStreamingPaused(context);
            this.eventHandlers.getOrDefault(eventType, (BlockingConsumer<Event>)((BlockingConsumer)e -> this.ignoreEvent(offsetContext, (Event)e))).accept((Object)event);
            this.eventDispatcher.dispatchHeartbeatEvent(partition, offsetContext);
            ((BinlogOffsetContext)((Object)offsetContext)).completeEvent();
            this.lastOffset = ((BinlogOffsetContext)((Object)offsetContext)).getOffset();
            if (this.skipEvent) {
                --this.initialEventsToSkip;
                this.skipEvent = this.initialEventsToSkip > 0L;
            }
        }
        catch (RuntimeException e2) {
            this.logStreamingSourceState();
            this.errorHandler.setProducerThrowable((Throwable)new DebeziumException("Error processing binlog event", (Throwable)e2));
            this.eventHandlers.clear();
            LOGGER.info("Error processing binlog event, and propagating to Kafka Connect so it stops this connector. Future binlog events read before connector is shutdown will be ignored.");
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            this.eventHandlers.clear();
            LOGGER.info("Stopped processing binlog events due to thread interruption");
        }
    }

    protected <T extends EventData> T unwrapData(Event event) {
        EventData eventData = event.getData();
        if (eventData instanceof EventDeserializer.EventDataWrapper) {
            eventData = ((EventDeserializer.EventDataWrapper)eventData).getInternal();
        }
        return (T)eventData;
    }

    protected void handleServerStop(O offsetContext, Event event) {
        LOGGER.debug("Server stopped: {}", (Object)event);
    }

    protected void handleServerHeartbeat(P partition, O offsetContext, Event event) throws InterruptedException {
        LOGGER.trace("Server heartbeat: {}", (Object)event);
        this.eventDispatcher.dispatchServerHeartbeatEvent(partition, offsetContext);
    }

    protected void handleServerIncident(P partition, O offsetContext, Event event) {
        if (event.getData() instanceof EventDataDeserializationExceptionData) {
            this.metrics.onErroneousEvent((Partition)partition, "source = " + String.valueOf(event));
            EventDataDeserializationExceptionData data = (EventDataDeserializationExceptionData)event.getData();
            EventHeaderV4 eventHeader = (EventHeaderV4)data.getCause().getEventHeader();
            if (this.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL) {
                LOGGER.error("Error while deserializing binlog event at offset {}.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{((BinlogOffsetContext)((Object)offsetContext)).getOffset(), System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), ((BinlogSourceInfo)((Object)((BinlogOffsetContext)((Object)offsetContext)).getSource())).binlogFilename()});
                throw new RuntimeException(data.getCause());
            }
            if (this.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN) {
                LOGGER.warn("Error while deserializing binlog event at offset {}.{}This exception will be ignored and the event be skipped.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{((BinlogOffsetContext)((Object)offsetContext)).getOffset(), System.lineSeparator(), System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), ((BinlogSourceInfo)((Object)((BinlogOffsetContext)((Object)offsetContext)).getSource())).binlogFilename(), data.getCause()});
            }
        } else {
            LOGGER.error("Server incident: {}", (Object)event);
        }
    }

    protected void handleRotateLogsEvent(O offsetContext, Event event) {
        LOGGER.debug("Rotating logs: {}", (Object)event);
        RotateEventData command = (RotateEventData)this.unwrapData(event);
        assert (command != null);
        this.schema.clearTableMappings();
    }

    protected void handleQueryEvent(P partition, O offsetContext, Event event) throws InterruptedException {
        Instant eventTime = Conversions.toInstantFromMillis((long)this.eventTimestamp.toEpochMilli());
        QueryEventData command = (QueryEventData)this.unwrapData(event);
        LOGGER.debug("Received query command: {}", (Object)event);
        String sql = command.getSql().trim();
        if (sql.equalsIgnoreCase("BEGIN")) {
            this.handleTransactionBegin(partition, offsetContext, event, command.getThreadId());
            return;
        }
        if (sql.equalsIgnoreCase("COMMIT")) {
            this.handleTransactionCompletion(partition, offsetContext, event);
            return;
        }
        String upperCasedStatementBegin = Strings.getBegin((String)this.removeSetStatement(sql), (int)7).toUpperCase();
        if (upperCasedStatementBegin.startsWith("XA ")) {
            return;
        }
        if (this.schema.ddlFilter().test(sql)) {
            LOGGER.debug("DDL '{}' was filtered out of processing", (Object)sql);
            return;
        }
        if (upperCasedStatementBegin.equals("INSERT ") || upperCasedStatementBegin.equals("UPDATE ") || upperCasedStatementBegin.equals("DELETE ")) {
            LOGGER.warn("Received DML '" + sql + "' for processing, binlog probably contains events generated with statement or mixed based replication format");
            return;
        }
        if (sql.equalsIgnoreCase("ROLLBACK")) {
            LOGGER.warn("Rollback statements cannot be handled without binlog buffering, the connector will fail. Please check '{}' to see how to enable buffering", (Object)BinlogConnectorConfig.BUFFER_SIZE_FOR_BINLOG_READER.name());
        }
        List<SchemaChangeEvent> schemaChangeEvents = this.schema.parseStreamingDdl(partition, sql, command.getDatabase(), offsetContext, eventTime);
        try {
            for (SchemaChangeEvent schemaChangeEvent : schemaChangeEvents) {
                TableId tableId;
                if (this.schema.skipSchemaChangeEvent(schemaChangeEvent)) continue;
                TableId tableId2 = tableId = schemaChangeEvent.getTables().isEmpty() ? null : ((Table)schemaChangeEvent.getTables().iterator().next()).id();
                if (tableId != null && !this.connectorConfig.getSkippedOperations().contains(Envelope.Operation.TRUNCATE) && schemaChangeEvent.getType().equals((Object)SchemaChangeEvent.SchemaChangeEventType.TRUNCATE)) {
                    this.eventDispatcher.dispatchDataChangeEvent(partition, (DataCollectionId)tableId, new BinlogChangeRecordEmitter<P>(partition, (OffsetContext)offsetContext, this.clock, Envelope.Operation.TRUNCATE, null, null, this.connectorConfig));
                }
                this.eventDispatcher.dispatchSchemaChangeEvent(partition, offsetContext, (DataCollectionId)tableId, receiver -> {
                    try {
                        receiver.schemaChangeEvent(schemaChangeEvent);
                    }
                    catch (Exception e) {
                        throw new DebeziumException((Throwable)e);
                    }
                });
            }
        }
        catch (InterruptedException e) {
            LOGGER.info("Processing interrupted");
        }
    }

    private String removeSetStatement(String sql) {
        return sql.replaceAll(SET_STATEMENT_REGEX, "").trim();
    }

    protected void handleUpdateTableMetadata(P partition, O offsetContext, Event event) throws InterruptedException {
        String tableName;
        String databaseName;
        TableId tableId;
        TableMapEventData metadata = (TableMapEventData)this.unwrapData(event);
        long tableNumber = metadata.getTableId();
        if (this.schema.assignTableNumber(tableNumber, tableId = new TableId(databaseName = metadata.getDatabase(), null, tableName = metadata.getTable()))) {
            LOGGER.debug("Received update table metadata event: {}", (Object)event);
        } else {
            this.informAboutUnknownTableIfRequired(partition, offsetContext, event, tableId);
        }
    }

    protected void handleTransactionPayload(P partition, O offsetContext, Event event) throws InterruptedException {
        TransactionPayloadEventData transactionPayloadEventData = (TransactionPayloadEventData)event.getData();
        for (Event uncompressedEvent : transactionPayloadEventData.getUncompressedEvents()) {
            this.eventHandlers.getOrDefault(uncompressedEvent.getHeader().getEventType(), (BlockingConsumer<Event>)((BlockingConsumer)e -> this.ignoreEvent(offsetContext, uncompressedEvent))).accept((Object)uncompressedEvent);
        }
    }

    protected void handleInsert(P partition, O offsetContext, Event event) throws InterruptedException {
        this.handleChange(partition, offsetContext, event, Envelope.Operation.CREATE, WriteRowsEventData.class, x -> this.schema.getTableId(x.getTableId()), WriteRowsEventData::getRows, (tableId, row) -> this.eventDispatcher.dispatchDataChangeEvent((Partition)partition, (DataCollectionId)tableId, new BinlogChangeRecordEmitter<BinlogPartition>((BinlogPartition)((Object)partition), (OffsetContext)offsetContext, this.clock, Envelope.Operation.CREATE, null, (Serializable[])row, this.connectorConfig)), (tableId, row) -> this.validateChangeEventWithTable(this.taskContext.getSchema().tableFor(tableId), null, (Object[])row));
    }

    protected void handleUpdate(P partition, O offsetContext, Event event) throws InterruptedException {
        this.handleChange(partition, offsetContext, event, Envelope.Operation.UPDATE, UpdateRowsEventData.class, x -> this.schema.getTableId(x.getTableId()), UpdateRowsEventData::getRows, (tableId, row) -> this.eventDispatcher.dispatchDataChangeEvent((Partition)partition, (DataCollectionId)tableId, new BinlogChangeRecordEmitter<BinlogPartition>((BinlogPartition)((Object)partition), (OffsetContext)offsetContext, this.clock, Envelope.Operation.UPDATE, (Serializable[])row.getKey(), (Serializable[])row.getValue(), this.connectorConfig)), (tableId, row) -> this.validateChangeEventWithTable(this.taskContext.getSchema().tableFor(tableId), (Object[])row.getKey(), (Object[])row.getValue()));
    }

    protected void handleDelete(P partition, O offsetContext, Event event) throws InterruptedException {
        this.handleChange(partition, offsetContext, event, Envelope.Operation.DELETE, DeleteRowsEventData.class, x -> this.schema.getTableId(x.getTableId()), DeleteRowsEventData::getRows, (tableId, row) -> this.eventDispatcher.dispatchDataChangeEvent((Partition)partition, (DataCollectionId)tableId, new BinlogChangeRecordEmitter<BinlogPartition>((BinlogPartition)((Object)partition), (OffsetContext)offsetContext, this.clock, Envelope.Operation.DELETE, (Serializable[])row, null, this.connectorConfig)), (tableId, row) -> this.validateChangeEventWithTable(this.taskContext.getSchema().tableFor(tableId), (Object[])row, null));
    }

    protected void viewChange(O offsetContext, Event event) throws InterruptedException {
        LOGGER.debug("View Change event: {}", (Object)event);
    }

    protected void prepareTransaction(O offsetContext, Event event) throws InterruptedException {
        LOGGER.debug("XA Prepare event: {}", (Object)event);
    }

    protected void handleTransactionBegin(P partition, O offsetContext, Event event, Long threadId) throws InterruptedException {
        Instant eventTime = Conversions.toInstantFromMillis((long)this.eventTimestamp.toEpochMilli());
        ((BinlogOffsetContext)((Object)offsetContext)).startNextTransaction();
        this.eventDispatcher.dispatchTransactionStartedEvent(partition, ((BinlogOffsetContext)((Object)offsetContext)).getTransactionId(), offsetContext, eventTime);
        if (threadId != null) {
            ((BinlogOffsetContext)((Object)offsetContext)).setBinlogThread(threadId);
        }
        if (this.initialEventsToSkip != 0L) {
            LOGGER.debug("Restarting partially-processed transaction; change events will not be created for the first {} events plus {} more rows in the next event", (Object)this.initialEventsToSkip, (Object)this.startingRowNumber);
            this.skipEvent = true;
        }
    }

    protected abstract Class<? extends SourceConnector> getConnectorClass();

    protected abstract void handleGtidEvent(P var1, O var2, Event var3, Predicate<String> var4) throws InterruptedException;

    protected abstract void handleRecordingQuery(O var1, Event var2);

    protected abstract EventType getIncludeQueryEventType();

    protected abstract EventType getGtidEventType();

    protected abstract void initializeGtidSet(String var1);

    private Predicate<String> getGtidDmlSourceFilter() {
        if (this.connectorConfig.getConfig().getBoolean(BinlogConnectorConfig.GTID_SOURCE_FILTER_DML_EVENTS)) {
            return this.connectorConfig.getGtidSourceFilter();
        }
        return null;
    }

    private void handleTransactionCompletion(P partition, O offsetContext, Event event) throws InterruptedException {
        this.eventDispatcher.dispatchTransactionCommittedEvent(partition, offsetContext, Conversions.toInstantFromMillis((long)this.eventTimestamp.toEpochMilli()));
        ((BinlogOffsetContext)((Object)offsetContext)).commitTransaction();
        ((BinlogOffsetContext)((Object)offsetContext)).setBinlogThread(-1L);
        this.skipEvent = false;
        this.ignoreDmlEventByGtidSource = false;
    }

    private void informAboutUnknownTableIfRequired(P partition, O offsetContext, Event event, TableId tableId, Envelope.Operation operation) throws InterruptedException {
        if (tableId != null && this.connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
            this.metrics.onErroneousEvent((Partition)partition, "source = " + String.valueOf(tableId) + ", event " + String.valueOf(event), operation);
            EventHeaderV4 eventHeader = (EventHeaderV4)event.getHeader();
            if (this.inconsistentSchemaHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL) {
                LOGGER.error("Encountered change event '{}' at offset {} for table {} whose schema isn't known to this connector. One possible cause is an incomplete database schema history topic. Take a new snapshot in this case.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{event, ((BinlogOffsetContext)((Object)offsetContext)).getOffset(), tableId, System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), ((BinlogSourceInfo)((Object)((BinlogOffsetContext)((Object)offsetContext)).getSource())).binlogFilename()});
                throw new DebeziumException("Encountered change event for table " + String.valueOf(tableId) + " whose schema isn't known to this connector");
            }
            if (this.inconsistentSchemaHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN) {
                LOGGER.warn("Encountered change event '{}' at offset {} for table {} whose schema isn't known to this connector. One possible cause is an incomplete database schema history topic. Take a new snapshot in this case.{}The event will be ignored.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{event, ((BinlogOffsetContext)((Object)offsetContext)).getOffset(), tableId, System.lineSeparator(), System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), ((BinlogSourceInfo)((Object)((BinlogOffsetContext)((Object)offsetContext)).getSource())).binlogFilename()});
            } else {
                LOGGER.debug("Encountered change event '{}' at offset {} for table {} whose schema isn't known to this connector. One possible cause is an incomplete database schema history topic. Take a new snapshot in this case.{}The event will be ignored.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{event, ((BinlogOffsetContext)((Object)offsetContext)).getOffset(), tableId, System.lineSeparator(), System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), ((BinlogSourceInfo)((Object)((BinlogOffsetContext)((Object)offsetContext)).getSource())).binlogFilename()});
            }
        } else {
            if (tableId == null) {
                Object eventData = this.unwrapData(event);
                if (eventData instanceof WriteRowsEventData) {
                    tableId = this.schema.getExcludeTableId(((WriteRowsEventData)eventData).getTableId());
                } else if (eventData instanceof UpdateRowsEventData) {
                    tableId = this.schema.getExcludeTableId(((UpdateRowsEventData)eventData).getTableId());
                } else if (eventData instanceof DeleteRowsEventData) {
                    tableId = this.schema.getExcludeTableId(((DeleteRowsEventData)eventData).getTableId());
                }
            }
            LOGGER.trace("Filtered {} event for {}", (Object)event.getHeader().getEventType(), (Object)tableId);
            this.metrics.onFilteredEvent((Partition)partition, "source = " + String.valueOf(tableId), operation);
            this.eventDispatcher.dispatchFilteredEvent(partition, offsetContext);
        }
    }

    private void informAboutUnknownTableIfRequired(P partition, O offsetContext, Event event, TableId tableId) throws InterruptedException {
        this.informAboutUnknownTableIfRequired(partition, offsetContext, event, tableId, null);
    }

    private void validateChangeEventWithTable(Table table, Object[] before, Object[] after) {
        if (table != null) {
            int columnSize = table.columns().size();
            String message = "Error processing {} of row in {} because it's different column size with internal schema size {}, but {} size {}, restart connector with schema recovery mode.";
            if (before != null && columnSize != before.length) {
                LOGGER.error(message, new Object[]{"before", table.id().table(), columnSize, "before", before.length});
                throw new DebeziumException("Error processing row in " + table.id().table() + ", internal schema size " + columnSize + ", but row size " + before.length + " , restart connector with schema recovery mode.");
            }
            if (after != null && columnSize != after.length) {
                LOGGER.error(message, new Object[]{"after", table.id().table(), columnSize, "after", after.length});
                throw new DebeziumException("Error processing row in " + table.id().table() + ", internal schema size " + columnSize + ", but row size " + after.length + " , restart connector with schema recovery mode.");
            }
        }
    }

    private <T extends EventData, U> void handleChange(P partition, O offsetContext, Event event, Envelope.Operation operation, Class<T> eventDataClass, TableIdProvider<T> tableIdProvider, RowsProvider<T, U> rowsProvider, BinlogChangeEmitter<U> changeEmitter, ChangeEventValidator<U> changeEventValidator) throws InterruptedException {
        if (this.skipEvent) {
            LOGGER.info("Skipping previously processed row event: {}", (Object)event);
            return;
        }
        if (this.ignoreDmlEventByGtidSource) {
            LOGGER.debug("Skipping DML event because this GTID source is filtered: {}", (Object)event);
            return;
        }
        T data = this.unwrapData(event);
        TableId tableId = tableIdProvider.getTableId(data);
        List<U> rows = rowsProvider.getRows(data);
        String changeType = operation.name();
        if (tableId != null && this.taskContext.getSchema().schemaFor(tableId) != null) {
            int count = 0;
            int numRows = rows.size();
            if (this.startingRowNumber < numRows) {
                for (int rowIndex = this.startingRowNumber; rowIndex != numRows; ++rowIndex) {
                    U row = rows.get(rowIndex);
                    changeEventValidator.validate(tableId, row);
                    ((BinlogOffsetContext)((Object)offsetContext)).setRowNumber(rowIndex, numRows);
                    ((BinlogOffsetContext)((Object)offsetContext)).event((DataCollectionId)tableId, this.eventTimestamp);
                    changeEmitter.emit(tableId, row);
                    ++count;
                }
                if (LOGGER.isDebugEnabled()) {
                    if (this.startingRowNumber != 0) {
                        LOGGER.debug("Emitted {} {} record(s) for last {} row(s) in event: {}", new Object[]{count, changeType, numRows - this.startingRowNumber, event});
                    } else {
                        LOGGER.debug("Emitted {} {} record(s) for event: {}", new Object[]{count, changeType, event});
                    }
                }
                ((BinlogOffsetContext)((Object)offsetContext)).changeEventCompleted();
            } else {
                LOGGER.debug("Skipping previously processed {} event: {}", (Object)changeType, (Object)event);
            }
        } else {
            this.informAboutUnknownTableIfRequired(partition, offsetContext, event, tableId, operation);
        }
        this.startingRowNumber = 0;
    }

    private void waitWhenStreamingPaused(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        if (context.isPaused()) {
            LOGGER.info("Streaming will now pause");
            context.streamingPaused();
            context.waitSnapshotCompletion();
            LOGGER.info("Streaming resumed");
        }
    }

    private void logStreamingSourceState() {
        this.logStreamingSourceState(Level.ERROR);
    }

    protected void logEvent(O offsetContext, Event event) {
        LOGGER.trace("Received event: {}", (Object)event);
    }

    private void logStreamingSourceState(Level severity) {
        String position = this.client == null ? "N/A" : this.client.getBinlogFilename() + "/" + this.client.getBinlogPosition();
        String message = "Error during binlog processing. Last offset stored = {}, binlog reader near position = {}";
        switch (severity) {
            case WARN: {
                LOGGER.warn("Error during binlog processing. Last offset stored = {}, binlog reader near position = {}", this.lastOffset, (Object)position);
                break;
            }
            case DEBUG: {
                LOGGER.debug("Error during binlog processing. Last offset stored = {}, binlog reader near position = {}", this.lastOffset, (Object)position);
                break;
            }
            default: {
                LOGGER.error("Error during binlog processing. Last offset stored = {}, binlog reader near position = {}", this.lastOffset, (Object)position);
            }
        }
    }

    BinlogStreamingChangeEventSourceMetrics<?, P> getMetrics() {
        return this.metrics;
    }

    void rewindBinaryLogClient(ChangeEventSource.ChangeEventSourceContext context, BinlogPosition position) {
        try {
            if (context.isRunning()) {
                LOGGER.debug("Rewinding binlog to position {}", (Object)position);
                this.client.disconnect();
                this.client.setBinlogFilename(position.getFilename());
                this.client.setBinlogPosition(position.getPosition());
                this.client.connect();
            }
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error when re-connecting to the MySQL binary log reader", (Throwable)e);
        }
    }

    BinlogPosition getCurrentBinlogPosition() {
        return new BinlogPosition(this.client.getBinlogFilename(), this.client.getBinlogPosition());
    }

    protected DebeziumException wrap(Throwable error) {
        assert (error != null);
        Object msg = error.getMessage();
        if (error instanceof ServerException) {
            ServerException e = (ServerException)error;
            msg = (String)msg + " Error code: " + e.getErrorCode() + "; SQLSTATE: " + e.getSqlState() + ".";
        } else if (error instanceof SQLException) {
            SQLException e = (SQLException)error;
            msg = e.getMessage() + " Error code: " + e.getErrorCode() + "; SQLSTATE: " + e.getSQLState() + ".";
        }
        return new DebeziumException((String)msg, error);
    }

    private SSLMode sslModeFor(BinlogConnectorConfig.SecureConnectionMode mode) {
        switch (mode) {
            case DISABLED: {
                return SSLMode.DISABLED;
            }
            case PREFERRED: {
                return SSLMode.PREFERRED;
            }
            case REQUIRED: {
                return SSLMode.REQUIRED;
            }
            case VERIFY_CA: {
                return SSLMode.VERIFY_CA;
            }
            case VERIFY_IDENTITY: {
                return SSLMode.VERIFY_IDENTITY;
            }
        }
        return null;
    }

    private SSLSocketFactory getBinlogSslSocketFactory(BinlogConnectorConfig connectorConfig, BinlogConnectorConnection connection) {
        String acceptedTlsVersion = connection.getSessionVariableForSslVersion();
        if (!Strings.isNullOrEmpty((String)acceptedTlsVersion)) {
            TrustManager[] trustManagers;
            SSLMode sslMode = this.sslModeFor(connectorConfig.getSslMode());
            LOGGER.info("Enable ssl " + String.valueOf(sslMode) + " mode for connector " + connectorConfig.getLogicalName());
            char[] keyPasswordArray = connection.connectionConfig().sslKeyStorePassword();
            String keyFilename = connection.connectionConfig().sslKeyStore();
            char[] trustPasswordArray = connection.connectionConfig().sslTrustStorePassword();
            String trustFilename = connection.connectionConfig().sslTrustStore();
            KeyManager[] keyManagers = null;
            if (keyFilename != null) {
                try {
                    KeyStore ks = connection.loadKeyStore(keyFilename, keyPasswordArray);
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance("NewSunX509");
                    kmf.init(ks, keyPasswordArray);
                    keyManagers = kmf.getKeyManagers();
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    throw new DebeziumException("Could not load keystore", (Throwable)e);
                }
            }
            try {
                KeyStore ks = null;
                if (trustFilename != null) {
                    ks = connection.loadKeyStore(trustFilename, trustPasswordArray);
                }
                if (ks == null && (sslMode == SSLMode.PREFERRED || sslMode == SSLMode.REQUIRED)) {
                    trustManagers = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }};
                } else {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ks);
                    trustManagers = tmf.getTrustManagers();
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                throw new DebeziumException("Could not load truststore", (Throwable)e);
            }
            final KeyManager[] finalKMS = keyManagers;
            return new DefaultSSLSocketFactory(acceptedTlsVersion){

                protected void initSSLContext(SSLContext sc) throws GeneralSecurityException {
                    sc.init(finalKMS, trustManagers, null);
                }
            };
        }
        return null;
    }

    protected static final class ReaderThreadLifecycleListener
    implements BinaryLogClient.LifecycleListener {
        private final O offsetContext;
        final /* synthetic */ BinlogStreamingChangeEventSource this$0;

        ReaderThreadLifecycleListener(O offsetContext) {
            this.this$0 = this$0;
            this.offsetContext = offsetContext;
        }

        public void onDisconnect(BinaryLogClient client) {
            if (LOGGER.isInfoEnabled()) {
                this.this$0.taskContext.temporaryLoggingContext((CommonConnectorConfig)this.this$0.connectorConfig, "binlog", () -> {
                    Map<String, ?> offset = this.this$0.lastOffset;
                    if (offset != null) {
                        LOGGER.info("Stopped reading binlog after {} events, last recorded offset: {}", (Object)this.this$0.totalRecordCounter, offset);
                    } else {
                        LOGGER.info("Stopped reading binlog after {} events, no new offset was recorded", (Object)this.this$0.totalRecordCounter);
                    }
                });
            }
        }

        public void onConnect(BinaryLogClient client) {
            this.this$0.taskContext.configureLoggingContext("binlog");
            LOGGER.info("Connected to binlog at {}:{}, starting at {}", new Object[]{this.this$0.connectorConfig.getHostName(), this.this$0.connectorConfig.getPort(), this.offsetContext});
        }

        public void onCommunicationFailure(BinaryLogClient client, Exception ex) {
            LOGGER.debug("A communication failure event arrived", (Throwable)ex);
            this.this$0.logStreamingSourceState();
            try {
                client.disconnect();
            }
            catch (Exception e) {
                LOGGER.debug("Exception while closing client", (Throwable)e);
            }
            this.this$0.errorHandler.setProducerThrowable((Throwable)this.this$0.wrap(ex));
        }

        public void onEventDeserializationFailure(BinaryLogClient client, Exception ex) {
            if (this.this$0.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL) {
                LOGGER.debug("A deserialization failure event arrived", (Throwable)ex);
                this.this$0.logStreamingSourceState();
                this.this$0.errorHandler.setProducerThrowable((Throwable)this.this$0.wrap(ex));
            } else if (this.this$0.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN) {
                LOGGER.warn("A deserialization failure event arrived", (Throwable)ex);
                this.this$0.logStreamingSourceState(Level.WARN);
            } else {
                LOGGER.debug("A deserialization failure event arrived", (Throwable)ex);
                this.this$0.logStreamingSourceState(Level.DEBUG);
            }
        }
    }

    @FunctionalInterface
    private static interface TableIdProvider<E extends EventData> {
        public TableId getTableId(E var1);
    }

    @FunctionalInterface
    private static interface RowsProvider<E extends EventData, U> {
        public List<U> getRows(E var1);
    }

    @FunctionalInterface
    private static interface BinlogChangeEmitter<T> {
        public void emit(TableId var1, T var2) throws InterruptedException;
    }

    @FunctionalInterface
    private static interface ChangeEventValidator<U> {
        public void validate(TableId var1, U var2);
    }

    public static class BinlogPosition {
        final String filename;
        final long position;

        public BinlogPosition(String filename, long position) {
            assert (filename != null);
            this.filename = filename;
            this.position = position;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getPosition() {
            return this.position;
        }

        public String toString() {
            return this.filename + "/" + this.position;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.filename.hashCode();
            result = 31 * result + (int)(this.position ^ this.position >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BinlogPosition other = (BinlogPosition)obj;
            if (!this.filename.equals(other.filename)) {
                return false;
            }
            return this.position == other.position;
        }
    }
}

