/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.jdbc.JdbcConnection;
import java.util.Map;
import java.util.Random;

public class MySqlUniqueDatabase
extends UniqueDatabase {
    public MySqlUniqueDatabase(String serverName, String databaseName) {
        this(serverName, databaseName, Integer.toUnsignedString(new Random().nextInt(), 36), null);
    }

    public MySqlUniqueDatabase(String serverName, String databaseName, String identifier, String charSet) {
        super(serverName, databaseName, identifier, charSet);
    }

    protected JdbcConnection forTestDatabase(String databaseName, Map<String, Object> urlProperties) {
        return MySqlTestConnection.forTestDatabase(databaseName, urlProperties);
    }

    public Configuration.Builder defaultJdbcConfigBuilder() {
        Configuration.Builder builder = super.defaultJdbcConfigBuilder();
        ((Configuration.Builder)builder.with(MySqlConnectorConfig.JDBC_PROTOCOL, System.getProperty("database.protocol", MySqlConnectorConfig.JDBC_PROTOCOL.defaultValueAsString()))).with(MySqlConnectorConfig.JDBC_DRIVER, System.getProperty("database.jdbc.driver", MySqlConnectorConfig.JDBC_DRIVER.defaultValueAsString()));
        return builder;
    }
}

