/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.BinlogDatabaseSchemaTest;
import io.debezium.connector.binlog.jdbc.BinlogValueConverters;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.jdbc.MySqlValueConverters;
import io.debezium.connector.mysql.util.MySqlValueConvertersFactory;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.history.AbstractSchemaHistory;
import io.debezium.schema.DefaultTopicNamingStrategy;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.spi.topic.TopicNamingStrategy;
import java.util.Set;
import org.assertj.core.api.Assertions;

public class MySqlDatabaseSchemaTest
extends BinlogDatabaseSchemaTest<MySqlConnectorConfig, MySqlDatabaseSchema, MySqlPartition, MySqlOffsetContext> {
    protected MySqlConnectorConfig getConnectorConfig(Configuration config) {
        config = ((Configuration.Builder)config.edit().with(AbstractSchemaHistory.INTERNAL_PREFER_DDL, true)).build();
        return new MySqlConnectorConfig(config);
    }

    protected MySqlDatabaseSchema getSchema(Configuration config) {
        this.connectorConfig = this.getConnectorConfig(config);
        return new MySqlDatabaseSchema((MySqlConnectorConfig)this.connectorConfig, (MySqlValueConverters)new MySqlValueConvertersFactory().create(RelationalDatabaseConnectorConfig.DecimalHandlingMode.parse((String)JdbcValueConverters.DecimalMode.PRECISE.name()), TemporalPrecisionMode.ADAPTIVE, BinlogConnectorConfig.BigIntUnsignedHandlingMode.parse((String)JdbcValueConverters.BigIntUnsignedMode.LONG.name()), CommonConnectorConfig.BinaryHandlingMode.BYTES, BinlogValueConverters::adjustTemporal, CommonConnectorConfig.EventConvertingFailureHandlingMode.WARN), (TopicNamingStrategy)DefaultTopicNamingStrategy.create((CommonConnectorConfig)this.connectorConfig), SchemaNameAdjuster.create(), false);
    }

    protected MySqlPartition initializePartition(MySqlConnectorConfig connectorConfig, Configuration taskConfig) {
        Set partitions = new MySqlPartition.Provider(connectorConfig, taskConfig).getPartitions();
        Assertions.assertThat((int)partitions.size()).isEqualTo(1);
        return (MySqlPartition)partitions.iterator().next();
    }

    protected MySqlOffsetContext initializeOffset(MySqlConnectorConfig connectorConfig) {
        return MySqlOffsetContext.initial((MySqlConnectorConfig)connectorConfig);
    }
}

