/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.mysql.cj.jdbc.exceptions.MySQLTimeoutException;
import io.debezium.connector.binlog.BinlogConnectionIT;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.connector.binlog.util.TestHelper;
import io.debezium.connector.binlog.util.UniqueDatabase;
import io.debezium.connector.mysql.MySqlCommon;
import io.debezium.connector.mysql.MySqlConnector;
import java.sql.SQLException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Test;

public class ConnectionIT
extends BinlogConnectionIT<MySqlConnector>
implements MySqlCommon {
    @Test
    public void whenQueryTakesMoreThenConfiguredQueryTimeoutAnExceptionMustBeThrown() throws SQLException {
        UniqueDatabase DATABASE = TestHelper.getUniqueDatabase((String)"readbinlog", (String)"readbinlog_test");
        DATABASE.createAndInitialize();
        try (BinlogTestConnection conn = this.getTestDatabaseConnection(DATABASE.getDatabaseName(), 1000);){
            conn.connect();
            ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> conn.execute(new String[]{"SELECT SLEEP(10)"})).isInstanceOf(MySQLTimeoutException.class)).hasMessage("Statement cancelled due to timeout or client request");
        }
    }
}

