/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.jdbc;

import com.mysql.cj.CharsetMapping;
import io.debezium.DebeziumException;
import io.debezium.connector.binlog.gtid.GtidSet;
import io.debezium.connector.binlog.jdbc.BinlogConnectorConnection;
import io.debezium.connector.binlog.jdbc.BinlogFieldReader;
import io.debezium.connector.binlog.jdbc.ConnectionConfiguration;
import io.debezium.connector.mysql.gtid.MySqlGtidSet;
import io.debezium.connector.mysql.jdbc.MySqlConnectionConfiguration;
import java.sql.SQLException;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlConnection
extends BinlogConnectorConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlConnection.class);

    public MySqlConnection(MySqlConnectionConfiguration connectionConfig, BinlogFieldReader fieldReader) {
        super((ConnectionConfiguration)connectionConfig, fieldReader);
    }

    public boolean isGtidModeEnabled() {
        try {
            return (Boolean)this.queryAndMap("SHOW GLOBAL VARIABLES LIKE 'GTID_MODE'", rs -> {
                if (rs.next()) {
                    return "ON".equalsIgnoreCase(rs.getString(2));
                }
                return false;
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while looking at GTID mode: ", (Throwable)e);
        }
    }

    public GtidSet knownGtidSet() {
        try {
            return (GtidSet)this.queryAndMap("SHOW MASTER STATUS", rs -> {
                if (rs.next() && rs.getMetaData().getColumnCount() > 4) {
                    return new MySqlGtidSet(rs.getString(5));
                }
                return new MySqlGtidSet("");
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while looking at GTID mode: ", (Throwable)e);
        }
    }

    public GtidSet subtractGtidSet(GtidSet set1, GtidSet set2) {
        try {
            return (GtidSet)this.prepareQueryAndMap("SELECT GTID_SUBTRACT(?, ?)", ps -> {
                ps.setString(1, set1.toString());
                ps.setString(2, set2.toString());
            }, rs -> {
                if (rs.next()) {
                    return new MySqlGtidSet(rs.getString(1));
                }
                return new MySqlGtidSet("");
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while executing GTID_SUBTRACT: ", (Throwable)e);
        }
    }

    public GtidSet purgedGtidSet() {
        try {
            return (GtidSet)this.queryAndMap("SELECT @@global.gtid_purged", rs -> {
                if (rs.next() && rs.getMetaData().getColumnCount() > 0) {
                    return new MySqlGtidSet(rs.getString(1));
                }
                return new MySqlGtidSet("");
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Unexpected error while looking at gtid_purged variable: ", (Throwable)e);
        }
    }

    public GtidSet filterGtidSet(Predicate<String> gtidSourceFilter, String offsetGtids, GtidSet availableServerGtidSet, GtidSet purgedServerGtidSet) {
        String gtidStr = offsetGtids;
        if (gtidStr == null) {
            return null;
        }
        LOGGER.info("Attempting to generate a filtered GTID set");
        LOGGER.info("GTID set from previous recorded offset: {}", (Object)gtidStr);
        MySqlGtidSet filteredGtidSet = new MySqlGtidSet(gtidStr);
        if (gtidSourceFilter != null) {
            filteredGtidSet = filteredGtidSet.retainAll(gtidSourceFilter);
            LOGGER.info("GTID set after applying GTID source includes/excludes to previous recorded offset: {}", (Object)filteredGtidSet);
        }
        LOGGER.info("GTID set available on server: {}", (Object)availableServerGtidSet);
        MySqlGtidSet knownGtidSet = filteredGtidSet;
        LOGGER.info("Using first available positions for new GTID channels");
        GtidSet relevantAvailableServerGtidSet = gtidSourceFilter != null ? availableServerGtidSet.retainAll(gtidSourceFilter) : availableServerGtidSet;
        LOGGER.info("Relevant GTID set available on server: {}", (Object)relevantAvailableServerGtidSet);
        GtidSet mergedGtidSet = relevantAvailableServerGtidSet.retainAll(uuid -> ((MySqlGtidSet)knownGtidSet).forServerWithId((String)uuid) != null).with(purgedServerGtidSet).with((GtidSet)filteredGtidSet);
        LOGGER.info("Final merged GTID set to use when connecting to MySQL: {}", (Object)mergedGtidSet);
        return mergedGtidSet;
    }

    public static String getJavaEncodingForCharSet(String charSetName) {
        return CharsetMappingWrapper.getJavaEncodingForMysqlCharSet(charSetName);
    }

    private static final class CharsetMappingWrapper
    extends CharsetMapping {
        private CharsetMappingWrapper() {
        }

        static String getJavaEncodingForMysqlCharSet(String charSetName) {
            return CharsetMapping.getStaticJavaEncodingForMysqlCharset((String)charSetName);
        }
    }
}

