/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr;

import com.mysql.cj.CharsetMapping;
import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.binlog.jdbc.BinlogSystemVariables;
import io.debezium.connector.mysql.antlr.listener.MySqlAntlrDdlParserListener;
import io.debezium.connector.mysql.jdbc.MySqlValueConverters;
import io.debezium.ddl.parser.mysql.generated.MySqlLexer;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.AbstractDdlParser;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySqlAntlrDdlParser
extends AntlrDdlParser<MySqlLexer, MySqlParser> {
    private final ConcurrentMap<String, String> charsetNameForDatabase = new ConcurrentHashMap<String, String>();
    private final MySqlValueConverters converters;
    private final Tables.TableFilter tableFilter;

    public MySqlAntlrDdlParser() {
        this(null, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters) {
        this(converters, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        this(true, false, false, converters, tableFilter);
    }

    public MySqlAntlrDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews, boolean includeComments, MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        super(throwErrorsFromTreeWalk, includeViews, includeComments);
        this.systemVariables = new BinlogSystemVariables();
        this.converters = converters;
        this.tableFilter = tableFilter;
    }

    protected ParseTree parseTree(MySqlParser parser) {
        return parser.root();
    }

    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new MySqlAntlrDdlParserListener(this);
    }

    protected MySqlLexer createNewLexerInstance(CharStream charStreams) {
        return new MySqlLexer(charStreams);
    }

    protected MySqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new MySqlParser((TokenStream)commonTokenStream);
    }

    protected SystemVariables createNewSystemVariablesInstance() {
        return new BinlogSystemVariables();
    }

    protected boolean isGrammarInUpperCase() {
        return true;
    }

    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.StringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, new Integer[]{225}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{225, 241}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{226}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{236}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{237}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{238}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{239}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{234}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{521}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{521, 241}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{227}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{225, 229}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{226, 229}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{236, 229}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{237, 229}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{238, 229}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{239, 229}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{521, 229}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{227, 229}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{26}), new DataTypeResolver.DataTypeEntry(12, new Integer[]{26, 241})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, new Integer[]{228, 226}).setSuffixTokens(new Integer[]{229}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{228, 26}).setSuffixTokens(new Integer[]{229}), new DataTypeResolver.DataTypeEntry(-15, new Integer[]{228, 225}).setSuffixTokens(new Integer[]{229}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{521, 226}).setSuffixTokens(new Integer[]{229})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalVaryingStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, new Integer[]{228, 225, 241}), new DataTypeResolver.DataTypeEntry(-9, new Integer[]{228, 26, 241})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.DimensionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(5, new Integer[]{199}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(5, new Integer[]{204}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(5, new Integer[]{200}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(5, new Integer[]{205}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{201}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{206}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{202}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{203}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{209}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{207}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(-5, new Integer[]{210}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(-5, new Integer[]{208}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(7, new Integer[]{211}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(8, new Integer[]{212}).setSuffixTokens(new Integer[]{213, 615, 186, 198}), new DataTypeResolver.DataTypeEntry(8, new Integer[]{216}).setSuffixTokens(new Integer[]{213, 615, 186, 198}), new DataTypeResolver.DataTypeEntry(6, new Integer[]{214}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(6, new Integer[]{215}).setSuffixTokens(new Integer[]{615, 186, 198}), new DataTypeResolver.DataTypeEntry(3, new Integer[]{217}).setSuffixTokens(new Integer[]{615, 186, 198}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, new Integer[]{218}).setSuffixTokens(new Integer[]{615, 186, 198}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, new Integer[]{434}).setSuffixTokens(new Integer[]{615, 186, 198}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(2, new Integer[]{219}).setSuffixTokens(new Integer[]{615, 186, 198}).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(-7, new Integer[]{349}).setDefaultLengthDimension(1), new DataTypeResolver.DataTypeEntry(92, new Integer[]{221}), new DataTypeResolver.DataTypeEntry(2014, new Integer[]{222}), new DataTypeResolver.DataTypeEntry(93, new Integer[]{223}), new DataTypeResolver.DataTypeEntry(-2, new Integer[]{229}), new DataTypeResolver.DataTypeEntry(-3, new Integer[]{230}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{232}), new DataTypeResolver.DataTypeEntry(4, new Integer[]{224})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SimpleDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(91, new Integer[]{220}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{231}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{233}), new DataTypeResolver.DataTypeEntry(2004, new Integer[]{235}), new DataTypeResolver.DataTypeEntry(16, new Integer[]{351}), new DataTypeResolver.DataTypeEntry(16, new Integer[]{352}), new DataTypeResolver.DataTypeEntry(-5, new Integer[]{242})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.CollectionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, new Integer[]{240}).setSuffixTokens(new Integer[]{229}), new DataTypeResolver.DataTypeEntry(1, new Integer[]{155}).setSuffixTokens(new Integer[]{229})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SpatialDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1111, new Integer[]{811}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{812}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{814}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{815}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{816}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{817}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{818}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{819}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{469}), new DataTypeResolver.DataTypeEntry(1111, new Integer[]{813})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarbinaryDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2004, new Integer[]{234}).setSuffixTokens(new Integer[]{230})));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarcharDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(12, new Integer[]{234}).setSuffixTokens(new Integer[]{226})));
        return dataTypeResolverBuilder.build();
    }

    public ConcurrentMap<String, String> charsetNameForDatabase() {
        return this.charsetNameForDatabase;
    }

    public String parseName(MySqlParser.UidContext uidContext) {
        return this.withoutQuotes((ParserRuleContext)uidContext);
    }

    public TableId parseQualifiedTableId(MySqlParser.FullIdContext fullIdContext) {
        char[] fullTableName = fullIdContext.getText().toCharArray();
        StringBuilder component = new StringBuilder();
        String dbName = null;
        String tableName = null;
        boolean EMPTY = false;
        char lastQuote = '\u0000';
        for (int i = 0; i < fullTableName.length; ++i) {
            char c = fullTableName[i];
            if (MySqlAntlrDdlParser.isQuote((char)c)) {
                if (lastQuote == '\u0000') {
                    lastQuote = c;
                    continue;
                }
                if (lastQuote == c) {
                    if (i < fullTableName.length - 1 && fullTableName[i + 1] == c) {
                        component.append(c);
                        ++i;
                        continue;
                    }
                    lastQuote = '\u0000';
                    continue;
                }
                component.append(c);
                continue;
            }
            if (c == '.' && lastQuote == '\u0000') {
                dbName = component.toString();
                component = new StringBuilder();
                continue;
            }
            component.append(c);
        }
        tableName = component.toString();
        return this.resolveTableId(dbName != null ? dbName : this.currentSchema(), tableName);
    }

    public void parsePrimaryIndexColumnNames(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List pkColumnNames = indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : (indexColumnNameContext.STRING_LITERAL() != null ? MySqlAntlrDdlParser.withoutQuotes((String)indexColumnNameContext.STRING_LITERAL().getText()) : indexColumnNameContext.expression().getText());
            Column column = tableEditor.columnWithName(columnName);
            if (column != null && column.isOptional()) {
                ColumnEditor ce = column.edit().optional(false);
                if (ce.hasDefaultValue() && !ce.defaultValueExpression().isPresent()) {
                    ce.unsetDefaultValueExpression();
                }
                tableEditor.addColumn(ce.create());
            }
            return column != null ? column.name() : columnName;
        }).collect(Collectors.toList());
        tableEditor.setPrimaryKeyNames(pkColumnNames);
    }

    public void parseUniqueIndexColumnNames(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List<Column> indexColumns = this.getIndexColumns(indexColumnNamesContext, tableEditor);
        if (indexColumns.stream().filter(col -> Objects.isNull(col) || col.isOptional()).count() > 0L) {
            this.logger.warn("Skip to set unique index columns {} to primary key which including optional columns", indexColumns);
        } else {
            tableEditor.setPrimaryKeyNames(indexColumns.stream().map(Column::name).collect(Collectors.toList()));
        }
    }

    public boolean isTableUniqueIndexIncluded(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        return this.getIndexColumns(indexColumnNamesContext, tableEditor).stream().filter(Objects::isNull).count() == 0L;
    }

    private List<Column> getIndexColumns(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        return indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : (indexColumnNameContext.STRING_LITERAL() != null ? MySqlAntlrDdlParser.withoutQuotes((String)indexColumnNameContext.STRING_LITERAL().getText()) : indexColumnNameContext.expression().getText());
            return tableEditor.columnWithName(columnName);
        }).collect(Collectors.toList());
    }

    public String currentDatabaseCharset() {
        String charsetName = this.systemVariables.getVariable("character_set_database");
        if (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName)) {
            charsetName = this.systemVariables.getVariable("character_set_server");
        }
        return charsetName;
    }

    public String charsetForTable(TableId tableId) {
        String defaultDatabaseCharset = tableId.catalog() != null ? (String)this.charsetNameForDatabase().get(tableId.catalog()) : null;
        return defaultDatabaseCharset != null ? defaultDatabaseCharset : this.currentDatabaseCharset();
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public static List<String> extractEnumAndSetOptions(List<String> enumValues) {
        return enumValues.stream().map(AbstractDdlParser::withoutQuotes).map(MySqlAntlrDdlParser::escapeOption).collect(Collectors.toList());
    }

    public static String escapeOption(String option) {
        return option.replaceAll(",", "\\\\,").replaceAll("\\\\'", "'").replace("''", "'");
    }

    public MySqlValueConverters getConverters() {
        return this.converters;
    }

    public Tables.TableFilter getTableFilter() {
        return this.tableFilter;
    }

    public String extractCharset(MySqlParser.CharsetNameContext charsetNode, MySqlParser.CollationNameContext collationNode) {
        String charsetName = null;
        if (charsetNode != null && charsetNode.getText() != null) {
            charsetName = MySqlAntlrDdlParser.withoutQuotes((String)charsetNode.getText());
        } else if (collationNode != null && collationNode.getText() != null) {
            String collationName = MySqlAntlrDdlParser.withoutQuotes((String)collationNode.getText()).toLowerCase();
            for (int index = 0; index < 1024; ++index) {
                if (!collationName.equals(CharsetMapping.getStaticCollationNameForCollationIndex((Integer)index))) continue;
                charsetName = CharsetMapping.getStaticMysqlCharsetNameForCollationIndex((Integer)index);
                break;
            }
        }
        return charsetName;
    }

    public void signalAlterTable(TableId id, TableId previousId, MySqlParser.RenameTableClauseContext ctx) {
        MySqlParser.RenameTableContext parent = (MySqlParser.RenameTableContext)ctx.getParent();
        Interval interval = new Interval(ctx.getParent().start.getStartIndex(), ((MySqlParser.RenameTableClauseContext)parent.renameTableClause().get((int)0)).start.getStartIndex() - 1);
        String prefix = ctx.getParent().start.getInputStream().getText(interval);
        this.signalAlterTable(id, previousId, prefix + MySqlAntlrDdlParser.getText((ParserRuleContext)ctx));
    }
}

