/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.mysql.cj.jdbc.Driver;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.gtid.GtidSetFactory;
import io.debezium.connector.mysql.Module;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlSourceInfoStructMaker;
import io.debezium.connector.mysql.gtid.MySqlGtidSetFactory;
import io.debezium.connector.mysql.history.MySqlHistoryRecordComparator;
import io.debezium.function.Predicates;
import io.debezium.relational.history.HistoryRecordComparator;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlConnectorConfig
extends BinlogConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlConnectorConfig.class);
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = Integer.MIN_VALUE;
    public static final Field JDBC_DRIVER = Field.create((String)"database.jdbc.driver").withDisplayName("JDBC Driver Class Name").withType(ConfigDef.Type.CLASS).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)41)).withWidth(ConfigDef.Width.MEDIUM).withDefault(Driver.class.getName()).withImportance(ConfigDef.Importance.LOW).withValidation(new Field.Validator[]{Field::isClassName}).withDescription("JDBC Driver class name used to connect to the MySQL database server.");
    public static final Field JDBC_PROTOCOL = Field.create((String)"database.protocol").withDisplayName("JDBC Protocol").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)42)).withWidth(ConfigDef.Width.MEDIUM).withDefault("jdbc:mysql").withImportance(ConfigDef.Importance.LOW).withDescription("JDBC protocol to use with the driver.");
    public static final Field GTID_SOURCE_INCLUDES = BinlogConnectorConfig.GTID_SOURCE_INCLUDES.withDescription("The source UUIDs used to include GTID ranges when determine the starting position in the MySQL server's binlog.");
    public static final Field GTID_SOURCE_EXCLUDES = BinlogConnectorConfig.GTID_SOURCE_EXCLUDES.withDescription("The source UUIDs used to exclude GTID ranges when determine the starting position in the MySQL server's binlog.");
    public static final Field SNAPSHOT_LOCKING_MODE = Field.create((String)"snapshot.locking.mode").withDisplayName("Snapshot locking mode").withEnum(SnapshotLockingMode.class, (Enum)SnapshotLockingMode.MINIMAL).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Controls how long the connector holds onto the global read lock while it is performing a snapshot. The default is 'minimal', which means the connector holds the global read lock (and thus prevents any updates) for just the initial portion of the snapshot while the database schemas and other metadata are being read. The remaining work in a snapshot involves selecting all rows from each table, and this can be done using the snapshot process' REPEATABLE READ transaction even when the lock is no longer held and other operations are updating the database. However, in some cases it may be desirable to block all writes for the entire duration of the snapshot; in such cases set this property to 'extended'. Using a value of 'none' will prevent the connector from acquiring any table locks during the snapshot process. This mode can only be used in combination with snapshot.mode values of 'schema_only' or 'schema_only_recovery' and is only safe to use if no schema changes are happening while the snapshot is taken.").withValidation(new Field.Validator[]{MySqlConnectorConfig::validateSnapshotLockingMode});
    public static final Field SOURCE_INFO_STRUCT_MAKER = CommonConnectorConfig.SOURCE_INFO_STRUCT_MAKER.withDefault(MySqlSourceInfoStructMaker.class.getName());
    private static final ConfigDefinition CONFIG_DEFINITION = BinlogConnectorConfig.CONFIG_DEFINITION.edit().name("MySQL").excluding(new Field[]{BinlogConnectorConfig.GTID_SOURCE_INCLUDES, BinlogConnectorConfig.GTID_SOURCE_EXCLUDES}).type(new Field[]{JDBC_DRIVER, JDBC_PROTOCOL}).connector(new Field[]{SNAPSHOT_LOCKING_MODE}).events(new Field[]{GTID_SOURCE_INCLUDES, GTID_SOURCE_EXCLUDES, SOURCE_INFO_STRUCT_MAKER}).create();
    public static Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    private final GtidSetFactory gtidSetFactory = new MySqlGtidSetFactory();
    private final Predicate<String> gtidSourceFilter;
    private final SnapshotLockingMode snapshotLockingMode;
    private final BinlogConnectorConfig.SnapshotLockingStrategy snapshotLockingStrategy;

    protected static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public MySqlConnectorConfig(Configuration config) {
        super(MySqlConnector.class, config, Integer.MIN_VALUE);
        this.snapshotLockingMode = SnapshotLockingMode.parse(config.getString(SNAPSHOT_LOCKING_MODE), SNAPSHOT_LOCKING_MODE.defaultValueAsString());
        this.snapshotLockingStrategy = new MySqlSnapshotLockingStrategy(this.snapshotLockingMode);
        String gtidSetIncludes = config.getString(GTID_SOURCE_INCLUDES);
        String gtidSetExcludes = config.getString(GTID_SOURCE_EXCLUDES);
        this.gtidSourceFilter = gtidSetIncludes != null ? Predicates.includesUuids((String)gtidSetIncludes) : (gtidSetExcludes != null ? Predicates.excludesUuids((String)gtidSetExcludes) : null);
    }

    public Optional<SnapshotLockingMode> getSnapshotLockingMode() {
        return Optional.of(this.snapshotLockingMode);
    }

    protected BinlogConnectorConfig.SnapshotLockingStrategy getSnapshotLockingStrategy() {
        return this.snapshotLockingStrategy;
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return this.getSourceInfoStructMaker(SOURCE_INFO_STRUCT_MAKER, Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    public String getContextName() {
        return Module.contextName();
    }

    public String getConnectorName() {
        return Module.name();
    }

    public Predicate<String> getGtidSourceFilter() {
        return this.gtidSourceFilter;
    }

    public GtidSetFactory getGtidSetFactory() {
        return this.gtidSetFactory;
    }

    protected HistoryRecordComparator getHistoryRecordComparator() {
        return new MySqlHistoryRecordComparator(this.gtidSourceFilter, this.getGtidSetFactory());
    }

    private static int validateSnapshotLockingMode(Configuration config, Field field, Field.ValidationOutput problems) {
        SnapshotLockingMode lockingModeValue;
        if (config.hasKey(SNAPSHOT_LOCKING_MODE.name()) && (lockingModeValue = SnapshotLockingMode.parse(config.getString(SNAPSHOT_LOCKING_MODE))) == null) {
            problems.accept(SNAPSHOT_LOCKING_MODE, (Object)lockingModeValue, "Must be a valid snapshot.locking.mode value");
            return 1;
        }
        return 0;
    }

    public static enum SnapshotLockingMode implements EnumeratedValue
    {
        EXTENDED("extended"),
        MINIMAL("minimal"),
        MINIMAL_PERCONA("minimal_percona"),
        NONE("none"),
        CUSTOM("custom");

        private final String value;

        private SnapshotLockingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean usesMinimalLocking() {
            return this.value.equals(SnapshotLockingMode.MINIMAL.value) || this.value.equals(SnapshotLockingMode.MINIMAL_PERCONA.value);
        }

        public boolean usesLocking() {
            return !this.value.equals(SnapshotLockingMode.NONE.value);
        }

        public boolean flushResetsIsolationLevel() {
            return !this.value.equals(SnapshotLockingMode.MINIMAL_PERCONA.value);
        }

        public static SnapshotLockingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotLockingMode option : SnapshotLockingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotLockingMode parse(String value, String defaultValue) {
            SnapshotLockingMode mode = SnapshotLockingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotLockingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static class MySqlSnapshotLockingStrategy
    implements BinlogConnectorConfig.SnapshotLockingStrategy {
        private final SnapshotLockingMode snapshotLockingMode;

        public MySqlSnapshotLockingStrategy(SnapshotLockingMode snapshotLockingMode) {
            this.snapshotLockingMode = snapshotLockingMode;
        }

        public boolean isLockingEnabled() {
            return this.snapshotLockingMode.usesLocking();
        }

        public boolean isMinimalLockingEnabled() {
            return this.snapshotLockingMode.usesMinimalLocking();
        }

        public boolean isIsolationLevelResetOnFlush() {
            return this.snapshotLockingMode.flushResetsIsolationLevel();
        }
    }
}

