/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.rest;

import io.debezium.connector.mysql.Module;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.rest.DebeziumMySqlConnectRestExtension;
import io.debezium.storage.kafka.history.KafkaSchemaHistory;
import io.debezium.testing.testcontainers.Connector;
import io.debezium.testing.testcontainers.ConnectorConfiguration;
import io.debezium.testing.testcontainers.testhelper.RestExtensionTestInfrastructure;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Locale;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class DebeziumMySqlConnectorResourceIT {
    @BeforeClass
    public static void checkCondition() {
        Assume.assumeThat((String)"Skipping DebeziumMySqlConnectorResourceIT tests when assembly profile is not active!", (Object)System.getProperty("isAssemblyProfileActive", "false"), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Before
    public void start() {
        RestExtensionTestInfrastructure.setupDebeziumContainer((String)Module.version(), (String)DebeziumMySqlConnectRestExtension.class.getName());
        RestExtensionTestInfrastructure.startContainers((RestExtensionTestInfrastructure.DATABASE)RestExtensionTestInfrastructure.DATABASE.MYSQL);
    }

    @After
    public void stop() {
        RestExtensionTestInfrastructure.stopContainers();
    }

    @Test
    public void testValidConnection() {
        ConnectorConfiguration config = DebeziumMySqlConnectorResourceIT.getMySqlConnectorConfiguration(1, new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mysql/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testInvalidHostnameConnection() {
        ConnectorConfiguration config = DebeziumMySqlConnectorResourceIT.getMySqlConnectorConfiguration(1, new String[0]).with(MySqlConnectorConfig.HOSTNAME.name(), "zzzzzzzzzz");
        Locale.setDefault(new Locale("en", "US"));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mysql/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.equalTo((Object)MySqlConnectorConfig.HOSTNAME.name()), new Object[0])).body("message", CoreMatchers.startsWith((String)"Unable to connect: Communications link failure"), new Object[0]);
    }

    @Test
    public void testInvalidConnection() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body("{\"connector.class\": \"" + MySqlConnector.class.getName() + "\"}").put("/debezium/mysql/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)4), new Object[0])).body("validationResults", CoreMatchers.hasItems((Object[])new Map[]{Map.of("property", MySqlConnectorConfig.USER.name(), "message", "The 'database.user' value is invalid: A value is required"), Map.of("property", MySqlConnectorConfig.TOPIC_PREFIX.name(), "message", "The 'topic.prefix' value is invalid: A value is required"), Map.of("property", MySqlConnectorConfig.SERVER_ID.name(), "message", "The 'database.server.id' value is invalid: A value is required"), Map.of("property", MySqlConnectorConfig.HOSTNAME.name(), "message", "The 'database.hostname' value is invalid: A value is required")}), new Object[0]);
    }

    @Test
    public void testFiltersWithEmptyFilters() {
        ConnectorConfiguration config = DebeziumMySqlConnectorResourceIT.getMySqlConnectorConfiguration(1, new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mysql/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)6), new Object[0])).body("matchingCollections", CoreMatchers.hasItems((Object[])new Map[]{Map.of("namespace", "inventory", "name", "geom", "identifier", "inventory.geom"), Map.of("namespace", "inventory", "name", "products_on_hand", "identifier", "inventory.products_on_hand"), Map.of("namespace", "inventory", "name", "customers", "identifier", "inventory.customers"), Map.of("namespace", "inventory", "name", "addresses", "identifier", "inventory.addresses"), Map.of("namespace", "inventory", "name", "orders", "identifier", "inventory.orders"), Map.of("namespace", "inventory", "name", "products", "identifier", "inventory.products")}), new Object[0]);
    }

    @Test
    public void testFiltersWithValidTableIncludeList() {
        ConnectorConfiguration config = DebeziumMySqlConnectorResourceIT.getMySqlConnectorConfiguration(1, new String[0]).with("table.include.list", "inventory\\.product.*");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mysql/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)2), new Object[0])).body("matchingCollections", CoreMatchers.hasItems((Object[])new Map[]{Map.of("namespace", "inventory", "name", "products_on_hand", "identifier", "inventory.products_on_hand"), Map.of("namespace", "inventory", "name", "products", "identifier", "inventory.products")}), new Object[0]);
    }

    @Test
    public void testFiltersWithValidDatabaseIncludeList() {
        ConnectorConfiguration config = DebeziumMySqlConnectorResourceIT.getMySqlConnectorConfiguration(1, new String[0]).with("database.include.list", "inventory");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mysql/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)6), new Object[0])).body("matchingCollections", CoreMatchers.hasItems((Object[])new Map[]{Map.of("namespace", "inventory", "name", "geom", "identifier", "inventory.geom"), Map.of("namespace", "inventory", "name", "products_on_hand", "identifier", "inventory.products_on_hand"), Map.of("namespace", "inventory", "name", "customers", "identifier", "inventory.customers"), Map.of("namespace", "inventory", "name", "addresses", "identifier", "inventory.addresses"), Map.of("namespace", "inventory", "name", "orders", "identifier", "inventory.orders"), Map.of("namespace", "inventory", "name", "products", "identifier", "inventory.products")}), new Object[0]);
    }

    @Test
    public void testFiltersWithInvalidDatabaseIncludeListPattern() {
        ConnectorConfiguration config = DebeziumMySqlConnectorResourceIT.getMySqlConnectorConfiguration(1, new String[0]).with("database.include.list", "+");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mysql/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)0), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.equalTo((Object)"database.include.list"), new Object[0])).body("message", CoreMatchers.equalTo((Object)"The 'database.include.list' value is invalid: A comma-separated list of valid regular expressions is expected, but Dangling meta character '+' near index 0\n+\n^"), new Object[0]);
    }

    @Test
    public void testFiltersWithInvalidDatabaseExcludeListPattern() {
        ConnectorConfiguration config = DebeziumMySqlConnectorResourceIT.getMySqlConnectorConfiguration(1, new String[0]).with("database.exclude.list", "+");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/mysql/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)0), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.equalTo((Object)"database.exclude.list"), new Object[0])).body("message", CoreMatchers.equalTo((Object)"The 'database.exclude.list' value is invalid: A comma-separated list of valid regular expressions is expected, but Dangling meta character '+' near index 0\n+\n^"), new Object[0]);
    }

    @Test
    public void testMetricsEndpoint() throws InterruptedException {
        ConnectorConfiguration config = DebeziumMySqlConnectorResourceIT.getMySqlConnectorConfiguration(1, new String[0]);
        String connectorName = "my-mysql-connector";
        RestExtensionTestInfrastructure.getDebeziumContainer().registerConnector(connectorName, config);
        RestExtensionTestInfrastructure.getDebeziumContainer().ensureConnectorState(connectorName, Connector.State.RUNNING);
        RestExtensionTestInfrastructure.waitForConnectorTaskStatus((String)connectorName, (int)0, (Connector.State)Connector.State.RUNNING);
        RestExtensionTestInfrastructure.getDebeziumContainer().waitForStreamingRunning("mysql", config.asProperties().getProperty("topic.prefix"));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).get("/debezium/mysql/connectors/{connector-name}/metrics", new Object[]{connectorName})).then()).log().all()).statusCode(200)).body("name", CoreMatchers.equalTo((Object)connectorName), new Object[0])).body("connector.metrics.Connected", CoreMatchers.equalTo((Object)"true"), new Object[0])).body("tasks[0].id", CoreMatchers.equalTo((Object)0), new Object[0])).body("tasks[0].namespaces[0].metrics.MilliSecondsSinceLastEvent", CoreMatchers.equalTo((Object)"0"), new Object[0])).body("tasks[0].namespaces[0].metrics.TotalNumberOfEventsSeen", CoreMatchers.is((Matcher)Matchers.notNullValue()), new Object[0]);
    }

    public static ConnectorConfiguration getMySqlConnectorConfiguration(int id, String ... options) {
        ConnectorConfiguration config = ConnectorConfiguration.forJdbcContainer((JdbcDatabaseContainer)RestExtensionTestInfrastructure.getMySqlContainer()).with(MySqlConnectorConfig.USER.name(), "debezium").with(MySqlConnectorConfig.PASSWORD.name(), "dbz").with(MySqlConnectorConfig.SNAPSHOT_MODE.name(), "never").with(MySqlConnectorConfig.TOPIC_PREFIX.name(), "dbserver" + id).with(KafkaSchemaHistory.BOOTSTRAP_SERVERS.name(), "kafka-dbz-ui:9092").with(KafkaSchemaHistory.TOPIC.name(), "dbhistory.inventory").with(MySqlConnectorConfig.SERVER_ID.name(), Long.valueOf(5555 + id - 1));
        if (options != null && options.length > 0) {
            for (int i = 0; i < options.length; i += 2) {
                config.with(options[i], options[i + 1]);
            }
        }
        return config;
    }
}

