/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Field;
import io.debezium.connector.binlog.util.BinlogTestConnection;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import java.sql.SQLException;
import java.util.Map;

public class MySqlTestConnection
extends BinlogTestConnection {
    MySqlVersion mySqlVersion;
    protected static JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)"${protocol}://${hostname}:${port}/${dbname}", (Field[])new Field[0]);

    public static MySqlTestConnection forTestDatabase(String databaseName) {
        return new MySqlTestConnection((JdbcConfiguration)MySqlTestConnection.getDefaultJdbcConfig((String)databaseName).build());
    }

    public static MySqlTestConnection forTestReplicaDatabase(String databaseName) {
        return new MySqlTestConnection((JdbcConfiguration)MySqlTestConnection.getReplicaJdbcConfig((String)databaseName).build());
    }

    public static MySqlTestConnection forTestDatabase(String databaseName, int queryTimeout) {
        return new MySqlTestConnection((JdbcConfiguration)MySqlTestConnection.getDefaultJdbcConfig((String)databaseName).withQueryTimeoutMs(queryTimeout).build());
    }

    public static MySqlTestConnection forTestDatabase(String databaseName, Map<String, Object> urlProperties) {
        JdbcConfiguration.Builder builder = MySqlTestConnection.getDefaultJdbcConfig((String)databaseName);
        urlProperties.forEach((arg_0, arg_1) -> ((JdbcConfiguration.Builder)builder).with(arg_0, arg_1));
        return new MySqlTestConnection((JdbcConfiguration)builder.build());
    }

    public MySqlTestConnection(JdbcConfiguration config) {
        super(MySqlTestConnection.addDefaultSettings((JdbcConfiguration)config), FACTORY);
    }

    public boolean isGtidEnabled() {
        return false;
    }

    public boolean isMariaDb() {
        return false;
    }

    public boolean isMySQL5() {
        switch (this.getMySqlVersion()) {
            case MYSQL_5_5: 
            case MYSQL_5_6: 
            case MYSQL_5_7: {
                return true;
            }
        }
        return false;
    }

    public boolean isPercona() {
        return this.getMySqlVersionString().startsWith("Percona");
    }

    public String currentDateTimeDefaultOptional(String isoString) {
        return !MySqlVersion.MYSQL_8.equals((Object)this.getMySqlVersion()) ? isoString : null;
    }

    public void setBinlogCompressionOff() throws SQLException {
        this.execute(new String[]{"set binlog_transaction_compression=OFF;"});
    }

    public void setBinlogCompressionOn() throws SQLException {
        this.execute(new String[]{"set binlog_transaction_compression=ON;"});
    }

    public void setBinlogRowQueryEventsOff() throws SQLException {
        this.execute(new String[]{"SET binlog_rows_query_log_events=OFF"});
    }

    public void setBinlogRowQueryEventsOn() throws SQLException {
        this.execute(new String[]{"SET binlog_rows_query_log_events=ON"});
    }

    public boolean isCurrentDateTimeDefaultGenerated() {
        return MySqlVersion.MYSQL_8.equals((Object)this.getMySqlVersion());
    }

    public MySqlVersion getMySqlVersion() {
        if (this.mySqlVersion == null) {
            String versionString = this.getMySqlVersionString();
            if (versionString.startsWith("8.")) {
                this.mySqlVersion = MySqlVersion.MYSQL_8;
            } else if (versionString.startsWith("5.5")) {
                this.mySqlVersion = MySqlVersion.MYSQL_5_5;
            } else if (versionString.startsWith("5.6")) {
                this.mySqlVersion = MySqlVersion.MYSQL_5_6;
            } else if (versionString.startsWith("5.7")) {
                this.mySqlVersion = MySqlVersion.MYSQL_5_7;
            } else {
                throw new IllegalStateException("Couldn't resolve MySQL Server version");
            }
        }
        return this.mySqlVersion;
    }

    public static enum MySqlVersion {
        MYSQL_5_5,
        MYSQL_5_6,
        MYSQL_5_7,
        MYSQL_8;

    }
}

