/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog.converters;

import io.debezium.function.Predicates;
import io.debezium.spi.converter.CustomConverter;
import io.debezium.spi.converter.RelationalColumn;
import io.debezium.util.Strings;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSinkDataTypesConverter
implements CustomConverter<SchemaBuilder, RelationalColumn> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcSinkDataTypesConverter.class);
    private static final Short INT16_FALLBACK = 0;
    private static final Float FLOAT32_FALLBACK = Float.valueOf(0.0f);
    private static final Double FLOAT64_FALLBACK = 0.0;
    public static final String SELECTOR_BOOLEAN_PROPERTY = "selector.boolean";
    public static final String SELECTOR_REAL_PROPERTY = "selector.real";
    public static final String SELECTOR_STRING_PROPERTY = "selector.string";
    public static final String TREAT_REAL_AS_DOUBLE = "treat.real.as.double";
    private Predicate<RelationalColumn> selectorBoolean = x -> false;
    private Predicate<RelationalColumn> selectorReal = x -> false;
    private Predicate<RelationalColumn> selectorString = x -> false;
    private boolean treatRealAsDouble = true;

    public void configure(Properties props) {
        String realAsDouble;
        String stringSelectorConfig;
        String realSelectorConfig;
        String booleanSelectorConfig = props.getProperty(SELECTOR_BOOLEAN_PROPERTY);
        if (!Strings.isNullOrBlank((String)booleanSelectorConfig)) {
            this.selectorBoolean = Predicates.includes((String)booleanSelectorConfig.trim(), x -> x.dataCollection() + "." + x.name());
        }
        if (!Strings.isNullOrBlank((String)(realSelectorConfig = props.getProperty(SELECTOR_REAL_PROPERTY)))) {
            this.selectorReal = Predicates.includes((String)realSelectorConfig.trim(), x -> x.dataCollection() + "." + x.name());
        }
        if (!Strings.isNullOrBlank((String)(stringSelectorConfig = props.getProperty(SELECTOR_STRING_PROPERTY)))) {
            this.selectorString = Predicates.includes((String)stringSelectorConfig.trim(), x -> x.dataCollection() + "." + x.name());
        }
        if (!Strings.isNullOrEmpty((String)(realAsDouble = props.getProperty(TREAT_REAL_AS_DOUBLE)))) {
            this.treatRealAsDouble = Boolean.parseBoolean(realAsDouble);
        }
    }

    public void converterFor(RelationalColumn field, CustomConverter.ConverterRegistration<SchemaBuilder> registration) {
        if (this.selectorBoolean.test(field)) {
            registration.register((Object)SchemaBuilder.int16(), this.getBooleanConverter(field));
        } else if (this.selectorReal.test(field)) {
            if (this.treatRealAsDouble) {
                registration.register((Object)SchemaBuilder.float64(), this.getRealConverterDouble(field));
            } else {
                registration.register((Object)SchemaBuilder.float32(), this.getRealConverterFloat(field));
            }
        } else if (this.selectorString.test(field)) {
            SchemaBuilder schemaBuilder = SchemaBuilder.string();
            schemaBuilder.parameter("__debezium.source.column.character_set", field.charsetName());
            registration.register((Object)schemaBuilder, this.getStringConverter(field));
        }
    }

    private CustomConverter.Converter getBooleanConverter(RelationalColumn field) {
        return value -> {
            if (value == null) {
                if (field.isOptional()) {
                    return null;
                }
                if (field.hasDefaultValue()) {
                    return JdbcSinkDataTypesConverter.toTinyInt((Boolean)field.defaultValue());
                }
                return INT16_FALLBACK;
            }
            if (value instanceof Boolean) {
                return JdbcSinkDataTypesConverter.toTinyInt((Boolean)value);
            }
            if (value instanceof Number) {
                return JdbcSinkDataTypesConverter.toTinyInt(((Number)value).intValue() > 0);
            }
            if (value instanceof String) {
                try {
                    return JdbcSinkDataTypesConverter.toTinyInt(Integer.parseInt((String)value) > 0);
                }
                catch (NumberFormatException e) {
                    return JdbcSinkDataTypesConverter.toTinyInt(Boolean.parseBoolean((String)value));
                }
            }
            LOGGER.warn("Cannot convert '{}' to INT16", value.getClass());
            return INT16_FALLBACK;
        };
    }

    private CustomConverter.Converter getRealConverterDouble(RelationalColumn field) {
        return value -> {
            if (value == null) {
                if (field.isOptional()) {
                    return null;
                }
                if (field.hasDefaultValue()) {
                    return (double)((Double)field.defaultValue());
                }
                return FLOAT64_FALLBACK;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof String) {
                return Double.parseDouble((String)value);
            }
            LOGGER.warn("Cannot convert '{}' to FLOAT64.", value.getClass());
            return FLOAT64_FALLBACK;
        };
    }

    private CustomConverter.Converter getRealConverterFloat(RelationalColumn field) {
        return value -> {
            if (value == null) {
                if (field.isOptional()) {
                    return null;
                }
                if (field.hasDefaultValue()) {
                    return Float.valueOf(((Float)field.defaultValue()).floatValue());
                }
                return FLOAT32_FALLBACK;
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof String) {
                return Float.valueOf(Float.parseFloat((String)value));
            }
            LOGGER.warn("Cannot convert '{}' to FLOAT32.", value.getClass());
            return FLOAT32_FALLBACK;
        };
    }

    private CustomConverter.Converter getStringConverter(RelationalColumn field) {
        return value -> {
            if (value == null) {
                if (field.isOptional()) {
                    return null;
                }
                if (field.hasDefaultValue()) {
                    return (String)field.defaultValue();
                }
                return "";
            }
            if (value instanceof byte[]) {
                return new String((byte[])value, StandardCharsets.UTF_8);
            }
            if (value instanceof Number) {
                return ((Number)value).toString();
            }
            if (value instanceof String) {
                return (String)value;
            }
            LOGGER.warn("Cannot convert '{}' to STRING", value.getClass());
            return "";
        };
    }

    private static short toTinyInt(Boolean value) {
        return (short)(value != false ? 1 : 0);
    }
}

