/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.embedded.async.AbstractAsyncEngineConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.junit.SkipWhenKafkaVersion;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.time.MicroTimestamp;
import io.debezium.time.Time;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@SkipWhenDatabaseVersion(check=EqualityCheck.LESS_THAN, major=5, minor=6, reason="DDL uses fractional second data types, not supported until MySQL 5.6")
public class MysqlDefaultValueIT
extends AbstractAsyncEngineConnectorTest {
    private static final int EVENT_COUNT = 46;
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-connect.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("myServer1", "default_value").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        if (VerifyRecord.isApucurioAvailable()) {
            this.skipAvroValidation();
        }
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    protected void validate(SourceRecord record) {
        if (VerifyRecord.isApucurioAvailable()) {
            VerifyRecord.isValid((SourceRecord)record, (boolean)true);
        } else {
            super.validate(record);
        }
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void unsignedTinyIntTest() throws InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("UNSIGNED_TINYINT_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Assertions.assertThat((boolean)schemaA.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((boolean)schemaB.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)10);
        Assertions.assertThat((boolean)schemaC.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo(null);
        Assertions.assertThat((boolean)schemaD.isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)schemaE.isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((boolean)schemaF.isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo((Object)0);
        this.assertEmptyFieldValue(record, "G");
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void unsignedSmallIntTest() throws InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("UNSIGNED_SMALLINT_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Assertions.assertThat((boolean)schemaA.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((boolean)schemaB.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)10);
        Assertions.assertThat((boolean)schemaC.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo(null);
        Assertions.assertThat((boolean)schemaD.isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)schemaE.isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((boolean)schemaF.isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo((Object)0);
        this.assertEmptyFieldValue(record, "G");
    }

    private void assertEmptyFieldValue(SourceRecord record, String fieldName) {
        Struct envelope = (Struct)record.value();
        Struct after = (Struct)envelope.get("after");
        Assertions.assertThat((Object)after.getWithoutDefault(fieldName)).isNull();
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void unsignedMediumIntTest() throws InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("UNSIGNED_MEDIUMINT_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Assertions.assertThat((boolean)schemaA.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((boolean)schemaB.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)10);
        Assertions.assertThat((boolean)schemaC.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo(null);
        Assertions.assertThat((boolean)schemaD.isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)schemaE.isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((boolean)schemaF.isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo((Object)0);
        this.assertEmptyFieldValue(record, "G");
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void unsignedIntTest() throws InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("UNSIGNED_INT_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Assertions.assertThat((boolean)schemaA.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((boolean)schemaB.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)10L);
        Assertions.assertThat((boolean)schemaC.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo(null);
        Assertions.assertThat((boolean)schemaD.isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)schemaE.isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((boolean)schemaF.isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo((Object)0L);
        this.assertEmptyFieldValue(record, "G");
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void unsignedBigIntToLongTest() throws InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("UNSIGNED_BIGINT_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Assertions.assertThat((boolean)schemaA.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((boolean)schemaB.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)10L);
        Assertions.assertThat((boolean)schemaC.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo(null);
        Assertions.assertThat((boolean)schemaD.isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)schemaE.isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((boolean)schemaF.isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo((Object)0L);
        this.assertEmptyFieldValue(record, "G");
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void unsignedBigIntToBigDecimalTest() throws InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.BIGINT_UNSIGNED_HANDLING_MODE, (Object)JdbcValueConverters.BigIntUnsignedMode.PRECISE)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("UNSIGNED_BIGINT_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Assertions.assertThat((boolean)schemaA.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)BigDecimal.ZERO);
        Assertions.assertThat((boolean)schemaB.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)new BigDecimal(10));
        Assertions.assertThat((boolean)schemaC.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo(null);
        Assertions.assertThat((boolean)schemaD.isOptional()).isEqualTo(false);
        Assertions.assertThat((boolean)schemaE.isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)BigDecimal.ZERO);
        Assertions.assertThat((boolean)schemaF.isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo((Object)BigDecimal.ZERO);
        this.assertEmptyFieldValue(record, "G");
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void stringTest() throws InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("STRING_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Schema schemaG = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(6)).schema();
        Schema schemaH = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(7)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)"A");
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)"b");
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo((Object)"CC");
        Assertions.assertThat((Object)schemaD.defaultValue()).isEqualTo((Object)"10");
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)"0");
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaG.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaH.defaultValue()).isEqualTo(null);
        this.assertEmptyFieldValue(record, "I");
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void schemaHistorySaveDefaultValuesTest() throws InterruptedException, SQLException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("STRING_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Schema schemaG = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(6)).schema();
        Schema schemaH = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(7)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)"A");
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)"b");
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo((Object)"CC");
        Assertions.assertThat((Object)schemaD.defaultValue()).isEqualTo((Object)"10");
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)"0");
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaG.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaH.defaultValue()).isEqualTo(null);
        this.assertEmptyFieldValue(record, "I");
        this.stopConnector();
        String insert = "INSERT INTO STRING_TABLE\nVALUES (DEFAULT ,DEFAULT ,DEFAULT ,DEFAULT ,DEFAULT ,DEFAULT ,DEFAULT ,DEFAULT, NULL)";
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            Connection jdbc = connection.connection();
            Statement statement = jdbc.createStatement();
            statement.executeUpdate("INSERT INTO STRING_TABLE\nVALUES (DEFAULT ,DEFAULT ,DEFAULT ,DEFAULT ,DEFAULT ,DEFAULT ,DEFAULT ,DEFAULT, NULL)");
        }
        this.start(MySqlConnector.class, this.config);
        Testing.Print.enable();
        records = this.consumeRecordsByTopic(1);
        record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("STRING_TABLE")).get(0);
        this.validate(record);
        schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        schemaG = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(6)).schema();
        schemaH = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(7)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)"A");
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)"b");
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo((Object)"CC");
        Assertions.assertThat((Object)schemaD.defaultValue()).isEqualTo((Object)"10");
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)"0");
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaG.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaH.defaultValue()).isEqualTo(null);
        this.assertEmptyFieldValue(record, "I");
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void unsignedBitTest() throws InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("BIT_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Schema schemaG = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(6)).schema();
        Schema schemaH = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(7)).schema();
        Schema schemaI = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(8)).schema();
        Schema schemaJ = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(9)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)false);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)schemaD.defaultValue()).isEqualTo((Object)false);
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo((Object)true);
        Assertions.assertThat((Object)schemaG.defaultValue()).isEqualTo((Object)false);
        Assertions.assertThat((Object)schemaH.defaultValue()).isEqualTo((Object)new byte[]{66, 1});
        Assertions.assertThat((Object)schemaI.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaJ.defaultValue()).isEqualTo((Object)new byte[]{15, 97, 1, 0});
        this.assertEmptyFieldValue(record, "K");
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void booleanTest() throws InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("BOOLEAN_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)1);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo((Object)1);
        Assertions.assertThat((Object)schemaD.defaultValue()).isEqualTo((Object)1);
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo(null);
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void numberTest() throws InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("NUMBER_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaG = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(6)).schema();
        Schema schemaH = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(7)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)10);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)5);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((Object)schemaD.defaultValue()).isEqualTo((Object)20L);
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo(null);
        this.assertEmptyFieldValue(record, "F");
        Assertions.assertThat((Object)schemaG.defaultValue()).isEqualTo((Object)1);
        Assertions.assertThat((Object)schemaH.defaultValue()).isEqualTo((Object)1);
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void tinyIntBooleanTest() throws Exception {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        this.consumeRecordsByTopic(46);
        try (Connection conn = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            conn.createStatement().execute("CREATE TABLE ti_boolean_table (  A TINYINT(1) NOT NULL DEFAULT TRUE,  B TINYINT(2) NOT NULL DEFAULT FALSE)");
            conn.createStatement().execute("INSERT INTO ti_boolean_table VALUES (default, default)");
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("ti_boolean_table")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)1);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)0);
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    @FixFor(value={"DBZ-1689"})
    public void intBooleanTest() throws Exception {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        Testing.Print.enable();
        MysqlDefaultValueIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        this.consumeRecordsByTopic(46);
        try (Connection conn = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            conn.createStatement().execute("CREATE TABLE int_boolean_table (  A INT(1) NOT NULL DEFAULT TRUE,  B INT(2) NOT NULL DEFAULT FALSE)");
            conn.createStatement().execute("INSERT INTO int_boolean_table VALUES (default, default)");
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("int_boolean_table")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)1);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)0);
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void floatAndDoubleTest() throws InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("FlOAT_DOUBLE_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)Float.valueOf(0.0f));
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)1.0);
        this.assertEmptyFieldValue(record, "H");
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void realTest() throws InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("REAL_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo(null);
        this.assertEmptyFieldValue(record, "C");
    }

    @Test
    public void numericAndDecimalToDoubleTest() throws InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.DOUBLE)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("NUMERIC_DECIMAL_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)1.23);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)2.321);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo((Object)12.678);
        this.assertEmptyFieldValue(record, "D");
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void numericAndDecimalToDecimalTest() throws InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.PRECISE)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("NUMERIC_DECIMAL_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)BigDecimal.valueOf(1.23));
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)BigDecimal.valueOf(2.321));
        this.assertEmptyFieldValue(record, "D");
    }

    @Test
    public void dateAndTimeTest() throws InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("DATE_TIME_TABLE"))).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("DATE_TIME_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Schema schemaG = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(6)).schema();
        Schema schemaH = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(7)).schema();
        Schema schemaI = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(8)).schema();
        Schema schemaJ = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(9)).schema();
        Schema schemaL = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(11)).schema();
        Schema schemaM = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(12)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)2426);
        String value1 = "1970-01-01 00:00:01";
        ZonedDateTime t = Timestamp.valueOf(value1).toInstant().atZone(ZoneId.systemDefault());
        String isoString = MysqlDefaultValueIT.getZonedDateTimeIsoString(t);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)isoString);
        String value2 = "2018-01-03 00:00:10";
        long toEpochMillis1 = io.debezium.time.Timestamp.toEpochMillis((Object)LocalDateTime.from(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").parse(value2)), MySqlValueConverters::adjustTemporal);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo((Object)toEpochMillis1);
        String value3 = "2018-01-03 00:00:10.7";
        long toEpochMillis2 = io.debezium.time.Timestamp.toEpochMillis((Object)LocalDateTime.from(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S").parse(value3)), MySqlValueConverters::adjustTemporal);
        Assertions.assertThat((Object)schemaD.defaultValue()).isEqualTo((Object)toEpochMillis2);
        String value4 = "2018-01-03 00:00:10.123456";
        long toEpochMicro = MicroTimestamp.toEpochMicros((Object)LocalDateTime.from(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS").parse(value4)), MySqlValueConverters::adjustTemporal);
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)toEpochMicro);
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo((Object)2001);
        Assertions.assertThat((Object)schemaG.defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((Object)schemaH.defaultValue()).isEqualTo((Object)82800700000L);
        Assertions.assertThat((Object)schemaI.defaultValue()).isEqualTo((Object)82800123456L);
        Assertions.assertThat((Object)schemaL.defaultValue()).isEqualTo((Object)(Duration.ofHours(-23L).minusMinutes(45L).minusSeconds(56L).minusMillis(700L).toNanos() / 1000L));
        Assertions.assertThat((Object)schemaM.defaultValue()).isEqualTo((Object)(Duration.ofHours(123L).plus(123456L, ChronoUnit.MICROS).toNanos() / 1000L));
        ZonedDateTime t5 = ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
        String isoString5 = ZonedTimestamp.toIsoString((Object)t5, (ZoneId)ZoneOffset.UTC, MySqlValueConverters::adjustTemporal, null);
        Assertions.assertThat((Object)schemaJ.defaultValue()).isEqualTo((Object)MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).databaseAsserts().currentDateTimeDefaultOptional(isoString5));
        this.assertEmptyFieldValue(record, "K");
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    public void timeTypeWithConnectMode() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("DATE_TIME_TABLE"))).with(MySqlConnectorConfig.TIME_PRECISION_MODE, (EnumeratedValue)TemporalPrecisionMode.CONNECT)).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("DATE_TIME_TABLE")).get(0);
        this.validate(record);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Schema schemaG = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(6)).schema();
        Schema schemaH = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(7)).schema();
        Schema schemaI = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(8)).schema();
        TemporalAccessor accessor = DateTimeFormatter.ofPattern("yyyy-MM-dd").parse("1976-08-23");
        Instant instant = LocalDate.from(accessor).atStartOfDay().toInstant(ZoneOffset.UTC);
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)Date.from(instant));
        String value1 = "1970-01-01 00:00:01";
        ZonedDateTime t = Timestamp.valueOf(value1).toInstant().atZone(ZoneId.systemDefault());
        String isoString = MysqlDefaultValueIT.getZonedDateTimeIsoString(t);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo((Object)isoString);
        LocalDateTime localDateTimeC = LocalDateTime.from(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").parse("2018-01-03 00:00:10"));
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo((Object)new Date(io.debezium.time.Timestamp.toEpochMillis((Object)localDateTimeC, MySqlValueConverters::adjustTemporal)));
        LocalDateTime localDateTimeD = LocalDateTime.from(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.S").parse("2018-01-03 00:00:10.7"));
        Assertions.assertThat((Object)schemaD.defaultValue()).isEqualTo((Object)new Date(io.debezium.time.Timestamp.toEpochMillis((Object)localDateTimeD, MySqlValueConverters::adjustTemporal)));
        LocalDateTime localDateTimeE = LocalDateTime.from(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS").parse("2018-01-03 00:00:10.123456"));
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)new Date(io.debezium.time.Timestamp.toEpochMillis((Object)localDateTimeE, MySqlValueConverters::adjustTemporal)));
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo((Object)2001);
        LocalTime localTime = java.sql.Time.valueOf("00:00:00").toLocalTime();
        Date date = new Date(io.debezium.time.Timestamp.toEpochMillis((Object)localTime, MySqlValueConverters::adjustTemporal));
        Assertions.assertThat((Object)schemaG.defaultValue()).isEqualTo((Object)date);
        Duration duration1 = Duration.between(LocalTime.MIN, LocalTime.from(DateTimeFormatter.ofPattern("HH:mm:ss.S").parse("23:00:00.7")));
        Assertions.assertThat((Object)schemaH.defaultValue()).isEqualTo((Object)new Date(Time.toMilliOfDay((Object)duration1, (boolean)false)));
        Duration duration2 = Duration.between(LocalTime.MIN, LocalTime.from(DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSS").parse("23:00:00.123456")));
        Assertions.assertThat((Object)schemaI.defaultValue()).isEqualTo((Object)new Date(Time.toMilliOfDay((Object)duration2, (boolean)false)));
        this.assertEmptyFieldValue(record, "K");
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    @FixFor(value={"DBZ-7143"})
    public void timeTypeWithConnectModeWhenEventConvertingFail() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("DATE_TIME_TABLE_CONNECT_FAIL"))).with(MySqlConnectorConfig.TIME_PRECISION_MODE, (EnumeratedValue)TemporalPrecisionMode.CONNECT)).with(CommonConnectorConfig.EVENT_CONVERTING_FAILURE_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.EventConvertingFailureHandlingMode.FAIL)).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).build();
        AtomicReference exception = new AtomicReference();
        this.start(MySqlConnector.class, this.config, (success, message, error) -> exception.set(error));
        MysqlDefaultValueIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"CREATE TABLE DATE_TIME_TABLE_CONNECT_FAIL (A TIME(1) DEFAULT '-23:45:56.7', B TIME(6) DEFAULT '123:00:00.123456');"});
        }
        MysqlDefaultValueIT.waitForConnectorShutdown((String)"mysql", (String)this.DATABASE.getServerName());
        Throwable e = (Throwable)exception.get();
        if (e == null) {
            Assert.fail();
        }
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    @FixFor(value={"DBZ-771"})
    public void columnTypeAndDefaultValueChange() throws Exception {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("DBZ_771_CUSTOMERS")).get(0);
        this.validate(record);
        Schema customerTypeSchema = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Assertions.assertThat((Object)customerTypeSchema.defaultValue()).isEqualTo((Object)"b2c");
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            db.databaseAsserts().setBinlogRowQueryEventsOn(connection);
            connection.execute(new String[]{"alter table DBZ_771_CUSTOMERS change customer_type customer_type int default 42;"});
            connection.execute(new String[]{"insert into DBZ_771_CUSTOMERS (id) values (2);"});
        }
        records = this.consumeRecordsByTopic(2);
        record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("DBZ_771_CUSTOMERS")).get(0);
        this.validate(record);
        customerTypeSchema = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Assertions.assertThat((Object)customerTypeSchema.defaultValue()).isEqualTo((Object)42);
    }

    @Test
    @SkipWhenKafkaVersion(check=EqualityCheck.EQUAL, value=SkipWhenKafkaVersion.KafkaVersion.KAFKA_1XX, description="Not compatible with Kafka 1.x")
    @FixFor(value={"DBZ-771", "DBZ-1321"})
    public void columnTypeChangeResetsDefaultValue() throws Exception {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(46);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("DBZ_771_CUSTOMERS")).get(0);
        this.validate(record);
        Schema customerTypeSchema = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Assertions.assertThat((Object)customerTypeSchema.defaultValue()).isEqualTo((Object)"b2c");
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            db.databaseAsserts().setBinlogRowQueryEventsOn(connection);
            connection.execute(new String[]{"alter table DBZ_771_CUSTOMERS change customer_type customer_type int;"});
            connection.execute(new String[]{"insert into DBZ_771_CUSTOMERS (id, customer_type) values (2, 456);"});
            connection.execute(new String[]{"alter table DBZ_771_CUSTOMERS modify customer_type int null;"});
            connection.execute(new String[]{"alter table DBZ_771_CUSTOMERS modify customer_type int not null;"});
        }
        records = this.consumeRecordsByTopic(4);
        record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("DBZ_771_CUSTOMERS")).get(0);
        this.validate(record);
        customerTypeSchema = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Assertions.assertThat((Object)customerTypeSchema.defaultValue()).isNull();
    }

    @Test
    @FixFor(value={"DBZ-2267", "DBZ-6029"})
    public void alterDateAndTimeTest() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("ALTER_DATE_TIME"))).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).build();
        this.start(MySqlConnector.class, this.config);
        MysqlDefaultValueIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        Testing.Print.enable();
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"create table ALTER_DATE_TIME (ID int primary key);"});
            connection.execute(new String[]{"alter table ALTER_DATE_TIME add column (CREATED timestamp not null default current_timestamp, C time not null default '08:00')"});
            connection.execute(new String[]{"insert into ALTER_DATE_TIME values(1000, default, default);"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        SourceRecord record = (SourceRecord)records.allRecordsInOrder().get(0);
        this.validate(record);
        Schema columnSchema = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Assertions.assertThat((Object)columnSchema.defaultValue()).isEqualTo((Object)"1970-01-01T00:00:00Z");
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo((Object)28800000000L);
    }

    @Test
    @FixFor(value={"DBZ-4822"})
    public void shouldConvertDefaultBoolean2Number() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NO_DATA)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("DBZ_4822_DEFAULT_BOOLEAN"))).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(MySqlConnectorConfig.DECIMAL_HANDLING_MODE, (EnumeratedValue)RelationalDatabaseConnectorConfig.DecimalHandlingMode.STRING)).build();
        this.start(MySqlConnector.class, this.config);
        MysqlDefaultValueIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            String addColumnDdl = "CREATE TABLE DBZ_4822_DEFAULT_BOOLEAN (\nID INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\nC0 BIGINT NULL DEFAULT TRUE,\nC1 INT(1) NULL DEFAULT true,\nC2 BIT DEFAULT true,\nC3 TINYINT DEFAULT false,\nC4 FLOAT DEFAULT false,\nC5 REAL DEFAULT false\n,C6 DOUBLE DEFAULT false\n,C7 NUMERIC(38, 26) DEFAULT false,\nC8 DECIMAL(10, 2) DEFAULT false,\nC9 BIGINT DEFAULT false);";
            connection.execute(new String[]{addColumnDdl});
            connection.execute(new String[]{"insert into DBZ_4822_DEFAULT_BOOLEAN (C0) values(1000);"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(100);
        Assertions.assertThat((Object)records).isNotNull();
        List events = records.recordsForTopic(this.DATABASE.topicForTable("DBZ_4822_DEFAULT_BOOLEAN"));
        Assertions.assertThat((List)events).hasSize(1);
        SourceRecord record = (SourceRecord)events.get(0);
        Struct change = ((Struct)record.value()).getStruct("after");
        Assertions.assertThat((Object)change.get("C7")).isEqualTo((Object)"0.00000000000000000000000000");
        Assertions.assertThat((Object)change.get("C8")).isEqualTo((Object)"0.00");
        Assertions.assertThat((Object)change.get("C9")).isEqualTo((Object)0L);
    }

    @Test
    @FixFor(value={"DBZ-5241"})
    public void shouldConvertDefaultWithCharacterSetIntroducer() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NO_DATA)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("DBZ_5241_DEFAULT_CS_INTRO"))).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).build();
        this.start(MySqlConnector.class, this.config);
        MysqlDefaultValueIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            String createTable = "CREATE TABLE DBZ_5241_DEFAULT_CS_INTRO (\nID INT NOT NULL AUTO_INCREMENT PRIMARY KEY, \nC0 BIGINT NOT NULL, \nC1 TINYINT(4) UNSIGNED DEFAULT 0, \nC2 TINYINT(4) UNSIGNED DEFAULT _UTF8MB4'0' COMMENT 'c2', \nC3 TINYINT(1) NOT NULL DEFAULT _UTF8MB4'0' COMMENT 'c3', \nC4 VARCHAR(25) DEFAULT _utf8'abc', \nC5 VARCHAR(25) NOT NULL DEFAULT _utf8'abc', \nC6 CHAR(25) DEFAULT _utf8'abc', \nC7 CHAR(25) NOT NULL DEFAULT _utf8'abc', \nC8 BIGINT UNSIGNED DEFAULT _UTF8MB4'0', \nC9 BIGINT UNSIGNED NOT NULL DEFAULT _UTF8MB4'0', \nC10 INT DEFAULT _utf8'0', \nC11 INT NOT NULL DEFAULT _utf8'0', \nC12 MEDIUMINT DEFAULT _utf8'0', \nC13 MEDIUMINT NOT NULL DEFAULT _utf8'0', \nC14 SMALLINT DEFAULT _utf8'0', \nC15 SMALLINT NOT NULL DEFAULT _utf8'0', \nC16 NUMERIC(3, 2) DEFAULT _UTF8MB4'1.23', \nC17 NUMERIC(3, 2) NOT NULL DEFAULT _UTF8MB4'1.23', \nC18 REAL DEFAULT _UTF8MB4'3.14', \nC19 REAL NOT NULL DEFAULT _UTF8MB4'3.14');";
            connection.execute(new String[]{"CREATE TABLE DBZ_5241_DEFAULT_CS_INTRO (\nID INT NOT NULL AUTO_INCREMENT PRIMARY KEY, \nC0 BIGINT NOT NULL, \nC1 TINYINT(4) UNSIGNED DEFAULT 0, \nC2 TINYINT(4) UNSIGNED DEFAULT _UTF8MB4'0' COMMENT 'c2', \nC3 TINYINT(1) NOT NULL DEFAULT _UTF8MB4'0' COMMENT 'c3', \nC4 VARCHAR(25) DEFAULT _utf8'abc', \nC5 VARCHAR(25) NOT NULL DEFAULT _utf8'abc', \nC6 CHAR(25) DEFAULT _utf8'abc', \nC7 CHAR(25) NOT NULL DEFAULT _utf8'abc', \nC8 BIGINT UNSIGNED DEFAULT _UTF8MB4'0', \nC9 BIGINT UNSIGNED NOT NULL DEFAULT _UTF8MB4'0', \nC10 INT DEFAULT _utf8'0', \nC11 INT NOT NULL DEFAULT _utf8'0', \nC12 MEDIUMINT DEFAULT _utf8'0', \nC13 MEDIUMINT NOT NULL DEFAULT _utf8'0', \nC14 SMALLINT DEFAULT _utf8'0', \nC15 SMALLINT NOT NULL DEFAULT _utf8'0', \nC16 NUMERIC(3, 2) DEFAULT _UTF8MB4'1.23', \nC17 NUMERIC(3, 2) NOT NULL DEFAULT _UTF8MB4'1.23', \nC18 REAL DEFAULT _UTF8MB4'3.14', \nC19 REAL NOT NULL DEFAULT _UTF8MB4'3.14');"});
            connection.execute(new String[]{"INSERT INTO DBZ_5241_DEFAULT_CS_INTRO (C0) values (1);"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(100);
        List events = records.recordsForTopic(this.DATABASE.topicForTable("DBZ_5241_DEFAULT_CS_INTRO"));
        Assertions.assertThat((List)events).hasSize(1);
        SourceRecord record = (SourceRecord)events.get(0);
        Struct change = ((Struct)record.value()).getStruct("after");
        this.assertFieldDefaultValue(change, "C1", (short)0);
        this.assertFieldDefaultValue(change, "C2", (short)0);
        this.assertFieldDefaultValue(change, "C3", (short)0);
        this.assertFieldDefaultValue(change, "C4", "abc");
        this.assertFieldDefaultValue(change, "C5", "abc");
        this.assertFieldDefaultValue(change, "C6", "abc");
        this.assertFieldDefaultValue(change, "C7", "abc");
        this.assertFieldDefaultValue(change, "C8", 0L);
        this.assertFieldDefaultValue(change, "C9", 0L);
        this.assertFieldDefaultValue(change, "C10", 0);
        this.assertFieldDefaultValue(change, "C11", 0);
        this.assertFieldDefaultValue(change, "C12", 0);
        this.assertFieldDefaultValue(change, "C13", 0);
        this.assertFieldDefaultValue(change, "C14", (short)0);
        this.assertFieldDefaultValue(change, "C15", (short)0);
        this.assertFieldDefaultValue(change, "C16", BigDecimal.valueOf(1.23));
        this.assertFieldDefaultValue(change, "C17", BigDecimal.valueOf(1.23));
        this.assertFieldDefaultValue(change, "C18", Float.valueOf(3.14f));
        this.assertFieldDefaultValue(change, "C19", Float.valueOf(3.14f));
    }

    private void assertFieldDefaultValue(Struct value, String fieldName, Object defaultValue) {
        Assertions.assertThat((Object)value.schema().field(fieldName).schema().defaultValue()).isEqualTo(defaultValue);
    }

    private static String getZonedDateTimeIsoString(ZonedDateTime zdt) {
        if (MySqlTestConnection.isMariaDb()) {
            long serverOffsetSecs = UniqueDatabase.TIMEZONE.getRules().getOffset(zdt.toInstant()).getTotalSeconds();
            long hostOffsetSecs = ZoneOffset.systemDefault().getRules().getOffset(zdt.toInstant()).getTotalSeconds();
            long timeDelta = serverOffsetSecs - hostOffsetSecs;
            zdt = zdt.minusSeconds(timeDelta);
            return ZonedTimestamp.toIsoString((Object)zdt, (ZoneId)UniqueDatabase.TIMEZONE, MySqlValueConverters::adjustTemporal, null);
        }
        return ZonedTimestamp.toIsoString((Object)zdt, (ZoneId)ZoneId.systemDefault(), MySqlValueConverters::adjustTemporal, null);
    }
}

