/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.processors.AbstractReselectProcessorTest;
import io.debezium.processors.reselect.ReselectColumnsPostProcessor;
import io.debezium.util.Testing;
import java.nio.file.Path;
import org.junit.After;
import org.junit.Before;

public class MySqlReselectColumnsProcessorIT
extends AbstractReselectProcessorTest<MySqlConnector> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-reselect-processor.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("processor", "empty").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private MySqlTestConnection connection;

    @Before
    public void beforeEach() throws Exception {
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        this.connection = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
        if (this.connection != null) {
            this.connection.close();
        }
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    protected Class<MySqlConnector> getConnectorClass() {
        return MySqlConnector.class;
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected Configuration.Builder getConfigurationBuilder() {
        return ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("dbz4321"))).with(MySqlConnectorConfig.CUSTOM_POST_PROCESSORS, "reselector")).with("reselector.type", ReselectColumnsPostProcessor.class.getName());
    }

    protected String topicName() {
        return this.DATABASE.topicForTable("dbz4321");
    }

    protected String tableName() {
        return this.DATABASE.qualifiedTableName("dbz4321");
    }

    protected String reselectColumnsList() {
        return this.DATABASE.qualifiedTableName("dbz4321") + ":data";
    }

    protected void createTable() throws Exception {
        this.connection.execute(new String[]{"CREATE TABLE dbz4321 (id int primary key, data varchar(50), data2 int);"});
    }

    protected void dropTable() throws Exception {
    }

    protected String getInsertWithValue() {
        return "INSERT INTO dbz4321 (id,data,data2) values (1,'one',1);";
    }

    protected String getInsertWithNullValue() {
        return "INSERT INTO dbz4321 (id,data,data2) values (1,null,1);";
    }

    protected void waitForStreamingStarted() throws InterruptedException {
        MySqlReselectColumnsProcessorIT.waitForStreamingRunning((String)"mysql", (String)this.DATABASE.getServerName());
    }

    protected AbstractConnectorTest.SourceRecords consumeRecordsByTopicReselectWhenNotNullSnapshot() throws InterruptedException {
        return this.consumeRecordsByTopic(7);
    }

    protected AbstractConnectorTest.SourceRecords consumeRecordsByTopicReselectWhenNotNullStreaming() throws InterruptedException {
        return this.consumeRecordsByTopic(10);
    }

    protected AbstractConnectorTest.SourceRecords consumeRecordsByTopicReselectWhenNullSnapshot() throws InterruptedException {
        return this.consumeRecordsByTopic(7);
    }

    protected AbstractConnectorTest.SourceRecords consumeRecordsByTopicReselectWhenNullStreaming() throws InterruptedException {
        return this.consumeRecordsByTopic(8);
    }
}

