/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.data.VerifyRecord;
import io.debezium.embedded.async.AbstractAsyncEngineConnectorTest;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.storage.file.history.FileSchemaHistory;
import io.debezium.util.Testing;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.sql.Connection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MySqlMetricsIT
extends AbstractAsyncEngineConnectorTest {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-metrics.txt").toAbsolutePath();
    private static final String SERVER_NAME = "myserver";
    private final UniqueDatabase DATABASE = new UniqueDatabase("myserver", "connector_metrics_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private static final String INSERT1 = "INSERT INTO simple (val) VALUES (25);";
    private static final String INSERT2 = "INSERT INTO simple (val) VALUES (50);";

    @Before
    public void before() throws Exception {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws Exception {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    public void testLifecycle() throws Exception {
        this.start(MySqlConnector.class, ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.SCHEMA_HISTORY, FileSchemaHistory.class)).with(FileSchemaHistory.FILE_PATH, (Object)SCHEMA_HISTORY_PATH)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("simple"))).with(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN, (Object)Boolean.TRUE)).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, (Object)Boolean.TRUE)).build());
        this.assertConnectorIsRunning();
        this.waitForSnapshotToBeCompleted();
        this.waitForStreamingToStart();
        this.stopConnector();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mBeanServer.getMBeanInfo(this.getSnapshotMetricsObjectName());
            Assert.fail((String)"Expected Snapshot Metrics no longer to exist");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        try {
            mBeanServer.getMBeanInfo(this.getStreamingMetricsObjectName());
            Assert.fail((String)"Expected Streaming Metrics no longer to exist");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testSnapshotOnlyMetrics() throws Exception {
        try (Connection connection = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            connection.createStatement().execute(INSERT1);
            connection.createStatement().execute(INSERT2);
        }
        this.start(MySqlConnector.class, ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL_ONLY)).with(MySqlConnectorConfig.SCHEMA_HISTORY, FileSchemaHistory.class)).with(FileSchemaHistory.FILE_PATH, (Object)SCHEMA_HISTORY_PATH)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("simple"))).with(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN, (Object)Boolean.TRUE)).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, (Object)Boolean.TRUE)).build());
        this.assertSnapshotMetrics();
        this.assertStreamingMetricsExist();
    }

    @Test
    public void testPauseResumeSnapshotMetrics() throws Exception {
        int NUM_RECORDS = 1000;
        String TABLE_NAME = this.DATABASE.qualifiedTableName("simple");
        String SIGNAL_TABLE_NAME = this.DATABASE.qualifiedTableName("debezium_signal");
        try (Connection connection = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            for (int i = 1; i < 1000; ++i) {
                connection.createStatement().execute(String.format("INSERT INTO %s (val) VALUES (%d);", TABLE_NAME, i));
            }
        }
        this.start(MySqlConnector.class, ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.SCHEMA_HISTORY, FileSchemaHistory.class)).with(FileSchemaHistory.FILE_PATH, (Object)SCHEMA_HISTORY_PATH)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, String.format("%s", TABLE_NAME))).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, (Object)Boolean.TRUE)).with(CommonConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 1)).with(CommonConnectorConfig.SIGNAL_POLL_INTERVAL_MS, 5)).with(MySqlConnectorConfig.SIGNAL_DATA_COLLECTION, SIGNAL_TABLE_NAME)).build());
        this.assertConnectorIsRunning();
        this.waitForSnapshotToBeCompleted();
        this.waitForStreamingToStart();
        ArrayList records = new ArrayList();
        this.consumeRecords(1000, record -> records.add(record));
        try (Connection connection = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            connection.createStatement().execute(String.format("INSERT INTO debezium_signal VALUES('ad-hoc', 'execute-snapshot', '{\"data-collections\": [\"%s\"]}')", TABLE_NAME));
            connection.createStatement().execute(String.format("INSERT INTO %s VALUES('test-pause', 'pause-snapshot', '')", SIGNAL_TABLE_NAME));
            Thread.sleep(1500L);
            connection.createStatement().execute(String.format("INSERT INTO debezium_signal VALUES('test-resume', 'resume-snapshot', '')", SIGNAL_TABLE_NAME));
        }
        this.consumeRecords(1000, record -> records.add(record));
        Assert.assertTrue((records.size() >= 2000 ? 1 : 0) != 0);
        this.assertSnapshotPauseNotZero();
    }

    @Test
    public void testSnapshotAndStreamingMetrics() throws Exception {
        try (Connection connection = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            connection.createStatement().execute(INSERT1);
            connection.createStatement().execute(INSERT2);
        }
        this.start(MySqlConnector.class, ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.SCHEMA_HISTORY, FileSchemaHistory.class)).with(FileSchemaHistory.FILE_PATH, (Object)SCHEMA_HISTORY_PATH)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("simple"))).with(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN, (Object)Boolean.TRUE)).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, (Object)Boolean.TRUE)).build());
        this.assertSnapshotMetrics();
        this.assertStreamingMetrics(0L);
    }

    @Test
    public void testStreamingOnlyMetrics() throws Exception {
        this.start(MySqlConnector.class, ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.SCHEMA_HISTORY, FileSchemaHistory.class)).with(FileSchemaHistory.FILE_PATH, (Object)SCHEMA_HISTORY_PATH)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("simple"))).with(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN, (Object)Boolean.TRUE)).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, (Object)Boolean.TRUE)).build());
        this.assertStreamingMetrics(4L);
        this.assertSnapshotMetricsExist();
    }

    private void assertNoSnapshotMetricsExist() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotCompleted");
            Assert.fail((String)"Expected Snapshot Metrics to not exist");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    private void assertNoStreamingMetricsExist() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mBeanServer.getAttribute(this.getStreamingMetricsObjectName(), "TotalNumberOfEventsSeen");
            Assert.fail((String)"Expected Streaming Metrics to not exist");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    private void assertStreamingMetricsExist() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mBeanServer.getAttribute(this.getStreamingMetricsObjectName(), "TotalNumberOfEventsSeen");
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)"Streaming Metrics should exist");
        }
    }

    private void assertSnapshotMetricsExist() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotCompleted");
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)"Snapshot Metrics should exist");
        }
    }

    private void assertSnapshotPauseNotZero() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            long snapshotPauseDuration = (Long)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotPausedDurationInSeconds");
            Assert.assertTrue((snapshotPauseDuration > 0L ? 1 : 0) != 0);
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)"Snapshot Metrics should exist");
        }
    }

    private void assertSnapshotMetrics() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.waitForSnapshotToBeCompleted();
        this.consumeRecords(8);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "TotalTableCount")).isEqualTo((Object)1);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "CapturedTables")).isEqualTo((Object)new String[]{this.DATABASE.qualifiedTableName("simple")});
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "TotalNumberOfEventsSeen")).isEqualTo((Object)2L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "NumberOfEventsFiltered")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "NumberOfErroneousEvents")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "RemainingTableCount")).isEqualTo((Object)0);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotRunning")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotAborted")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotCompleted")).isEqualTo((Object)true);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotPaused")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getSnapshotMetricsObjectName(), "SnapshotPausedDurationInSeconds")).isEqualTo((Object)0L);
    }

    private void assertStreamingMetrics(long events) throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.waitForStreamingToStart();
        try (Connection connection = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            connection.createStatement().execute(INSERT1);
            connection.createStatement().execute(INSERT2);
        }
        this.waitForAvailableRecords(30L, TimeUnit.SECONDS);
        int size = this.consumeAvailableRecords(VerifyRecord::print);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getStreamingMetricsObjectName(), "Connected")).isEqualTo((Object)true);
        Assertions.assertThat((Long)((Long)mBeanServer.getAttribute(this.getStreamingMetricsObjectName(), "TotalNumberOfEventsSeen"))).isGreaterThanOrEqualTo(events);
        Awaitility.await().atMost(Duration.ofMinutes(1L)).until(() -> ((String[])mBeanServer.getAttribute(this.getStreamingMetricsObjectName(), "CapturedTables")).length > 0);
        Assertions.assertThat((Object)mBeanServer.getAttribute(this.getStreamingMetricsObjectName(), "CapturedTables")).isEqualTo((Object)new String[]{this.DATABASE.qualifiedTableName("simple")});
    }

    private ObjectName getSnapshotMetricsObjectName() throws MalformedObjectNameException {
        return MySqlMetricsIT.getSnapshotMetricsObjectName((String)"mysql", (String)SERVER_NAME);
    }

    private ObjectName getStreamingMetricsObjectName() throws MalformedObjectNameException {
        return MySqlMetricsIT.getStreamingMetricsObjectName((String)"mysql", (String)SERVER_NAME, (String)MySqlMetricsIT.getStreamingNamespace());
    }

    private void waitForSnapshotToBeCompleted() throws InterruptedException {
        MySqlMetricsIT.waitForSnapshotToBeCompleted((String)"mysql", (String)SERVER_NAME);
    }

    private void waitForStreamingToStart() throws InterruptedException {
        MySqlMetricsIT.waitForStreamingRunning((String)"mysql", (String)SERVER_NAME, (String)MySqlMetricsIT.getStreamingNamespace());
    }
}

