/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@SkipWhenDatabaseVersion(check=EqualityCheck.LESS_THAN, major=5, minor=6, reason="DDL uses fractional second data types, not supported until MySQL 5.6")
public class MySqlConnectorConvertingFailureIT
extends AbstractConnectorTest {
    private static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-converting-failure.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("converting_failure", "converting_failure").withDbHistoryPath(DB_HISTORY_PATH);
    private Configuration config;
    private static final int INITIAL_EVENT_COUNT = 8;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)DB_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)DB_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-7143"})
    public void shouldRecoverToSyncSchemaWhenFailedValueConvertByDdlWithSqlLogBinIsOff() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.replica.hostname", "localhost"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.replica.port", "3306"))).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NO_DATA)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("dbz7143"))).with(MySqlConnectorConfig.EVENT_CONVERTING_FAILURE_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.EventConvertingFailureHandlingMode.FAIL)).build();
        AtomicReference exception = new AtomicReference();
        this.start(MySqlConnector.class, this.config, (success, message, error) -> exception.set(error));
        MySqlConnectorConvertingFailureIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        String masterPort = System.getProperty("database.port", "3306");
        String replicaPort = System.getProperty("database.replica.port", "3306");
        boolean replicaIsMaster = masterPort.equals(replicaPort);
        if (!replicaIsMaster) {
            Thread.sleep(5000L);
        }
        this.alterTableWithSqlBinLogOff("ALTER TABLE dbz7143 MODIFY COLUMN age VARCHAR(200);", replicaIsMaster);
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"INSERT INTO dbz7143(id, name, age) VALUES (201, 'name1', 'age1');"});
            connection.execute(new String[]{"UPDATE dbz7143 SET age='age2' WHERE id=201;"});
            connection.execute(new String[]{"DELETE FROM dbz7143 WHERE id=201;"});
        }
        MySqlConnectorConvertingFailureIT.waitForConnectorShutdown((String)"mysql", (String)this.DATABASE.getServerName());
        this.stopConnector();
        Throwable e = (Throwable)exception.get();
        if (e == null) {
            Assert.fail();
        }
        Testing.Files.delete((Path)DB_HISTORY_PATH);
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.replica.hostname", "localhost"))).with(MySqlConnectorConfig.PORT, System.getProperty("database.replica.port", "3306"))).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.RECOVERY)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("dbz7143"))).build();
        this.start(MySqlConnector.class, this.config, (success, message, error) -> exception.set(error));
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(8);
        records = this.consumeRecordsByTopic(8);
        records = this.consumeRecordsByTopic(4);
        List recordsForTopic = records.recordsForTopic(this.DATABASE.topicForTable("dbz7143"));
        Assertions.assertThat((int)recordsForTopic.size()).isEqualTo(4);
        SourceRecord insertEvent = (SourceRecord)recordsForTopic.get(0);
        this.assertInsert(insertEvent, "id", 201);
        this.assertValueField(insertEvent, "after/age", "age1");
        SourceRecord updateEvent = (SourceRecord)recordsForTopic.get(1);
        this.assertUpdate(updateEvent, "id", 201);
        this.assertValueField(updateEvent, "before/age", "age1");
        this.assertValueField(updateEvent, "after/age", "age2");
        SourceRecord deleteEvent = (SourceRecord)recordsForTopic.get(2);
        this.assertDelete(deleteEvent, "id", 201);
        this.assertValueField(deleteEvent, "before/age", "age2");
        SourceRecord tombstoneEvent = (SourceRecord)recordsForTopic.get(3);
        this.assertTombstone(tombstoneEvent);
    }

    @Test
    @FixFor(value={"DBZ-7143"})
    public void shouldFailConversionNullableTimeTypeWithConnectModeWhenWarnMode() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NO_DATA)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("time_table"))).with(MySqlConnectorConfig.EVENT_CONVERTING_FAILURE_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.EventConvertingFailureHandlingMode.WARN)).with(MySqlConnectorConfig.TIME_PRECISION_MODE, (EnumeratedValue)TemporalPrecisionMode.CONNECT)).build();
        AtomicReference exception = new AtomicReference();
        this.start(MySqlConnector.class, this.config, (success, message, error) -> exception.set(error));
        MySqlConnectorConvertingFailureIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"INSERT INTO time_table VALUES (201, '-23:45:56.7', '123:00:00.123456', '23:45:56.0');"});
        }
        MySqlConnectorConvertingFailureIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(8);
        records = this.consumeRecordsByTopic(1);
        List recordsForTopic = records.recordsForTopic(this.DATABASE.topicForTable("time_table"));
        SourceRecord insertEvent = (SourceRecord)recordsForTopic.get(0);
        this.assertInsert(insertEvent, "id", 201);
        this.assertValueField(insertEvent, "after/A", null);
        this.assertValueField(insertEvent, "after/B", null);
    }

    @Test
    @FixFor(value={"DBZ-7143"})
    public void shouldFailedConvertedValueIsNullWithSkipMode() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NO_DATA)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("dbz7143"))).with(MySqlConnectorConfig.EVENT_CONVERTING_FAILURE_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.EventConvertingFailureHandlingMode.SKIP)).build();
        AtomicReference exception = new AtomicReference();
        this.start(MySqlConnector.class, this.config, (success, message, error) -> exception.set(error));
        MySqlConnectorConvertingFailureIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        String masterPort = System.getProperty("database.port", "3306");
        String replicaPort = System.getProperty("database.replica.port", "3306");
        boolean replicaIsMaster = masterPort.equals(replicaPort);
        if (!replicaIsMaster) {
            Thread.sleep(5000L);
        }
        this.alterTableWithSqlBinLogOff("ALTER TABLE dbz7143 MODIFY COLUMN age VARCHAR(200);", replicaIsMaster);
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"INSERT INTO dbz7143(id, name, age) VALUES (201, 'name1', 'age1');"});
            connection.execute(new String[]{"UPDATE dbz7143 SET age='age2' WHERE id=201;"});
            connection.execute(new String[]{"DELETE FROM dbz7143 WHERE id=201;"});
        }
        MySqlConnectorConvertingFailureIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(8);
        records = this.consumeRecordsByTopic(4);
        List recordsForTopic = records.recordsForTopic(this.DATABASE.topicForTable("dbz7143"));
        Assertions.assertThat((int)recordsForTopic.size()).isEqualTo(4);
        SourceRecord insertEvent = (SourceRecord)recordsForTopic.get(0);
        this.assertInsert(insertEvent, "id", 201);
        this.assertValueField(insertEvent, "after/age", null);
        SourceRecord updateEvent = (SourceRecord)recordsForTopic.get(1);
        this.assertUpdate(updateEvent, "id", 201);
        this.assertValueField(updateEvent, "before/age", null);
        this.assertValueField(updateEvent, "after/age", null);
        SourceRecord deleteEvent = (SourceRecord)recordsForTopic.get(2);
        this.assertDelete(deleteEvent, "id", 201);
        this.assertValueField(deleteEvent, "before/age", null);
        SourceRecord tombstoneEvent = (SourceRecord)recordsForTopic.get(3);
        this.assertTombstone(tombstoneEvent);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-7143"})
    public void shouldFailConversionNotNullTimeTypeWithConnectModeWhenWarnMode() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NO_DATA)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("time_table"))).with(MySqlConnectorConfig.EVENT_CONVERTING_FAILURE_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.EventConvertingFailureHandlingMode.WARN)).with(MySqlConnectorConfig.TIME_PRECISION_MODE, (EnumeratedValue)TemporalPrecisionMode.CONNECT)).build();
        AtomicReference exception = new AtomicReference();
        this.start(MySqlConnector.class, this.config, (success, message, error) -> exception.set(error));
        MySqlConnectorConvertingFailureIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"INSERT INTO time_table VALUES (201, '23:45:56.7', '23:00:00.123456', '-23:45:56.0');"});
        }
        MySqlConnectorConvertingFailureIT.waitForConnectorShutdown((String)"mysql", (String)this.DATABASE.getServerName());
        this.stopConnector();
        Throwable e = (Throwable)exception.get();
        if (e == null) {
            Assert.fail();
        }
    }

    @Test
    @FixFor(value={"DBZ-7143"})
    public void shouldFailConversionTimeTypeWithConnectModeWhenFailMode() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NO_DATA)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("time_table"))).with(MySqlConnectorConfig.EVENT_CONVERTING_FAILURE_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.EventConvertingFailureHandlingMode.FAIL)).with(MySqlConnectorConfig.TIME_PRECISION_MODE, (EnumeratedValue)TemporalPrecisionMode.CONNECT)).build();
        AtomicReference exception = new AtomicReference();
        this.start(MySqlConnector.class, this.config, (success, message, error) -> exception.set(error));
        MySqlConnectorConvertingFailureIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"INSERT INTO time_table VALUES (201, '-23:45:56.7', '123:00:00.123456', '23:45:56.0');"});
        }
        MySqlConnectorConvertingFailureIT.waitForConnectorShutdown((String)"mysql", (String)this.DATABASE.getServerName());
        this.stopConnector();
        Throwable e = (Throwable)exception.get();
        if (e == null) {
            Assert.fail();
        }
    }

    @Test
    @FixFor(value={"DBZ-7143"})
    public void shouldFailConversionDefaultTimeTypeWithConnectModeWhenWarnMode() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NO_DATA)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("default_time_table"))).with(MySqlConnectorConfig.EVENT_CONVERTING_FAILURE_HANDLING_MODE, (EnumeratedValue)CommonConnectorConfig.EventConvertingFailureHandlingMode.WARN)).with(MySqlConnectorConfig.TIME_PRECISION_MODE, (EnumeratedValue)TemporalPrecisionMode.CONNECT)).build();
        AtomicReference exception = new AtomicReference();
        this.start(MySqlConnector.class, this.config, (success, message, error) -> exception.set(error));
        MySqlConnectorConvertingFailureIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"CREATE TABLE default_time_table (id INT NOT NULL, A TIME(1) DEFAULT '-23:45:56.7', B TIME(6) DEFAULT '123:00:00.123456', C TIME(1) NULL, PRIMARY KEY(id));"});
            connection.execute(new String[]{"INSERT INTO default_time_table VALUES (201, DEFAULT, DEFAULT, DEFAULT);"});
        }
        MySqlConnectorConvertingFailureIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(8);
        records = this.consumeRecordsByTopic(2);
        List recordsForTopic = records.recordsForTopic(this.DATABASE.topicForTable("default_time_table"));
        SourceRecord insertEvent = (SourceRecord)recordsForTopic.get(0);
        this.assertInsert(insertEvent, "id", 201);
        this.assertValueField(insertEvent, "after/A", null);
        this.assertValueField(insertEvent, "after/B", null);
        this.assertValueField(insertEvent, "after/C", null);
    }

    private void alterTableWithSqlBinLogOff(String ddl, boolean replicaIsMaster) throws SQLException {
        JdbcConnection connection;
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());){
            connection = db.connect();
            try {
                connection.execute(new String[]{"SET SQL_LOG_BIN=OFF;"});
                connection.execute(new String[]{ddl});
                connection.execute(new String[]{"SET SQL_LOG_BIN=ON;"});
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        if (!replicaIsMaster) {
            db = MySqlTestConnection.forTestReplicaDatabase(this.DATABASE.getDatabaseName());
            try {
                connection = db.connect();
                try {
                    connection.execute(new String[]{"SET SQL_LOG_BIN=OFF;"});
                    connection.execute(new String[]{ddl});
                    connection.execute(new String[]{"SET SQL_LOG_BIN=ON;"});
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
    }
}

