/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.strategy.mysql;

import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.RowsQueryEventData;
import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlBinaryProtocolFieldReader;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlFieldReader;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.MySqlTextProtocolFieldReader;
import io.debezium.connector.mysql.strategy.AbstractConnectorConnection;
import io.debezium.connector.mysql.strategy.AbstractHistoryRecordComparator;
import io.debezium.connector.mysql.strategy.BinaryLogClientConfigurator;
import io.debezium.connector.mysql.strategy.ConnectorAdapter;
import io.debezium.connector.mysql.strategy.mysql.MySqlBinaryLogClientConfigurator;
import io.debezium.connector.mysql.strategy.mysql.MySqlConnection;
import io.debezium.connector.mysql.strategy.mysql.MySqlConnectionConfiguration;
import io.debezium.connector.mysql.strategy.mysql.MySqlHistoryRecordComparator;
import io.debezium.connector.mysql.strategy.mysql.MySqlReadOnlyIncrementalSnapshotChangeEventSource;
import io.debezium.connector.mysql.strategy.mysql.MySqlReadOnlyIncrementalSnapshotContext;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.schema.DatabaseSchema;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlConnectorAdapter
implements ConnectorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlConnectorAdapter.class);
    private final MySqlConnectorConfig connectorConfig;
    private final MySqlBinaryLogClientConfigurator binaryLogClientConfigurator;

    public MySqlConnectorAdapter(MySqlConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
        this.binaryLogClientConfigurator = new MySqlBinaryLogClientConfigurator(connectorConfig);
    }

    @Override
    public AbstractConnectorConnection createConnection(Configuration configuration) {
        MySqlConnectionConfiguration connectionConfig = new MySqlConnectionConfiguration(configuration);
        return new MySqlConnection(connectionConfig, this.resolveFieldReader());
    }

    @Override
    public BinaryLogClientConfigurator getBinaryLogClientConfigurator() {
        return this.binaryLogClientConfigurator;
    }

    @Override
    public void setOffsetContextBinlogPositionAndGtidDetailsForSnapshot(MySqlOffsetContext offsetContext, AbstractConnectorConnection connection, SnapshotterService snapshotterService) throws Exception {
        LOGGER.info("Read binlog position of MySQL primary server");
        String showMasterStmt = "SHOW MASTER STATUS";
        connection.query("SHOW MASTER STATUS", rs -> {
            if (rs.next()) {
                String binlogFilename = rs.getString(1);
                long binlogPosition = rs.getLong(2);
                offsetContext.setBinlogStartPoint(binlogFilename, binlogPosition);
                if (rs.getMetaData().getColumnCount() > 4) {
                    String gtidSet = rs.getString(5);
                    offsetContext.setCompletedGtidSet(gtidSet);
                    LOGGER.info("\t using binlog '{}' at position '{}' and gtid '{}'", new Object[]{binlogFilename, binlogPosition, gtidSet});
                }
            } else if (!snapshotterService.getSnapshotter().shouldStream()) {
                LOGGER.warn("Failed retrieving binlog position, continuing as streaming CDC wasn't requested");
            } else {
                throw new DebeziumException("Cannot read the binlog filename and position via 'SHOW MASTER STATUS'. Make sure your server is correctly configured");
            }
        });
    }

    @Override
    public String getJavaEncodingForCharSet(String charSetName) {
        return MySqlConnection.getJavaEncodingForCharSet(charSetName);
    }

    @Override
    public String getRecordingQueryFromEvent(EventData eventData) {
        return ((RowsQueryEventData)eventData).getQuery();
    }

    @Override
    public AbstractHistoryRecordComparator getHistoryRecordComparator() {
        return new MySqlHistoryRecordComparator(this.connectorConfig.gtidSourceFilter());
    }

    @Override
    public <T> IncrementalSnapshotContext<T> getIncrementalSnapshotContext() {
        if (this.connectorConfig.isReadOnlyConnection()) {
            return new MySqlReadOnlyIncrementalSnapshotContext();
        }
        return new SignalBasedIncrementalSnapshotContext();
    }

    @Override
    public <T> IncrementalSnapshotContext<T> loadIncrementalSnapshotContextFromOffset(Map<String, ?> offset) {
        if (this.connectorConfig.isReadOnlyConnection()) {
            return MySqlReadOnlyIncrementalSnapshotContext.load(offset);
        }
        return SignalBasedIncrementalSnapshotContext.load(offset);
    }

    @Override
    public Long getReadOnlyIncrementalSnapshotSignalOffset(MySqlOffsetContext previousOffsets) {
        return ((MySqlReadOnlyIncrementalSnapshotContext)previousOffsets.getIncrementalSnapshotContext()).getSignalOffset();
    }

    @Override
    public IncrementalSnapshotChangeEventSource<MySqlPartition, ? extends DataCollectionId> createIncrementalSnapshotChangeEventSource(MySqlConnectorConfig connectorConfig, AbstractConnectorConnection connection, EventDispatcher<MySqlPartition, ? extends DataCollectionId> dispatcher, MySqlDatabaseSchema schema, Clock clock, SnapshotProgressListener<MySqlPartition> snapshotProgressListener, DataChangeEventListener<MySqlPartition> dataChangeEventListener, NotificationService<MySqlPartition, MySqlOffsetContext> notificationService) {
        return new MySqlReadOnlyIncrementalSnapshotChangeEventSource<DataCollectionId>((RelationalDatabaseConnectorConfig)connectorConfig, connection, dispatcher, (DatabaseSchema<?>)schema, clock, snapshotProgressListener, dataChangeEventListener, notificationService);
    }

    private MySqlFieldReader resolveFieldReader() {
        return this.connectorConfig != null && this.connectorConfig.useCursorFetch() ? new MySqlBinaryProtocolFieldReader(this.connectorConfig) : new MySqlTextProtocolFieldReader(this.connectorConfig);
    }
}

