/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.DebeziumException;
import io.debezium.bean.StandardBeanNames;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mysql.MariaDbProtocolFieldReader;
import io.debezium.connector.mysql.Module;
import io.debezium.connector.mysql.MySqlBinaryProtocolFieldReader;
import io.debezium.connector.mysql.MySqlChangeEventSourceFactory;
import io.debezium.connector.mysql.MySqlChangeEventSourceMetricsFactory;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlErrorHandler;
import io.debezium.connector.mysql.MySqlEventMetadataProvider;
import io.debezium.connector.mysql.MySqlFieldReader;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetrics;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.connector.mysql.MySqlTextProtocolFieldReader;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.strategy.AbstractConnectorConnection;
import io.debezium.connector.mysql.strategy.ConnectorAdapter;
import io.debezium.connector.mysql.strategy.mysql.MySqlConnection;
import io.debezium.connector.mysql.strategy.mysql.MySqlConnectionConfiguration;
import io.debezium.document.DocumentReader;
import io.debezium.jdbc.DefaultMainConnectionProvidingConnectionFactory;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.MainConnectionProvidingConnectionFactory;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.signal.SignalProcessor;
import io.debezium.pipeline.signal.channels.KafkaSignalChannel;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.snapshot.Snapshotter;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlConnectorTask
extends BaseSourceTask<MySqlPartition, MySqlOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlConnectorTask.class);
    private static final String CONTEXT_NAME = "mysql-connector-task";
    private volatile MySqlTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile AbstractConnectorConnection connection;
    private volatile AbstractConnectorConnection beanRegistryJdbcConnection;
    private volatile ErrorHandler errorHandler;
    private volatile MySqlDatabaseSchema schema;

    public String version() {
        return Module.version();
    }

    public ChangeEventSourceCoordinator<MySqlPartition, MySqlOffsetContext> start(Configuration configuration) {
        Clock clock = Clock.system();
        MySqlConnectorConfig connectorConfig = new MySqlConnectorConfig(configuration);
        TopicNamingStrategy topicNamingStrategy = connectorConfig.getTopicNamingStrategy(MySqlConnectorConfig.TOPIC_NAMING_STRATEGY);
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjuster();
        MySqlValueConverters valueConverters = this.getValueConverters(connectorConfig);
        Configuration config = ((Configuration.Builder)((Configuration.Builder)configuration.edit().withDefault("database.responseBuffering", "adaptive").withDefault("database.fetchSize", 10000)).withDefault("database.useCursorFetch", connectorConfig.useCursorFetch())).build();
        ConnectorAdapter adapter = connectorConfig.getConnectorAdapter();
        DefaultMainConnectionProvidingConnectionFactory connectionFactory = new DefaultMainConnectionProvidingConnectionFactory(() -> adapter.createConnection(config));
        this.connection = (AbstractConnectorConnection)connectionFactory.mainConnection();
        Offsets previousOffsets = this.getPreviousOffsets(new MySqlPartition.Provider(connectorConfig, config), new MySqlOffsetContext.Loader(connectorConfig));
        boolean tableIdCaseInsensitive = this.connection.isTableIdCaseSensitive();
        this.schema = new MySqlDatabaseSchema(connectorConfig, valueConverters, (TopicNamingStrategy<TableId>)topicNamingStrategy, schemaNameAdjuster, tableIdCaseInsensitive);
        this.beanRegistryJdbcConnection = (AbstractConnectorConnection)connectionFactory.newConnection();
        connectorConfig.getBeanRegistry().add(StandardBeanNames.CONFIGURATION, (Object)config);
        connectorConfig.getBeanRegistry().add("ConnectorConfig", (Object)connectorConfig);
        connectorConfig.getBeanRegistry().add("Schema", (Object)this.schema);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.JDBC_CONNECTION, (Object)this.beanRegistryJdbcConnection);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.VALUE_CONVERTER, (Object)valueConverters);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.OFFSETS, (Object)previousOffsets);
        this.registerServiceProviders(connectorConfig.getServiceRegistry());
        SnapshotterService snapshotterService = (SnapshotterService)connectorConfig.getServiceRegistry().tryGetService(SnapshotterService.class);
        Snapshotter snapshotter = snapshotterService.getSnapshotter();
        this.validateBinlogConfiguration(snapshotter);
        if (this.validateSnapshotFeasibility(snapshotter, previousOffsets.getTheOnlyOffset())) {
            previousOffsets.resetOffset((Partition)((MySqlPartition)previousOffsets.getTheOnlyPartition()));
        }
        LOGGER.info("Closing connection before starting schema recovery");
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new DebeziumException((Throwable)e);
        }
        MySqlOffsetContext previousOffset = (MySqlOffsetContext)previousOffsets.getTheOnlyOffset();
        this.validateAndLoadSchemaHistory((CommonConnectorConfig)connectorConfig, this.connection, previousOffsets, (DatabaseSchema)this.schema, snapshotter);
        LOGGER.info("Reconnecting after finishing schema recovery");
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new DebeziumException((Throwable)e);
        }
        if (previousOffset == null) {
            LOGGER.info("No previous offset found");
        } else {
            LOGGER.info("Found previous offset {}", (Object)previousOffset);
        }
        this.taskContext = new MySqlTaskContext(connectorConfig, this.schema);
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).buffering().build();
        this.errorHandler = new MySqlErrorHandler(connectorConfig, this.queue, this.errorHandler);
        MySqlEventMetadataProvider metadataProvider = new MySqlEventMetadataProvider();
        SignalProcessor signalProcessor = new SignalProcessor(MySqlConnector.class, (CommonConnectorConfig)connectorConfig, Map.of(), this.getAvailableSignalChannels(), DocumentReader.defaultReader(), previousOffsets);
        this.resetOffset(connectorConfig, previousOffset, (SignalProcessor<MySqlPartition, MySqlOffsetContext>)signalProcessor);
        Configuration heartbeatConfig = config;
        EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, topicNamingStrategy, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, null, (EventMetadataProvider)metadataProvider, connectorConfig.createHeartbeat(topicNamingStrategy, schemaNameAdjuster, () -> new MySqlConnection(new MySqlConnectionConfiguration(heartbeatConfig), this.getFieldReader(connectorConfig)), exception -> {
            String sqlErrorId;
            switch (sqlErrorId = exception.getSQLState()) {
                case "42000": {
                    throw new DebeziumException("Could not execute heartbeat action query (Error: " + sqlErrorId + ")", (Throwable)exception);
                }
                case "3D000": {
                    throw new DebeziumException("Could not execute heartbeat action query (Error: " + sqlErrorId + ")", (Throwable)exception);
                }
            }
        }), schemaNameAdjuster, signalProcessor);
        MySqlStreamingChangeEventSourceMetrics streamingMetrics = new MySqlStreamingChangeEventSourceMetrics(this.taskContext, (ChangeEventQueueMetrics)this.queue, metadataProvider);
        NotificationService notificationService = new NotificationService(this.getNotificationChannels(), (CommonConnectorConfig)connectorConfig, SchemaFactory.get(), arg_0 -> ((EventDispatcher)dispatcher).enqueueNotification(arg_0));
        ChangeEventSourceCoordinator coordinator = new ChangeEventSourceCoordinator(previousOffsets, this.errorHandler, MySqlConnector.class, (CommonConnectorConfig)connectorConfig, (ChangeEventSourceFactory)new MySqlChangeEventSourceFactory(connectorConfig, (MainConnectionProvidingConnectionFactory<AbstractConnectorConnection>)connectionFactory, this.errorHandler, (EventDispatcher<MySqlPartition, TableId>)dispatcher, clock, this.schema, this.taskContext, streamingMetrics, this.queue, snapshotterService), (ChangeEventSourceMetricsFactory)new MySqlChangeEventSourceMetricsFactory(streamingMetrics), dispatcher, (DatabaseSchema)this.schema, signalProcessor, notificationService, snapshotterService);
        coordinator.start((CdcSourceTaskContext)this.taskContext, this.queue, (EventMetadataProvider)metadataProvider);
        return coordinator;
    }

    private boolean validateSnapshotFeasibility(Snapshotter snapshotter, OffsetContext offset) {
        if (offset == null && !snapshotter.shouldSnapshotData(false, false)) {
            String earliestBinlogFilename = this.connection.earliestBinlogFilename();
            if (earliestBinlogFilename == null) {
                LOGGER.warn("No binlog appears to be available. Ensure that the MySQL row-level binlog is enabled.");
            } else if (!earliestBinlogFilename.endsWith("00001")) {
                LOGGER.warn("It is possible the server has purged some binlogs. If this is the case, then using snapshot mode may be required.");
            }
        }
        return false;
    }

    private MySqlValueConverters getValueConverters(MySqlConnectorConfig configuration) {
        TemporalPrecisionMode timePrecisionMode = configuration.getTemporalPrecisionMode();
        JdbcValueConverters.DecimalMode decimalMode = configuration.getDecimalMode();
        String bigIntUnsignedHandlingModeStr = configuration.getConfig().getString(MySqlConnectorConfig.BIGINT_UNSIGNED_HANDLING_MODE);
        MySqlConnectorConfig.BigIntUnsignedHandlingMode bigIntUnsignedHandlingMode = MySqlConnectorConfig.BigIntUnsignedHandlingMode.parse(bigIntUnsignedHandlingModeStr);
        JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode = bigIntUnsignedHandlingMode.asBigIntUnsignedMode();
        boolean timeAdjusterEnabled = configuration.getConfig().getBoolean(MySqlConnectorConfig.ENABLE_TIME_ADJUSTER);
        return new MySqlValueConverters(decimalMode, timePrecisionMode, bigIntUnsignedMode, configuration.binaryHandlingMode(), timeAdjusterEnabled ? MySqlValueConverters::adjustTemporal : x -> x, configuration.getConnectorAdapter(), configuration.getEventConvertingFailureHandlingMode());
    }

    private MySqlFieldReader getFieldReader(MySqlConnectorConfig configuration) {
        if (configuration.usesMariaDbProtocol()) {
            return new MariaDbProtocolFieldReader(configuration);
        }
        if (configuration.useCursorFetch()) {
            return new MySqlBinaryProtocolFieldReader(configuration);
        }
        return new MySqlTextProtocolFieldReader(configuration);
    }

    public List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        return sourceRecords;
    }

    protected void doStop() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC connection", (Throwable)e);
        }
        try {
            if (this.beanRegistryJdbcConnection != null) {
                this.beanRegistryJdbcConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC bean registry connection", (Throwable)e);
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return MySqlConnectorConfig.ALL_FIELDS;
    }

    private void validateBinlogConfiguration(Snapshotter snapshotter) {
        if (snapshotter.shouldStream()) {
            if (!this.connection.isBinlogFormatRow()) {
                throw new DebeziumException("The MySQL server is not configured to use a ROW binlog_format, which is required for this connector to work properly. Change the MySQL configuration to use a binlog_format=ROW and restart the connector.");
            }
            if (!this.connection.isBinlogRowImageFull()) {
                throw new DebeziumException("The MySQL server is not configured to use a FULL binlog_row_image, which is required for this connector to work properly. Change the MySQL configuration to use a binlog_row_image=FULL and restart the connector.");
            }
        }
    }

    private void resetOffset(MySqlConnectorConfig connectorConfig, MySqlOffsetContext previousOffset, SignalProcessor<MySqlPartition, MySqlOffsetContext> signalProcessor) {
        boolean isKafkaChannelEnabled = connectorConfig.getEnabledChannels().contains("kafka");
        if (previousOffset != null && isKafkaChannelEnabled && connectorConfig.isReadOnlyConnection()) {
            KafkaSignalChannel kafkaSignal = (KafkaSignalChannel)signalProcessor.getSignalChannel(KafkaSignalChannel.class);
            Long signalOffset = connectorConfig.getConnectorAdapter().getReadOnlyIncrementalSnapshotSignalOffset(previousOffset);
            if (signalOffset != null) {
                LOGGER.info("Resetting Kafka Signal offset to {}", (Object)signalOffset);
                kafkaSignal.reset((Object)signalOffset);
            }
        }
    }
}

