/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.junit;

import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.junit.SkipWhenDatabaseIs;
import io.debezium.connector.mysql.junit.SkipWhenDatabaseIsMultiple;
import io.debezium.junit.AnnotationBasedTestRule;
import io.debezium.junit.DatabaseVersionResolver;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.util.Strings;
import java.util.Set;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipTestDependingOnDatabaseRule
extends AnnotationBasedTestRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipTestDependingOnDatabaseRule.class);
    private static final boolean IS_MARIADB = MySqlTestConnection.isMariaDb();

    public Statement apply(Statement base, Description description) {
        SkipWhenDatabaseIsMultiple skipDatabaseIsMultiple = (SkipWhenDatabaseIsMultiple)this.hasAnnotation(description, SkipWhenDatabaseIsMultiple.class);
        if (skipDatabaseIsMultiple != null) {
            for (SkipWhenDatabaseIs skipWhenDatabaseIs : skipDatabaseIsMultiple.value()) {
                Statement result = this.applySkipWhenDatabaseIs(skipWhenDatabaseIs, description);
                if (result == null) continue;
                return result;
            }
        } else {
            Statement result;
            SkipWhenDatabaseIs skipWhenDatabaseIs = (SkipWhenDatabaseIs)this.hasAnnotation(description, SkipWhenDatabaseIs.class);
            if (skipWhenDatabaseIs != null && (result = this.applySkipWhenDatabaseIs(skipWhenDatabaseIs, description)) != null) {
                return result;
            }
        }
        LOGGER.info("No skip performed");
        return base;
    }

    private Statement applySkipWhenDatabaseIs(SkipWhenDatabaseIs skipWhenDatabaseIs, Description description) {
        String reason;
        LOGGER.info("@SkipWhenDatabaseIs detected: " + skipWhenDatabaseIs.value());
        if (IS_MARIADB && skipWhenDatabaseIs.value().equals((Object)SkipWhenDatabaseIs.Type.MARIADB)) {
            String reason2 = this.getDatabaseSkipReason(skipWhenDatabaseIs);
            if (!Strings.isNullOrBlank((String)reason2)) {
                return SkipTestDependingOnDatabaseRule.emptyStatement((String)reason2, (Description)description);
            }
        } else if (!IS_MARIADB && skipWhenDatabaseIs.value().equals((Object)SkipWhenDatabaseIs.Type.MYSQL) && !Strings.isNullOrBlank((String)(reason = this.getDatabaseSkipReason(skipWhenDatabaseIs)))) {
            return SkipTestDependingOnDatabaseRule.emptyStatement((String)reason, (Description)description);
        }
        return null;
    }

    private String getDatabaseSkipReason(SkipWhenDatabaseIs skipWhenDatabaseIs) {
        if (skipWhenDatabaseIs.versions().length == 0) {
            return skipWhenDatabaseIs.reason();
        }
        SkipWhenDatabaseVersion version = this.isVersionsSkipped(skipWhenDatabaseIs.versions());
        if (version != null) {
            return version.reason();
        }
        return null;
    }

    private SkipWhenDatabaseVersion isVersionsSkipped(SkipWhenDatabaseVersion[] skipWhenDatabaseVersions) {
        for (SkipWhenDatabaseVersion skipWhenDatabaseVersion : skipWhenDatabaseVersions) {
            if (!this.isSkippedByDatabaseVersion(skipWhenDatabaseVersion)) continue;
            return skipWhenDatabaseVersion;
        }
        return null;
    }

    private boolean isSkippedByDatabaseVersion(SkipWhenDatabaseVersion skipWhenDatabaseVersion) {
        EqualityCheck equalityCheck = skipWhenDatabaseVersion.check();
        int major = skipWhenDatabaseVersion.major();
        int minor = skipWhenDatabaseVersion.minor();
        int patch = skipWhenDatabaseVersion.patch();
        Reflections reflections = new Reflections("io.debezium", new Scanner[0]);
        Set resolvers = reflections.getSubTypesOf(DatabaseVersionResolver.class);
        Class resolverClass = resolvers.stream().findFirst().orElse(null);
        if (resolverClass != null) {
            try {
                DatabaseVersionResolver resolver = (DatabaseVersionResolver)resolverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                DatabaseVersionResolver.DatabaseVersion dbVersion = resolver.getVersion();
                if (dbVersion != null) {
                    switch (equalityCheck) {
                        case LESS_THAN: {
                            return dbVersion.isLessThan(major, minor, patch);
                        }
                        case LESS_THAN_OR_EQUAL: {
                            return dbVersion.isLessThanEqualTo(major, minor, patch);
                        }
                        case EQUAL: {
                            return dbVersion.isEqualTo(major, minor, patch);
                        }
                        case GREATER_THAN_OR_EQUAL: {
                            return dbVersion.isGreaterThanEqualTo(major, minor, patch);
                        }
                        case GREATER_THAN: {
                            return dbVersion.isGreaterThan(major, minor, patch);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

