/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.DebeziumException;
import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import io.debezium.connector.common.RelationalBaseSourceConnector;
import io.debezium.connector.mysql.Module;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlConnectorTask;
import io.debezium.connector.mysql.strategy.AbstractConnectorConnection;
import io.debezium.connector.mysql.strategy.ConnectorAdapter;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlConnector
extends RelationalBaseSourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlConnector.class);
    @Immutable
    private Map<String, String> properties;

    public String version() {
        return Module.version();
    }

    public void start(Map<String, String> props) {
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(props));
    }

    public Class<? extends Task> taskClass() {
        return MySqlConnectorTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (maxTasks > 1) {
            throw new IllegalArgumentException("Only a single connector task may be started");
        }
        return Collections.singletonList(this.properties);
    }

    public void stop() {
    }

    public ConfigDef config() {
        return MySqlConnectorConfig.configDef();
    }

    protected void validateConnection(Map<String, ConfigValue> configValues, Configuration config) {
        ConfigValue adapterValue = configValues.get(MySqlConnectorConfig.CONNECTOR_ADAPTER.name());
        ConfigValue hostnameValue = configValues.get(RelationalDatabaseConnectorConfig.HOSTNAME.name());
        ConnectorAdapter adapter = MySqlConnector.adapter(config);
        if (adapter == null) {
            LOGGER.error("Failed to resolve connection adapter.");
            adapterValue.addErrorMessage("Failed to resolve the connector's connection adapter.");
            return;
        }
        try (AbstractConnectorConnection connection = adapter.createConnection(config);){
            try {
                connection.connect();
                connection.execute(new String[]{"SELECT version()"});
                LOGGER.info("Successfully tested connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connection.connectionConfig().username());
            }
            catch (SQLException e) {
                LOGGER.error("Failed testing connection for {} with user '{}'", new Object[]{connection.connectionString(), connection.connectionConfig().username(), e});
                hostnameValue.addErrorMessage("Unable to connect: " + e.getMessage());
            }
        }
        catch (SQLException e) {
            LOGGER.error("Unexpected error shutting down the database connection", (Throwable)e);
        }
    }

    protected Map<String, ConfigValue> validateAllFields(Configuration config) {
        return config.validate(MySqlConnectorConfig.ALL_FIELDS);
    }

    private static ConnectorAdapter adapter(Configuration config) {
        return new MySqlConnectorConfig(config).getConnectorAdapter();
    }

    public List<TableId> getMatchingCollections(Configuration config) {
        ArrayList arrayList;
        block9: {
            MySqlConnectorConfig connectorConfig = new MySqlConnectorConfig(config);
            AbstractConnectorConnection connection = MySqlConnector.adapter(config).createConnection(config);
            try {
                ArrayList tables = new ArrayList();
                List<String> databaseNames = connection.availableDatabases();
                for (String databaseName : databaseNames) {
                    if (!connectorConfig.getTableFilters().databaseFilter().test(databaseName)) continue;
                    tables.addAll(connection.readTableNames(databaseName, null, null, new String[]{"TABLE"}).stream().filter(tableId -> connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)).collect(Collectors.toList()));
                }
                arrayList = tables;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DebeziumException((Throwable)e);
                }
            }
            connection.close();
        }
        return arrayList;
    }
}

