/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.AbstractMySqlFieldReader;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;

public class MariaDbProtocolFieldReader
extends AbstractMySqlFieldReader {
    public MariaDbProtocolFieldReader(MySqlConnectorConfig connectorConfig) {
        super(connectorConfig);
    }

    @Override
    protected Object readTimeField(ResultSet rs, int columnIndex) throws SQLException {
        String value = rs.getString(columnIndex);
        if (value == null) {
            return null;
        }
        return MySqlValueConverters.stringToDuration(value);
    }

    @Override
    protected Object readDateField(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        String value = rs.getString(columnIndex);
        if (value == null) {
            return value;
        }
        return MySqlValueConverters.stringToLocalDate(value, column, table);
    }

    @Override
    protected Object readTimestampField(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        String value = rs.getString(columnIndex);
        if (value == null) {
            return value;
        }
        return MySqlValueConverters.containsZeroValuesInDatePart(value, column, table) ? null : rs.getTimestamp(columnIndex, Calendar.getInstance());
    }
}

