/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.snapshot.mode;

import io.debezium.DebeziumException;
import io.debezium.bean.StandardBeanNames;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.snapshot.mode.BeanAwareSnapshotter;
import io.debezium.connector.mysql.strategy.AbstractConnectorConnection;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.spi.snapshot.Snapshotter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeverSnapshotter
extends BeanAwareSnapshotter
implements Snapshotter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NeverSnapshotter.class);

    public String name() {
        return MySqlConnectorConfig.SnapshotMode.NEVER.getValue();
    }

    public void configure(Map<String, ?> properties) {
    }

    public void validate(boolean offsetContextExists, boolean isSnapshotInProgress) {
        String earliestBinlogFilename;
        MySqlConnectorConfig config = (MySqlConnectorConfig)((Object)this.beanRegistry.lookupByName("ConnectorConfig", MySqlConnectorConfig.class));
        AbstractConnectorConnection connection = (AbstractConnectorConnection)((Object)this.beanRegistry.lookupByName(StandardBeanNames.JDBC_CONNECTION, this.getConnectionClass(config)));
        Offsets mySqloffsets = (Offsets)this.beanRegistry.lookupByName(StandardBeanNames.OFFSETS, Offsets.class);
        MySqlOffsetContext offset = (MySqlOffsetContext)mySqloffsets.getTheOnlyOffset();
        if (offsetContextExists) {
            if (isSnapshotInProgress) {
                throw new DebeziumException("The connector previously stopped while taking a snapshot, but now the connector is configured to never allow snapshots. Reconfigure the connector to use snapshots initially or when needed.");
            }
            if (!connection.isBinlogPositionAvailable(config, offset.gtidSet(), offset.getSource().binlogFilename())) {
                throw new DebeziumException("The connector is trying to read binlog starting at " + offset.getSource() + ", but this is no longer available on the server. Reconfigure the connector to use a snapshot when needed.");
            }
        }
        if ((earliestBinlogFilename = connection.earliestBinlogFilename()) == null) {
            LOGGER.warn("No binlog appears to be available. Ensure that the MySQL row-level binlog is enabled.");
        } else if (!earliestBinlogFilename.endsWith("00001")) {
            LOGGER.warn("It is possible the server has purged some binlogs. If this is the case, then using snapshot mode may be required.");
        }
    }

    public boolean shouldSnapshot() {
        return false;
    }

    public boolean shouldStream() {
        return true;
    }

    public boolean shouldSnapshotSchema() {
        return false;
    }

    public boolean shouldSnapshotOnSchemaError() {
        return false;
    }

    public boolean shouldSnapshotOnDataError() {
        return false;
    }
}

