/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDefaultValueConverter;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.DefaultValueConverter;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.ddl.DdlParserListener;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.text.MultipleParsingExceptions;
import io.debezium.text.ParsingException;
import io.debezium.util.Collect;
import io.debezium.util.Strings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MySqlDatabaseSchema
extends HistorizedRelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlDatabaseSchema.class);
    private final Set<String> ignoredQueryStatements = Collect.unmodifiableSet((Object[])new String[]{"BEGIN", "END", "FLUSH PRIVILEGES"});
    private final DdlParser ddlParser;
    private final RelationalTableFilters filters;
    private final DdlChanges ddlChanges;
    private final Map<Long, TableId> tableIdsByTableNumber = new ConcurrentHashMap<Long, TableId>();
    private final Map<Long, TableId> excludeTableIdsByTableNumber = new ConcurrentHashMap<Long, TableId>();
    private boolean storageInitializationExecuted = false;
    private final MySqlConnectorConfig connectorConfig;

    public MySqlDatabaseSchema(MySqlConnectorConfig connectorConfig, MySqlValueConverters valueConverter, TopicNamingStrategy<TableId> topicNamingStrategy, SchemaNameAdjuster schemaNameAdjuster, boolean tableIdCaseInsensitive) {
        super((HistorizedRelationalDatabaseConnectorConfig)connectorConfig, topicNamingStrategy, connectorConfig.getTableFilters().dataCollectionFilter(), connectorConfig.getColumnFilter(), new TableSchemaBuilder((ValueConverterProvider)valueConverter, (DefaultValueConverter)new MySqlDefaultValueConverter(valueConverter), schemaNameAdjuster, connectorConfig.customConverterRegistry(), connectorConfig.getSourceInfoStructMaker().schema(), connectorConfig.getFieldNamer(), false, connectorConfig.getEventConvertingFailureHandlingMode()), tableIdCaseInsensitive, connectorConfig.getKeyMapper());
        this.ddlParser = new MySqlAntlrDdlParser(true, false, connectorConfig.isSchemaCommentsHistoryEnabled(), valueConverter, this.getTableFilter());
        this.ddlChanges = this.ddlParser.getDdlChanges();
        this.connectorConfig = connectorConfig;
        this.filters = connectorConfig.getTableFilters();
    }

    public String[] capturedTablesAsStringArray() {
        Set tables = this.tableIds();
        String[] ret = new String[tables.size()];
        int i = 0;
        for (TableId table : tables) {
            ret[i++] = table.toString();
        }
        return ret;
    }

    public void setSystemVariables(Map<String, String> variables) {
        variables.forEach((varName, value) -> this.ddlParser.systemVariables().setVariable((SystemVariables.Scope)MySqlSystemVariables.MySqlScope.SESSION, varName, value));
    }

    public SystemVariables systemVariables() {
        return this.ddlParser.systemVariables();
    }

    protected void appendDropTableStatement(StringBuilder sb, TableId tableId) {
        sb.append("DROP TABLE ").append(tableId).append(" IF EXISTS;").append(System.lineSeparator());
    }

    protected void appendCreateTableStatement(StringBuilder sb, Table table) {
        sb.append("CREATE TABLE ").append(table.id()).append(';').append(System.lineSeparator());
    }

    protected void refreshSchemas() {
        this.clearSchemas();
        this.tableIds().forEach(id -> {
            Table table = this.tableFor((TableId)id);
            this.buildAndRegisterSchema(table);
        });
    }

    public boolean isGlobalSetVariableStatement(String ddl, String databaseName) {
        return (databaseName == null || databaseName.isEmpty()) && ddl != null && ddl.toUpperCase().startsWith("SET ");
    }

    public void applySchemaChange(SchemaChangeEvent schemaChange) {
        block7: {
            block6: {
                switch (schemaChange.getType()) {
                    case CREATE: 
                    case ALTER: {
                        schemaChange.getTableChanges().forEach(x -> this.buildAndRegisterSchema(x.getTable()));
                        break;
                    }
                    case DROP: {
                        schemaChange.getTableChanges().forEach(x -> this.removeSchema(x.getId()));
                        break;
                    }
                }
                if (!this.storeOnlyCapturedTables() || this.isGlobalSetVariableStatement(schemaChange.getDdl(), schemaChange.getDatabase())) break block6;
                if (!schemaChange.getTables().stream().map(Table::id).anyMatch(arg_0 -> ((Tables.TableFilter)this.filters.dataCollectionFilter()).isIncluded(arg_0))) break block7;
            }
            LOGGER.debug("Recorded DDL statements for database '{}': {}", (Object)schemaChange.getDatabase(), (Object)schemaChange.getDdl());
            this.record(schemaChange, schemaChange.getTableChanges());
        }
    }

    public List<SchemaChangeEvent> parseSnapshotDdl(MySqlPartition partition, String ddlStatements, String databaseName, MySqlOffsetContext offset, Instant sourceTime) {
        LOGGER.debug("Processing snapshot DDL '{}' for database '{}'", (Object)ddlStatements, (Object)databaseName);
        return this.parseDdl(partition, ddlStatements, databaseName, offset, sourceTime, true);
    }

    public List<SchemaChangeEvent> parseStreamingDdl(MySqlPartition partition, String ddlStatements, String databaseName, MySqlOffsetContext offset, Instant sourceTime) {
        LOGGER.debug("Processing streaming DDL '{}' for database '{}'", (Object)ddlStatements, (Object)databaseName);
        return this.parseDdl(partition, ddlStatements, databaseName, offset, sourceTime, false);
    }

    private List<SchemaChangeEvent> parseDdl(MySqlPartition partition, String ddlStatements, String databaseName, MySqlOffsetContext offset, Instant sourceTime, boolean snapshot) {
        ArrayList<SchemaChangeEvent> schemaChangeEvents = new ArrayList<SchemaChangeEvent>(3);
        if (this.ignoredQueryStatements.contains(ddlStatements)) {
            return schemaChangeEvents;
        }
        try {
            this.ddlChanges.reset();
            this.ddlParser.setCurrentSchema(databaseName);
            this.ddlParser.parse(ddlStatements, this.tables());
        }
        catch (MultipleParsingExceptions | ParsingException e) {
            if (this.skipUnparseableDdlStatements()) {
                LOGGER.warn("Ignoring unparseable DDL statement '{}'", (Object)ddlStatements, (Object)e);
            }
            throw e;
        }
        if (!this.storeOnlyCapturedTables() || this.isGlobalSetVariableStatement(ddlStatements, databaseName) || this.ddlChanges.anyMatch(this.filters)) {
            if (!this.ddlChanges.isEmpty()) {
                this.ddlChanges.getEventsByDatabase((dbName, events) -> {
                    String sanitizedDbName;
                    String string = sanitizedDbName = dbName == null ? "" : dbName;
                    if (this.acceptableDatabase(dbName)) {
                        HashSet tableIds = new HashSet();
                        events.forEach(event -> {
                            TableId tableId = this.getTableId((DdlParserListener.Event)event);
                            if (tableId != null) {
                                tableIds.add(tableId);
                            }
                        });
                        events.forEach(event -> {
                            TableId tableId = this.getTableId((DdlParserListener.Event)event);
                            offset.tableEvent(dbName, tableIds, sourceTime);
                            if (event instanceof DdlParserListener.TableCreatedEvent) {
                                this.emitChangeEvent(partition, offset, schemaChangeEvents, sanitizedDbName, (DdlParserListener.Event)event, tableId, SchemaChangeEvent.SchemaChangeEventType.CREATE, snapshot);
                            } else if (event instanceof DdlParserListener.TableAlteredEvent || event instanceof DdlParserListener.TableIndexCreatedEvent || event instanceof DdlParserListener.TableIndexDroppedEvent) {
                                this.emitChangeEvent(partition, offset, schemaChangeEvents, sanitizedDbName, (DdlParserListener.Event)event, tableId, SchemaChangeEvent.SchemaChangeEventType.ALTER, snapshot);
                            } else if (event instanceof DdlParserListener.TableDroppedEvent) {
                                this.emitChangeEvent(partition, offset, schemaChangeEvents, sanitizedDbName, (DdlParserListener.Event)event, tableId, SchemaChangeEvent.SchemaChangeEventType.DROP, snapshot);
                            } else if (event instanceof DdlParserListener.TableTruncatedEvent) {
                                this.emitChangeEvent(partition, offset, schemaChangeEvents, sanitizedDbName, (DdlParserListener.Event)event, tableId, SchemaChangeEvent.SchemaChangeEventType.TRUNCATE, snapshot);
                            } else if (event instanceof DdlParserListener.SetVariableEvent) {
                                DdlParserListener.SetVariableEvent varEvent = (DdlParserListener.SetVariableEvent)event;
                                if (varEvent.order() == 0) {
                                    this.emitChangeEvent(partition, offset, schemaChangeEvents, sanitizedDbName, (DdlParserListener.Event)event, tableId, SchemaChangeEvent.SchemaChangeEventType.DATABASE, snapshot);
                                }
                            } else {
                                this.emitChangeEvent(partition, offset, schemaChangeEvents, sanitizedDbName, (DdlParserListener.Event)event, tableId, SchemaChangeEvent.SchemaChangeEventType.DATABASE, snapshot);
                            }
                        });
                    }
                });
            } else {
                offset.databaseEvent(databaseName, sourceTime);
                schemaChangeEvents.add(SchemaChangeEvent.ofDatabase((Partition)partition, (OffsetContext)offset, (String)databaseName, (String)ddlStatements, (boolean)snapshot));
            }
        } else {
            LOGGER.debug("Changes for DDL '{}' were filtered and not recorded in database schema history", (Object)ddlStatements);
        }
        return schemaChangeEvents;
    }

    private void emitChangeEvent(MySqlPartition partition, MySqlOffsetContext offset, List<SchemaChangeEvent> schemaChangeEvents, String sanitizedDbName, DdlParserListener.Event event, TableId tableId, SchemaChangeEvent.SchemaChangeEventType type, boolean snapshot) {
        SchemaChangeEvent schemaChangeEvent;
        if (type.equals((Object)SchemaChangeEvent.SchemaChangeEventType.ALTER) && event instanceof DdlParserListener.TableAlteredEvent && ((DdlParserListener.TableAlteredEvent)event).previousTableId() != null) {
            schemaChangeEvent = SchemaChangeEvent.ofRename((Partition)partition, (OffsetContext)offset, (String)sanitizedDbName, null, (String)event.statement(), (Table)(tableId != null ? this.tables().forTable(tableId) : null), (TableId)((DdlParserListener.TableAlteredEvent)event).previousTableId());
        } else {
            Table table = this.getTable(tableId, type);
            schemaChangeEvent = SchemaChangeEvent.of((SchemaChangeEvent.SchemaChangeEventType)type, (Partition)partition, (OffsetContext)offset, (String)sanitizedDbName, null, (String)event.statement(), (Table)table, (boolean)snapshot);
        }
        schemaChangeEvents.add(schemaChangeEvent);
    }

    private Table getTable(TableId tableId, SchemaChangeEvent.SchemaChangeEventType type) {
        if (tableId == null) {
            return null;
        }
        if (SchemaChangeEvent.SchemaChangeEventType.DROP == type) {
            return Table.editor().tableId(tableId).create();
        }
        return this.tables().forTable(tableId);
    }

    private boolean acceptableDatabase(String databaseName) {
        return !this.storeOnlyCapturedTables() || this.filters.databaseFilter().test(databaseName) || databaseName == null || databaseName.isEmpty();
    }

    private TableId getTableId(DdlParserListener.Event event) {
        if (event instanceof DdlParserListener.TableEvent) {
            return ((DdlParserListener.TableEvent)event).tableId();
        }
        if (event instanceof DdlParserListener.TableIndexEvent) {
            return ((DdlParserListener.TableIndexEvent)event).tableId();
        }
        return null;
    }

    protected DdlParser getDdlParser() {
        return this.ddlParser;
    }

    public boolean historyExists() {
        return this.schemaHistory.exists();
    }

    public boolean assignTableNumber(long tableNumber, TableId id) {
        TableSchema tableSchema = this.schemaFor(id);
        if (tableSchema == null) {
            this.excludeTableIdsByTableNumber.put(tableNumber, id);
            return false;
        }
        this.tableIdsByTableNumber.put(tableNumber, id);
        return true;
    }

    public TableId getTableId(long tableNumber) {
        return this.tableIdsByTableNumber.get(tableNumber);
    }

    public TableId getExcludeTableId(long tableNumber) {
        return this.excludeTableIdsByTableNumber.get(tableNumber);
    }

    public void clearTableMappings() {
        LOGGER.debug("Clearing table number mappings");
        this.tableIdsByTableNumber.clear();
        this.excludeTableIdsByTableNumber.clear();
    }

    public void initializeStorage() {
        super.initializeStorage();
        this.storageInitializationExecuted = true;
    }

    public boolean isStorageInitializationExecuted() {
        return this.storageInitializationExecuted;
    }

    public boolean skipSchemaChangeEvent(SchemaChangeEvent event) {
        if (this.storeOnlyCapturedDatabases() && !Strings.isNullOrEmpty((String)event.getDatabase()) && !this.connectorConfig.getTableFilters().databaseFilter().test(event.getDatabase())) {
            LOGGER.debug("Skipping schema event as it belongs to a non-captured database: '{}'", (Object)event);
            return true;
        }
        return false;
    }
}

