/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.MySqlAntlrDdlParser;
import io.debezium.doc.FixFor;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ValueConverter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjuster;
import org.apache.kafka.connect.data.Field;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class MySqlValueConvertersTest {
    private static final TemporalAdjuster ADJUSTER = MySqlValueConverters::adjustTemporal;
    private static final byte[] INVALID_JSON = new byte[]{2, 1, 0, 91, 0, 0, 7, 0, 2, 0, 84, 0, 18, 0, 4, 0, 22, 0, 6, 0, 12, 28, 0, 0, 47, 0, 116, 121, 112, 101};

    @Test
    public void shouldAdjustLocalDateWithTwoDigitYears() {
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(0))).isEqualTo((Object)this.localDateWithYear(2000));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(1))).isEqualTo((Object)this.localDateWithYear(2001));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(10))).isEqualTo((Object)this.localDateWithYear(2010));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(69))).isEqualTo((Object)this.localDateWithYear(2069));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(70))).isEqualTo((Object)this.localDateWithYear(1970));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(71))).isEqualTo((Object)this.localDateWithYear(1971));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(99))).isEqualTo((Object)this.localDateWithYear(1999));
    }

    @Test
    public void shouldAdjustLocalDateTimeWithTwoDigitYears() {
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(0))).isEqualTo((Object)this.localDateTimeWithYear(2000));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(1))).isEqualTo((Object)this.localDateTimeWithYear(2001));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(10))).isEqualTo((Object)this.localDateTimeWithYear(2010));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(69))).isEqualTo((Object)this.localDateTimeWithYear(2069));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(70))).isEqualTo((Object)this.localDateTimeWithYear(1970));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(71))).isEqualTo((Object)this.localDateTimeWithYear(1971));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(99))).isEqualTo((Object)this.localDateTimeWithYear(1999));
    }

    @Test
    public void shouldNotAdjustLocalDateWithThreeDigitYears() {
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(-1))).isEqualTo((Object)this.localDateWithYear(-1));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateWithYear(100))).isEqualTo((Object)this.localDateWithYear(100));
    }

    @Test
    public void shouldNotAdjustLocalDateTimeWithThreeDigitYears() {
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(-1))).isEqualTo((Object)this.localDateTimeWithYear(-1));
        Assertions.assertThat((Object)ADJUSTER.adjustInto(this.localDateTimeWithYear(100))).isEqualTo((Object)this.localDateTimeWithYear(100));
    }

    @Test
    public void testJsonValues() {
        String sql = "CREATE TABLE JSON_TABLE (    A JSON,    B JSON NOT NULL);";
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.DOUBLE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.LONG, CommonConnectorConfig.BinaryHandlingMode.BYTES);
        MySqlAntlrDdlParser parser = new MySqlAntlrDdlParser();
        Tables tables = new Tables();
        parser.parse(sql, tables);
        Table table = tables.forTable(new TableId(null, null, "JSON_TABLE"));
        Column colA = table.columnWithName("A");
        Field fieldA = new Field(colA.name(), -1, converters.schemaBuilder(colA).optional().build());
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)"{}")).isEqualTo((Object)"{}");
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)"[]")).isEqualTo((Object)"[]");
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)new byte[0])).isNull();
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert(null)).isNull();
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)"{ \"key1\": \"val1\", \"key2\": {\"key3\":\"val3\"} }")).isEqualTo((Object)"{ \"key1\": \"val1\", \"key2\": {\"key3\":\"val3\"} }");
        Column colB = table.columnWithName("B");
        Field fieldB = new Field(colB.name(), -1, converters.schemaBuilder(colB).build());
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)"{}")).isEqualTo((Object)"{}");
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)"[]")).isEqualTo((Object)"[]");
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)new byte[0])).isEqualTo((Object)"{}");
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert(null)).isEqualTo((Object)"{}");
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)"{ \"key1\": \"val1\", \"key2\": {\"key3\":\"val3\"} }")).isEqualTo((Object)"{ \"key1\": \"val1\", \"key2\": {\"key3\":\"val3\"} }");
    }

    @Test
    @FixFor(value={"DBZ-2563", "DBZ-7143"})
    public void testSkipInvalidJsonValues() {
        LogInterceptor logInterceptor = new LogInterceptor(MySqlValueConverters.class);
        String sql = "CREATE TABLE JSON_TABLE (    A JSON,    B JSON NOT NULL);";
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.DOUBLE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.LONG, CommonConnectorConfig.BinaryHandlingMode.BYTES, x -> x, null, CommonConnectorConfig.EventConvertingFailureHandlingMode.WARN);
        MySqlAntlrDdlParser parser = new MySqlAntlrDdlParser();
        Tables tables = new Tables();
        parser.parse(sql, tables);
        Table table = tables.forTable(new TableId(null, null, "JSON_TABLE"));
        Column colA = table.columnWithName("A");
        Field fieldA = new Field(colA.name(), -1, converters.schemaBuilder(colA).optional().build());
        Assertions.assertThat((Object)converters.converter(colA, fieldA).convert((Object)INVALID_JSON)).isEqualTo(null);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)logInterceptor.containsWarnMessage("Failed to parse and read a JSON value on 'A JSON DEFAULT VALUE NULL'")).describedAs("Expected null value of nullable column when parsing invalid json with WARN mode", new Object[0])).isTrue();
        Column colB = table.columnWithName("B");
        Field fieldB = new Field(colB.name(), -1, converters.schemaBuilder(colB).build());
        Assertions.assertThat((Object)converters.converter(colB, fieldB).convert((Object)INVALID_JSON)).isEqualTo((Object)"{}");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)logInterceptor.containsWarnMessage("Failed to parse and read a JSON value on 'B JSON NOT NULL'")).describedAs("Expected '{}' value of non-null column when parsing invalid json with WARN mode", new Object[0])).isTrue();
    }

    @Test(expected=DebeziumException.class)
    @FixFor(value={"DBZ-2563", "DBZ-7143"})
    public void testErrorOnInvalidJsonValues() {
        String sql = "CREATE TABLE JSON_TABLE (    A JSON,    B JSON NOT NULL);";
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.DOUBLE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.LONG, CommonConnectorConfig.BinaryHandlingMode.BYTES, x -> x, null, CommonConnectorConfig.EventConvertingFailureHandlingMode.FAIL);
        MySqlAntlrDdlParser parser = new MySqlAntlrDdlParser();
        Tables tables = new Tables();
        parser.parse(sql, tables);
        Table table = tables.forTable(new TableId(null, null, "JSON_TABLE"));
        Column colA = table.columnWithName("A");
        Field fieldA = new Field(colA.name(), -1, converters.schemaBuilder(colA).optional().build());
        converters.converter(colA, fieldA).convert((Object)INVALID_JSON);
    }

    @Test
    @FixFor(value={"DBC-3371"})
    public void testFallbackDecimalValueScale() {
        int scale = 42;
        String sql = "CREATE TABLE DECIMAL_TABLE (A DECIMAL(3, " + scale + ") NOT NULL);";
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.PRECISE, TemporalPrecisionMode.CONNECT, JdbcValueConverters.BigIntUnsignedMode.LONG, CommonConnectorConfig.BinaryHandlingMode.BYTES, x -> x, null);
        MySqlAntlrDdlParser parser = new MySqlAntlrDdlParser();
        Tables tables = new Tables();
        parser.parse(sql, tables);
        Table table = tables.forTable(new TableId(null, null, "DECIMAL_TABLE"));
        Column colA = table.columnWithName("A");
        Field fieldA = new Field(colA.name(), -1, converters.schemaBuilder(colA).build());
        Assert.assertEquals((Object)BigDecimal.ZERO.setScale(scale), (Object)converters.converter(colA, fieldA).convert(null));
    }

    @Test
    @FixFor(value={"DBZ-5996"})
    public void testZonedDateTimeWithMicrosecondPrecision() {
        String zonedDateTimeTable = "ZONED_DATE_TIME_TABLE";
        String sql = "CREATE TABLE " + zonedDateTimeTable + " (A TIMESTAMP(6) NOT NULL, B TIMESTAMP(3) NOT NULL, C TIMESTAMP(5) NOT NULL, D TIMESTAMP NOT NULL);";
        MySqlValueConverters converters = new MySqlValueConverters(JdbcValueConverters.DecimalMode.PRECISE, TemporalPrecisionMode.ADAPTIVE_TIME_MICROSECONDS, JdbcValueConverters.BigIntUnsignedMode.LONG, CommonConnectorConfig.BinaryHandlingMode.BYTES, x -> x, null);
        MySqlAntlrDdlParser parser = new MySqlAntlrDdlParser();
        Tables tables = new Tables();
        parser.parse(sql, tables);
        Table table = tables.forTable(new TableId(null, null, zonedDateTimeTable));
        Column colA = table.columnWithName("A");
        Field fieldA = new Field(colA.name(), -1, converters.schemaBuilder(colA).build());
        ValueConverter colAConverter = converters.converter(colA, fieldA);
        Assert.assertEquals((Object)"2023-01-11T00:34:10.000000Z", (Object)colAConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.000000Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.123456Z", (Object)colAConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.123456Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.123000Z", (Object)colAConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.123Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.000000Z", (Object)colAConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10Z")));
        Column colB = table.columnWithName("B");
        Field fieldB = new Field(colB.name(), -1, converters.schemaBuilder(colB).build());
        ValueConverter colBConverter = converters.converter(colB, fieldB);
        Assert.assertEquals((Object)"2023-01-11T00:34:10.000Z", (Object)colBConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.000000Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.123Z", (Object)colBConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.1234Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.123Z", (Object)colBConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.123Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.010Z", (Object)colBConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.01Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.000Z", (Object)colBConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10Z")));
        Column colC = table.columnWithName("C");
        Field fieldC = new Field(colC.name(), -1, converters.schemaBuilder(colC).build());
        ValueConverter colCConverter = converters.converter(colC, fieldC);
        Assert.assertEquals((Object)"2023-01-11T00:34:10.00000Z", (Object)colCConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.000000Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.12345Z", (Object)colCConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.12345Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.12300Z", (Object)colCConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.123Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.12345Z", (Object)colCConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.123456Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.00000Z", (Object)colCConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10Z")));
        Column colD = table.columnWithName("D");
        Field fieldD = new Field(colD.name(), -1, converters.schemaBuilder(colD).build());
        ValueConverter colDConverter = converters.converter(colD, fieldD);
        Assert.assertEquals((Object)"2023-01-11T00:34:10Z", (Object)colDConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.000000Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.12345Z", (Object)colDConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.12345Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.123Z", (Object)colDConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.123Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10.123456Z", (Object)colDConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10.123456Z")));
        Assert.assertEquals((Object)"2023-01-11T00:34:10Z", (Object)colDConverter.convert((Object)ZonedDateTime.parse("2023-01-11T00:34:10Z")));
    }

    protected LocalDate localDateWithYear(int year) {
        return LocalDate.of(year, Month.APRIL, 4);
    }

    protected LocalDateTime localDateTimeWithYear(int year) {
        return LocalDateTime.of(year, Month.APRIL, 4, 0, 0, 0);
    }
}

