/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.junit.SkipTestDependingOnSslModeRule;
import io.debezium.connector.mysql.junit.SkipWhenSslModeIsNot;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.embedded.async.AbstractAsyncEngineConnectorTest;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.testing.testcontainers.util.ContainerImageVersions;
import io.debezium.util.Testing;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.apache.kafka.connect.data.Struct;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;

@SkipWhenSslModeIsNot(value=MySqlConnectorConfig.SecureConnectionMode.DISABLED, reason="Only running with ssl disabled mode")
public class MySqlParserIT
extends AbstractAsyncEngineConnectorTest {
    @Rule
    public TestRule skipTestRule = new SkipTestDependingOnSslModeRule();
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlParserIT.class);
    private static final String DB_NAME = "inventory";
    private MySQLContainer<?> mySQLContainer;
    private Configuration config;
    private String oldContainerPort;

    @Before
    public void beforeEach() {
        String mysqlImage = ContainerImageVersions.getStableImage((String)"quay.io/debezium/example-mysql");
        DockerImageName mysqlDockerImageName = DockerImageName.parse((String)mysqlImage).asCompatibleSubstituteFor("mysql");
        this.mySQLContainer = (MySQLContainer)((MySQLContainer)((MySQLContainer)((MySQLContainer)new MySQLContainer(mysqlDockerImageName).withDatabaseName("mysql").withUsername("mysqluser").withPassword("mysql").withClasspathResourceMapping("/docker/conf/mysql.cnf", "/etc/mysql/conf.d/", BindMode.READ_ONLY)).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER))).withExposedPorts(new Integer[]{3306})).withNetworkAliases(new String[]{"mysql"});
        this.mySQLContainer.start();
        this.oldContainerPort = System.getProperty("database.port", "3306");
        System.setProperty("database.port", String.valueOf(this.mySQLContainer.getMappedPort(3306)));
        this.initializeConnectorTestFramework();
    }

    @After
    public void afterEach() {
        this.stopConnector();
        this.mySQLContainer.stop();
        System.setProperty("database.port", this.oldContainerPort);
    }

    public Configuration.Builder defaultConfig() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.create().with(CommonConnectorConfig.TOPIC_PREFIX, "myServer1")).with(MySqlConnectorConfig.HOSTNAME, System.getProperty("database.hostname", "localhost"))).with("database." + JdbcConfiguration.PORT, (Object)this.mySQLContainer.getMappedPort(3306))).with(MySqlConnectorConfig.USER, "debezium")).with(MySqlConnectorConfig.PASSWORD, "dbz")).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.SSL_MODE, (EnumeratedValue)MySqlConnectorConfig.SecureConnectionMode.DISABLED)).with(MySqlConnectorConfig.SERVER_ID, 18765)).with(MySqlConnectorConfig.POLL_INTERVAL_MS, 10)).with(MySqlConnectorConfig.SCHEMA_HISTORY, "io.debezium.relational.history.MemorySchemaHistory")).with(MySqlConnectorConfig.DATABASE_INCLUDE_LIST, DB_NAME)).with(MySqlConnectorConfig.BUFFER_SIZE_FOR_BINLOG_READER, 10000);
    }

    @Test
    public void parseTableWithVisibleColumns() throws SQLException, InterruptedException {
        this.config = this.defaultConfig().build();
        Testing.Print.enable();
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(DB_NAME, this.mySQLContainer.getUsername(), this.mySQLContainer.getPassword());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"SELECT VERSION();"});
            connection.execute(new String[]{"CREATE TABLE VISIBLE_COLUMN_TABLE (    ID BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY,    NAME VARCHAR(100) NOT NULL,    WORK_ID BIGINT VISIBLE);"});
            connection.execute(new String[]{"INSERT INTO VISIBLE_COLUMN_TABLE VALUES (1001,'Larry',113);"});
        }
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(30);
        boolean statementFound = records.ddlRecordsForDatabase(DB_NAME).stream().anyMatch(s -> ((Struct)s.value()).getString("ddl").equals("CREATE TABLE `VISIBLE_COLUMN_TABLE` (\n  `ID` bigint NOT NULL AUTO_INCREMENT,\n  `NAME` varchar(100) NOT NULL,\n  `WORK_ID` bigint DEFAULT NULL,\n  PRIMARY KEY (`ID`)\n) ENGINE=InnoDB AUTO_INCREMENT=1002 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci"));
        Assertions.assertThat((boolean)statementFound).isTrue();
    }

    @Test
    public void parseTableWithInVisibleColumns() throws SQLException, InterruptedException {
        this.config = this.defaultConfig().build();
        Testing.Print.enable();
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(DB_NAME, this.mySQLContainer.getUsername(), this.mySQLContainer.getPassword());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"SELECT VERSION();"});
            connection.execute(new String[]{"CREATE TABLE INVISIBLE_COLUMN_TABLE ( ID BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY, NAME VARCHAR(100) NOT NULL, WORK_ID BIGINT INVISIBLE);"});
            connection.execute(new String[]{"INSERT INTO INVISIBLE_COLUMN_TABLE VALUES (1002,'Jack');"});
        }
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(30);
        boolean statementFound = records.ddlRecordsForDatabase(DB_NAME).stream().anyMatch(s -> ((Struct)s.value()).getString("ddl").equals("CREATE TABLE `INVISIBLE_COLUMN_TABLE` (\n  `ID` bigint NOT NULL AUTO_INCREMENT,\n  `NAME` varchar(100) NOT NULL,\n  `WORK_ID` bigint DEFAULT NULL /*!80023 INVISIBLE */,\n  PRIMARY KEY (`ID`)\n) ENGINE=InnoDB AUTO_INCREMENT=1003 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci"));
        Assertions.assertThat((boolean)statementFound).isTrue();
    }

    @Test
    public void parseTableCreatedWithTableStatement() throws SQLException, InterruptedException {
        this.config = this.defaultConfig().build();
        Testing.Print.enable();
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(DB_NAME, this.mySQLContainer.getUsername(), this.mySQLContainer.getPassword());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"CREATE TABLE table1 (ID BIGINT NOT NULL AUTO_INCREMENT PRIMARY KEY,NAME VARCHAR(100) NOT NULL);"});
            connection.execute(new String[]{"CREATE TABLE table2 (WORK_ID BIGINT) TABLE table1;"});
            connection.execute(new String[]{"INSERT INTO table2 VALUES (113, 1001,'Larry');"});
        }
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(30);
        boolean statementFound = records.ddlRecordsForDatabase(DB_NAME).stream().anyMatch(s -> ((Struct)s.value()).getString("ddl").equals("CREATE TABLE `table2` (\n  `WORK_ID` bigint DEFAULT NULL,\n  `ID` bigint NOT NULL DEFAULT '0',\n  `NAME` varchar(100) NOT NULL\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci"));
        Assertions.assertThat((boolean)statementFound).isTrue();
    }
}

