/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.strategy.mysql.MySqlGtidSet;
import io.debezium.util.Collect;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class GtidSetTest {
    private static final String UUID1 = "24bc7850-2c16-11e6-a073-0242ac110002";
    private MySqlGtidSet gtids;

    @Test
    public void shouldCreateSetWithSingleInterval() {
        this.gtids = new MySqlGtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191");
        this.asertIntervalCount(UUID1, 1);
        this.asertIntervalExists(UUID1, 1, 191);
        this.asertFirstInterval(UUID1, 1, 191);
        this.asertLastInterval(UUID1, 1, 191);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-191");
    }

    @Test
    public void shouldCollapseAdjacentIntervals() {
        this.gtids = new MySqlGtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191:192-199");
        this.asertIntervalCount(UUID1, 1);
        this.asertIntervalExists(UUID1, 1, 199);
        this.asertFirstInterval(UUID1, 1, 199);
        this.asertLastInterval(UUID1, 1, 199);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-199");
    }

    @Test
    public void shouldNotCollapseNonAdjacentIntervals() {
        this.gtids = new MySqlGtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191:193-199");
        this.asertIntervalCount(UUID1, 2);
        this.asertFirstInterval(UUID1, 1, 191);
        this.asertLastInterval(UUID1, 193, 199);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-191:193-199");
    }

    @Test
    public void shouldCreateWithMultipleIntervals() {
        this.gtids = new MySqlGtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191:193-199:1000-1033");
        this.asertIntervalCount(UUID1, 3);
        this.asertFirstInterval(UUID1, 1, 191);
        this.asertIntervalExists(UUID1, 193, 199);
        this.asertLastInterval(UUID1, 1000, 1033);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-191:193-199:1000-1033");
    }

    @Test
    public void shouldCreateWithMultipleIntervalsThatMayBeAdjacent() {
        this.gtids = new MySqlGtidSet("24bc7850-2c16-11e6-a073-0242ac110002:1-191:192-199:1000-1033:1035-1036:1038-1039");
        this.asertIntervalCount(UUID1, 4);
        this.asertFirstInterval(UUID1, 1, 199);
        this.asertIntervalExists(UUID1, 1000, 1033);
        this.asertIntervalExists(UUID1, 1035, 1036);
        this.asertLastInterval(UUID1, 1038, 1039);
        Assertions.assertThat((String)this.gtids.toString()).isEqualTo((Object)"24bc7850-2c16-11e6-a073-0242ac110002:1-199:1000-1033:1035-1036:1038-1039");
    }

    @Test
    public void shouldCorrectlyDetermineIfSimpleGtidSetIsContainedWithinAnother() {
        this.gtids = new MySqlGtidSet("7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
        Assertions.assertThat((boolean)this.gtids.isContainedWithin((GtidSet)new MySqlGtidSet("7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41"))).isTrue();
        Assertions.assertThat((boolean)this.gtids.isContainedWithin((GtidSet)new MySqlGtidSet("7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-42"))).isTrue();
        Assertions.assertThat((boolean)this.gtids.isContainedWithin((GtidSet)new MySqlGtidSet("7c1de3f2-3fd2-11e6-9cdc-42010af000bc:2-41"))).isFalse();
        Assertions.assertThat((boolean)this.gtids.isContainedWithin((GtidSet)new MySqlGtidSet("7145bf69-d1ca-11e5-a588-0242ac110004:1"))).isFalse();
    }

    @Test
    public void shouldCorrectlyDetermineIfComplexGtidSetIsContainedWithinAnother() {
        MySqlGtidSet connector = new MySqlGtidSet("036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
        MySqlGtidSet server = new MySqlGtidSet("036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3202,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
        Assertions.assertThat((boolean)connector.isContainedWithin((GtidSet)server)).isTrue();
    }

    @Test
    public void shouldCorrectlyDetermineIfComplexGtidSetWithVariousLineSeparatorsIsContainedWithinAnother() {
        MySqlGtidSet connector = new MySqlGtidSet("036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
        Arrays.stream(new String[]{"\r\n", "\n", "\r"}).forEach(arg_0 -> GtidSetTest.lambda$shouldCorrectlyDetermineIfComplexGtidSetWithVariousLineSeparatorsIsContainedWithinAnother$0((GtidSet)connector, arg_0));
    }

    @Test
    public void shouldFilterServerUuids() {
        String gtidStr = "036d85a9-64e5-11e6-9b48-42010af0000c:1-2,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41";
        List keepers = Collect.arrayListOf((Object)"036d85a9-64e5-11e6-9b48-42010af0000c", (Object[])new String[]{"7c1de3f2-3fd2-11e6-9cdc-42010af000bc", "wont-be-found"});
        MySqlGtidSet original = new MySqlGtidSet(gtidStr);
        Assertions.assertThat((Object)original.forServerWithId("036d85a9-64e5-11e6-9b48-42010af0000c")).isNotNull();
        Assertions.assertThat((Object)original.forServerWithId("7c1de3f2-3fd2-11e6-9cdc-42010af000bc")).isNotNull();
        Assertions.assertThat((Object)original.forServerWithId("7145bf69-d1ca-11e5-a588-0242ac110004")).isNotNull();
        MySqlGtidSet filtered = original.retainAll(keepers::contains);
        List actualUuids = filtered.getUUIDSets().stream().map(MySqlGtidSet.UUIDSet::getUUID).collect(Collectors.toList());
        Assertions.assertThat((boolean)keepers.containsAll(actualUuids)).isTrue();
        Assertions.assertThat((Object)filtered.forServerWithId("7145bf69-d1ca-11e5-a588-0242ac110004")).isNull();
    }

    @Test
    public void subtract() {
        String gtidStr1 = "036d85a9-64e5-11e6-9b48-42010af0000c:1-20,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200:3400-3800:3900-3990,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:5-8:12-18:25-55:60-65";
        String gtidStr2 = "036d85a9-64e5-11e6-9b48-42010af0000c:1-21,7145bf69-d1ca-11e5-a588-0242ac110004:1-3200:3400-3800:4500,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-49:62-70:80-100";
        String diff = "036d85a9-64e5-11e6-9b48-42010af0000c:21,7145bf69-d1ca-11e5-a588-0242ac110004:4500,7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-4:9-11:19-24:66-70:80-100";
        MySqlGtidSet gtidSet1 = new MySqlGtidSet(gtidStr1);
        MySqlGtidSet gtidSet2 = new MySqlGtidSet(gtidStr2);
        MySqlGtidSet gtidSetDiff = gtidSet2.subtract((GtidSet)gtidSet1);
        MySqlGtidSet expectedDiff = new MySqlGtidSet(diff);
        Assertions.assertThat((Object)gtidSetDiff).isEqualTo((Object)expectedDiff);
    }

    @Test
    public void removeInterval() {
        MySqlGtidSet.Interval interval1 = new MySqlGtidSet.Interval(3L, 7L);
        MySqlGtidSet.Interval interval2 = new MySqlGtidSet.Interval(2L, 5L);
        MySqlGtidSet.Interval interval3 = new MySqlGtidSet.Interval(4L, 5L);
        MySqlGtidSet.Interval interval4 = new MySqlGtidSet.Interval(9L, 12L);
        MySqlGtidSet.Interval interval5 = new MySqlGtidSet.Interval(0L, 2L);
        Assertions.assertThat((List)interval1.remove(interval2)).isEqualTo(Collections.singletonList(new MySqlGtidSet.Interval(6L, 7L)));
        Assertions.assertThat((List)interval2.remove(interval1)).isEqualTo(Collections.singletonList(new MySqlGtidSet.Interval(2L, 2L)));
        Assertions.assertThat((List)interval1.remove(interval3)).isEqualTo(Arrays.asList(new MySqlGtidSet.Interval(3L, 3L), new MySqlGtidSet.Interval(6L, 7L)));
        Assertions.assertThat((List)interval1.remove(interval4)).isEqualTo(Collections.singletonList(interval1));
        Assertions.assertThat((List)interval1.remove(interval5)).isEqualTo(Collections.singletonList(interval1));
        Assertions.assertThat((List)interval3.remove(interval1)).isEqualTo(Collections.emptyList());
        Assertions.assertThat((List)interval3.remove(interval3)).isEqualTo(Collections.emptyList());
    }

    @Test
    public void removeAllIntervals() {
        MySqlGtidSet.Interval interval = new MySqlGtidSet.Interval(1L, 49L);
        List<MySqlGtidSet.Interval> intervalsToRemove = Arrays.asList(new MySqlGtidSet.Interval(5L, 8L), new MySqlGtidSet.Interval(12L, 18L), new MySqlGtidSet.Interval(25L, 55L), new MySqlGtidSet.Interval(60L, 65L));
        List<MySqlGtidSet.Interval> diff = Arrays.asList(new MySqlGtidSet.Interval(1L, 4L), new MySqlGtidSet.Interval(9L, 11L), new MySqlGtidSet.Interval(19L, 24L));
        Assertions.assertThat((List)interval.removeAll(intervalsToRemove)).isEqualTo(diff);
    }

    protected void asertIntervalCount(String uuid, int count) {
        MySqlGtidSet.UUIDSet set = this.gtids.forServerWithId(uuid);
        Assertions.assertThat((int)set.getIntervals().size()).isEqualTo(count);
    }

    protected void asertIntervalExists(String uuid, int start, int end) {
        Assertions.assertThat((boolean)this.hasInterval(uuid, start, end)).isTrue();
    }

    protected void asertFirstInterval(String uuid, int start, int end) {
        MySqlGtidSet.UUIDSet set = this.gtids.forServerWithId(uuid);
        MySqlGtidSet.Interval interval = (MySqlGtidSet.Interval)set.getIntervals().iterator().next();
        Assertions.assertThat((long)interval.getStart()).isEqualTo((long)start);
        Assertions.assertThat((long)interval.getEnd()).isEqualTo((long)end);
    }

    protected void asertLastInterval(String uuid, int start, int end) {
        MySqlGtidSet.UUIDSet set = this.gtids.forServerWithId(uuid);
        MySqlGtidSet.Interval interval = (MySqlGtidSet.Interval)new LinkedList(set.getIntervals()).getLast();
        Assertions.assertThat((long)interval.getStart()).isEqualTo((long)start);
        Assertions.assertThat((long)interval.getEnd()).isEqualTo((long)end);
    }

    protected boolean hasInterval(String uuid, int start, int end) {
        MySqlGtidSet.UUIDSet set = this.gtids.forServerWithId(uuid);
        for (MySqlGtidSet.Interval interval : set.getIntervals()) {
            if (interval.getStart() != (long)start || interval.getEnd() != (long)end) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$shouldCorrectlyDetermineIfComplexGtidSetWithVariousLineSeparatorsIsContainedWithinAnother$0(GtidSet connector, String separator) {
        MySqlGtidSet server = new MySqlGtidSet("036d85a9-64e5-11e6-9b48-42010af0000c:1-2," + separator + "7145bf69-d1ca-11e5-a588-0242ac110004:1-3202," + separator + "7c1de3f2-3fd2-11e6-9cdc-42010af000bc:1-41");
        Assertions.assertThat((boolean)connector.isContainedWithin((GtidSet)server)).isTrue();
    }
}

