/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.snapshot.mode;

import io.debezium.DebeziumException;
import io.debezium.bean.StandardBeanNames;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.snapshot.mode.BeanAwareSnapshotter;
import io.debezium.connector.mysql.strategy.AbstractConnectorConnection;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.spi.snapshot.Snapshotter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialSnapshotter
extends BeanAwareSnapshotter
implements Snapshotter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitialSnapshotter.class);

    public String name() {
        return MySqlConnectorConfig.SnapshotMode.INITIAL.getValue();
    }

    public void configure(Map<String, ?> properties) {
    }

    public void validate(boolean offsetContextExists, boolean isSnapshotInProgress) {
        MySqlConnectorConfig config = (MySqlConnectorConfig)((Object)this.beanRegistry.lookupByName("ConnectorConfig", MySqlConnectorConfig.class));
        AbstractConnectorConnection connection = (AbstractConnectorConnection)((Object)this.beanRegistry.lookupByName(StandardBeanNames.JDBC_CONNECTION, this.getConnectionClass(config)));
        Offsets mySqloffsets = (Offsets)this.beanRegistry.lookupByName(StandardBeanNames.OFFSETS, Offsets.class);
        MySqlOffsetContext offset = (MySqlOffsetContext)mySqloffsets.getTheOnlyOffset();
        if (offset != null && !offset.isSnapshotRunning() && !connection.isBinlogPositionAvailable(config, offset.gtidSet(), offset.getSource().binlogFilename())) {
            throw new DebeziumException("The connector is trying to read binlog starting at " + offset.getSource() + ", but this is no longer available on the server. Reconfigure the connector to use a snapshot when needed.");
        }
    }

    public boolean shouldSnapshot() {
        return true;
    }

    public boolean shouldStream() {
        return true;
    }

    public boolean shouldSnapshotSchema() {
        return true;
    }

    public boolean shouldSnapshotOnSchemaError() {
        return false;
    }

    public boolean shouldSnapshotOnDataError() {
        return false;
    }
}

