/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.snapshot;

import io.debezium.DebeziumException;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.service.spi.ServiceProvider;
import io.debezium.service.spi.ServiceRegistry;
import io.debezium.snapshot.spi.SnapshotLock;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public class MySqlSnapshotLockProvider
implements ServiceProvider<SnapshotLock> {
    public SnapshotLock createService(Configuration configuration, ServiceRegistry serviceRegistry) {
        BeanRegistry beanRegistry = (BeanRegistry)serviceRegistry.tryGetService(BeanRegistry.class);
        MySqlConnectorConfig mySqlConnectorConfig = (MySqlConnectorConfig)((Object)beanRegistry.lookupByName("ConnectorConfig", MySqlConnectorConfig.class));
        MySqlConnectorConfig.SnapshotLockingMode configuredSnapshotQueryMode = mySqlConnectorConfig.getSnapshotLockingMode();
        String snapshotLockingModeCustomName = mySqlConnectorConfig.snapshotLockingModeCustomName();
        String snapshotQueryMode = MySqlConnectorConfig.SnapshotLockingMode.CUSTOM.equals((Object)configuredSnapshotQueryMode) && !snapshotLockingModeCustomName.isEmpty() ? snapshotLockingModeCustomName : configuredSnapshotQueryMode.getValue();
        Optional<SnapshotLock> snapshotLock = StreamSupport.stream(ServiceLoader.load(SnapshotLock.class).spliterator(), false).filter(s -> s.name().equals(snapshotQueryMode)).findAny();
        return snapshotLock.map(s -> {
            s.configure(configuration.asMap());
            if (s instanceof BeanRegistryAware) {
                ((BeanRegistryAware)s).injectBeanRegistry(beanRegistry);
            }
            return s;
        }).orElseThrow(() -> new DebeziumException(String.format("Unable to find %s snapshot query mode. Please check your configuration.", snapshotQueryMode)));
    }

    public Class<SnapshotLock> getServiceClass() {
        return SnapshotLock.class;
    }
}

