/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.connector.mysql.converters.JdbcSinkDataTypesConverter;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.List;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlJdbcSinkDataTypeConverterIT
extends AbstractConnectorTest {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-jdbc-sink.text").toAbsolutePath();
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.initializeConnectorTestFramework();
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-6225"})
    public void testBooleanDataTypeMapping() throws Exception {
        if (VerifyRecord.isApucurioAvailable()) {
            this.skipAvroValidation();
        }
        UniqueDatabase DATABASE = new UniqueDatabase("booleanit", "boolean_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
        DATABASE.createAndInitialize();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, DATABASE.qualifiedTableName("BOOLEAN_TEST") + "," + DATABASE.qualifiedTableName("BOOLEAN_TEST2"))).with(MySqlConnectorConfig.PROPAGATE_COLUMN_SOURCE_TYPE, ".*")).with(MySqlConnectorConfig.CUSTOM_CONVERTERS, "jdbc-sink")).with("jdbc-sink.type", JdbcSinkDataTypesConverter.class.getName()).with("jdbc-sink.selector.boolean", ".*BOOLEAN_TEST.b.*|.*BOOLEAN_TEST2.b.*").build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        Assertions.assertThat((Object)records).isNotNull();
        List tableRecords = records.recordsForTopic(DATABASE.topicForTable("BOOLEAN_TEST"));
        Assertions.assertThat((List)tableRecords).hasSize(1);
        SourceRecord record = (SourceRecord)tableRecords.get(0);
        System.out.println(record);
        Struct after = ((Struct)record.value()).getStruct("after");
        Schema afterSchema = record.valueSchema().field("after").schema();
        Assertions.assertThat((Comparable)afterSchema.field("b1").schema().type()).isEqualTo((Object)Schema.Type.INT16);
        Assertions.assertThat((String)((String)afterSchema.field("b1").schema().parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"TINYINT");
        Assertions.assertThat((String)((String)afterSchema.field("b1").schema().parameters().get("__debezium.source.column.length"))).isEqualTo((Object)"1");
        Assertions.assertThat((Object)after.get("b1")).isEqualTo((Object)0);
        Assertions.assertThat((Comparable)afterSchema.field("b2").schema().type()).isEqualTo((Object)Schema.Type.INT16);
        Assertions.assertThat((String)((String)afterSchema.field("b2").schema().parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"TINYINT");
        Assertions.assertThat((String)((String)afterSchema.field("b2").schema().parameters().get("__debezium.source.column.length"))).isEqualTo((Object)"1");
        Assertions.assertThat((Object)after.get("b2")).isEqualTo((Object)1);
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(DATABASE.getDatabaseName());
             JdbcConnection conn = db.connect();){
            conn.execute(new String[]{"CREATE TABLE BOOLEAN_TEST2 (`id` INT NOT NULL AUTO_INCREMENT, `b1` boolean default true, `b2` boolean default false, primary key (`ID`)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;"});
            conn.execute(new String[]{"INSERT INTO BOOLEAN_TEST2 (b1,b2) VALUES (true, false)"});
        }
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((Object)records).isNotNull();
        tableRecords = records.recordsForTopic(DATABASE.topicForTable("BOOLEAN_TEST2"));
        Assertions.assertThat((List)tableRecords).hasSize(1);
        record = (SourceRecord)tableRecords.get(0);
        System.out.println(record);
        after = ((Struct)record.value()).getStruct("after");
        afterSchema = record.valueSchema().field("after").schema();
        Assertions.assertThat((Comparable)afterSchema.field("b1").schema().type()).isEqualTo((Object)Schema.Type.INT16);
        Assertions.assertThat((String)((String)afterSchema.field("b1").schema().parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"BOOLEAN");
        Assertions.assertThat((String)((String)afterSchema.field("b1").schema().parameters().get("__debezium.source.column.length"))).isNull();
        Assertions.assertThat((Object)after.get("b1")).isEqualTo((Object)1);
        Assertions.assertThat((Comparable)afterSchema.field("b2").schema().type()).isEqualTo((Object)Schema.Type.INT16);
        Assertions.assertThat((String)((String)afterSchema.field("b2").schema().parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"BOOLEAN");
        Assertions.assertThat((String)((String)afterSchema.field("b2").schema().parameters().get("__debezium.source.column.length"))).isNull();
        Assertions.assertThat((Object)after.get("b2")).isEqualTo((Object)0);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-6226"})
    public void testRealDataTypeMapping() throws Exception {
        UniqueDatabase DATABASE = new UniqueDatabase("realit", "real_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
        DATABASE.createAndInitialize();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, DATABASE.qualifiedTableName("REAL_TEST") + "," + DATABASE.qualifiedTableName("REAL_TEST2"))).with(MySqlConnectorConfig.PROPAGATE_COLUMN_SOURCE_TYPE, ".*")).with(MySqlConnectorConfig.CUSTOM_CONVERTERS, "jdbc-sink")).with("jdbc-sink.type", JdbcSinkDataTypesConverter.class.getName()).with("jdbc-sink.selector.real", ".*REAL_TEST.r.*|.*REAL_TEST2.r.*").build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        Assertions.assertThat((Object)records).isNotNull();
        List tableRecords = records.recordsForTopic(DATABASE.topicForTable("REAL_TEST"));
        Assertions.assertThat((List)tableRecords).hasSize(1);
        SourceRecord record = (SourceRecord)tableRecords.get(0);
        Struct after = ((Struct)record.value()).getStruct("after");
        Schema afterSchema = record.valueSchema().field("after").schema();
        Assertions.assertThat((Comparable)afterSchema.field("r1").schema().type()).isEqualTo((Object)Schema.Type.FLOAT64);
        Assertions.assertThat((String)((String)afterSchema.field("r1").schema().parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"DOUBLE");
        Assertions.assertThat((Object)after.get("r1")).isEqualTo((Object)2.36);
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(DATABASE.getDatabaseName());
             JdbcConnection conn = db.connect();){
            conn.execute(new String[]{"CREATE TABLE REAL_TEST2 (`id` INT NOT NULL AUTO_INCREMENT, `r1` real default 3.14, primary key (`ID`)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;"});
            conn.execute(new String[]{"INSERT INTO REAL_TEST2 (r1) VALUES (9.78)"});
        }
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((Object)records).isNotNull();
        tableRecords = records.recordsForTopic(DATABASE.topicForTable("REAL_TEST2"));
        Assertions.assertThat((List)tableRecords).hasSize(1);
        record = (SourceRecord)tableRecords.get(0);
        after = ((Struct)record.value()).getStruct("after");
        afterSchema = record.valueSchema().field("after").schema();
        Assertions.assertThat((Comparable)afterSchema.field("r1").schema().type()).isEqualTo((Object)Schema.Type.FLOAT64);
        Assertions.assertThat((String)((String)afterSchema.field("r1").schema().parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"REAL");
        Assertions.assertThat((Object)after.get("r1")).isEqualTo((Object)9.78);
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-6231"})
    public void testNationalizedCharacterDataTypeMappings() throws Exception {
        UniqueDatabase DATABASE = new UniqueDatabase("nctestit", "nationalized_character_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
        DATABASE.createAndInitialize();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, DATABASE.qualifiedTableName("NC_TEST") + "," + DATABASE.qualifiedTableName("NC_TEST2"))).with(MySqlConnectorConfig.PROPAGATE_COLUMN_SOURCE_TYPE, ".*")).with(MySqlConnectorConfig.CUSTOM_CONVERTERS, "jdbc-sink")).with("jdbc-sink.type", JdbcSinkDataTypesConverter.class.getName()).with("jdbc-sink.selector.string", ".*NC_TEST.nc.*|.*NC_TEST2.nc.*").build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        Assertions.assertThat((Object)records).isNotNull();
        List tableRecords = records.recordsForTopic(DATABASE.topicForTable("NC_TEST"));
        Assertions.assertThat((List)tableRecords).hasSize(1);
        SourceRecord record = (SourceRecord)tableRecords.get(0);
        Struct after = ((Struct)record.value()).getStruct("after");
        Schema afterSchema = record.valueSchema().field("after").schema();
        System.out.println(afterSchema.field("nc1").schema().parameters());
        System.out.println(afterSchema.field("nc2").schema().parameters());
        System.out.println(afterSchema.field("nc3").schema().parameters());
        Assertions.assertThat((Comparable)afterSchema.field("nc1").schema().type()).isEqualTo((Object)Schema.Type.STRING);
        Assertions.assertThat((Object)after.get("nc1")).isEqualTo((Object)"a");
        Assertions.assertThat((String)((String)afterSchema.field("nc1").schema().parameters().get("__debezium.source.column.character_set"))).startsWith((CharSequence)"utf8");
        Assertions.assertThat((String)((String)afterSchema.field("nc1").schema().parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"CHAR");
        Assertions.assertThat((String)((String)afterSchema.field("nc1").schema().parameters().get("__debezium.source.column.length"))).isEqualTo((Object)"1");
        Assertions.assertThat((Comparable)afterSchema.field("nc2").schema().type()).isEqualTo((Object)Schema.Type.STRING);
        Assertions.assertThat((Object)after.get("nc2")).isEqualTo((Object)"123");
        Assertions.assertThat((String)((String)afterSchema.field("nc2").schema().parameters().get("__debezium.source.column.character_set"))).startsWith((CharSequence)"utf8");
        Assertions.assertThat((String)((String)afterSchema.field("nc2").schema().parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"CHAR");
        Assertions.assertThat((String)((String)afterSchema.field("nc2").schema().parameters().get("__debezium.source.column.length"))).isEqualTo((Object)"5");
        Assertions.assertThat((Comparable)afterSchema.field("nc3").schema().type()).isEqualTo((Object)Schema.Type.STRING);
        Assertions.assertThat((Object)after.get("nc3")).isEqualTo((Object)"hello");
        Assertions.assertThat((String)((String)afterSchema.field("nc3").schema().parameters().get("__debezium.source.column.character_set"))).startsWith((CharSequence)"utf8");
        Assertions.assertThat((String)((String)afterSchema.field("nc3").schema().parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"VARCHAR");
        Assertions.assertThat((String)((String)afterSchema.field("nc3").schema().parameters().get("__debezium.source.column.length"))).isEqualTo((Object)"25");
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(DATABASE.getDatabaseName());
             JdbcConnection conn = db.connect();){
            conn.execute(new String[]{"CREATE TABLE NC_TEST2 (`id` INT NOT NULL AUTO_INCREMENT, `nc1` nchar, `nc2` nchar(5), `nc3` nvarchar(25), primary key (`ID`)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;"});
            conn.execute(new String[]{"INSERT INTO NC_TEST2 (nc1,nc2,nc3) VALUES ('b', '456', 'world')"});
        }
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((Object)records).isNotNull();
        tableRecords = records.recordsForTopic(DATABASE.topicForTable("NC_TEST2"));
        Assertions.assertThat((List)tableRecords).hasSize(1);
        record = (SourceRecord)tableRecords.get(0);
        after = ((Struct)record.value()).getStruct("after");
        afterSchema = record.valueSchema().field("after").schema();
        Assertions.assertThat((Comparable)afterSchema.field("nc1").schema().type()).isEqualTo((Object)Schema.Type.STRING);
        Assertions.assertThat((Object)after.get("nc1")).isEqualTo((Object)"b");
        Assertions.assertThat((String)((String)afterSchema.field("nc1").schema().parameters().get("__debezium.source.column.character_set"))).startsWith((CharSequence)"utf8");
        Assertions.assertThat((String)((String)afterSchema.field("nc1").schema().parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"NCHAR");
        Assertions.assertThat((String)((String)afterSchema.field("nc1").schema().parameters().get("__debezium.source.column.length"))).isEqualTo((Object)"1");
        Assertions.assertThat((Comparable)afterSchema.field("nc2").schema().type()).isEqualTo((Object)Schema.Type.STRING);
        Assertions.assertThat((Object)after.get("nc2")).isEqualTo((Object)"456");
        Assertions.assertThat((String)((String)afterSchema.field("nc2").schema().parameters().get("__debezium.source.column.character_set"))).startsWith((CharSequence)"utf8");
        Assertions.assertThat((String)((String)afterSchema.field("nc2").schema().parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"NCHAR");
        Assertions.assertThat((String)((String)afterSchema.field("nc2").schema().parameters().get("__debezium.source.column.length"))).isEqualTo((Object)"5");
        Assertions.assertThat((Comparable)afterSchema.field("nc3").schema().type()).isEqualTo((Object)Schema.Type.STRING);
        Assertions.assertThat((Object)after.get("nc3")).isEqualTo((Object)"world");
        Assertions.assertThat((String)((String)afterSchema.field("nc3").schema().parameters().get("__debezium.source.column.character_set"))).startsWith((CharSequence)"utf8");
        Assertions.assertThat((String)((String)afterSchema.field("nc3").schema().parameters().get("__debezium.source.column.type"))).isEqualTo((Object)"NVARCHAR");
        Assertions.assertThat((String)((String)afterSchema.field("nc3").schema().parameters().get("__debezium.source.column.length"))).isEqualTo((Object)"25");
        this.stopConnector();
    }
}

