/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.MariadbGtidSet;
import com.github.shyiko.mysql.binlog.event.DeleteRowsEventData;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.EventHeader;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.GtidEventData;
import com.github.shyiko.mysql.binlog.event.MariadbGtidEventData;
import com.github.shyiko.mysql.binlog.event.QueryEventData;
import com.github.shyiko.mysql.binlog.event.RotateEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.TransactionPayloadEventData;
import com.github.shyiko.mysql.binlog.event.UpdateRowsEventData;
import com.github.shyiko.mysql.binlog.event.WriteRowsEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import com.github.shyiko.mysql.binlog.network.AuthenticationException;
import com.github.shyiko.mysql.binlog.network.ServerException;
import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.EventBuffer;
import io.debezium.connector.mysql.EventDataDeserializationExceptionData;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.MySqlChangeRecordEmitter;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetrics;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.connector.mysql.strategy.AbstractConnectorConnection;
import io.debezium.connector.mysql.strategy.ConnectorAdapter;
import io.debezium.data.Envelope;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.time.Conversions;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class MySqlStreamingChangeEventSource
implements StreamingChangeEventSource<MySqlPartition, MySqlOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlStreamingChangeEventSource.class);
    private static final String KEEPALIVE_THREAD_NAME = "blc-keepalive";
    private final EnumMap<EventType, BlockingConsumer<Event>> eventHandlers = new EnumMap(EventType.class);
    private final BinaryLogClient client;
    private final MySqlStreamingChangeEventSourceMetrics metrics;
    private final Clock clock;
    private final CommonConnectorConfig.EventProcessingFailureHandlingMode eventDeserializationFailureHandlingMode;
    private final CommonConnectorConfig.EventProcessingFailureHandlingMode inconsistentSchemaHandlingMode;
    private int startingRowNumber = 0;
    private long initialEventsToSkip = 0L;
    private boolean skipEvent = false;
    private boolean ignoreDmlEventByGtidSource = false;
    private final boolean isGtidModeEnabled;
    private final Predicate<String> gtidDmlSourceFilter;
    private final AtomicLong totalRecordCounter = new AtomicLong();
    private volatile Map<String, ?> lastOffset = null;
    private com.github.shyiko.mysql.binlog.GtidSet gtidSet;
    private MariadbGtidSet mariaGtidSet;
    private final Map<String, Thread> binaryLogClientThreads = new ConcurrentHashMap<String, Thread>(4);
    private final MySqlTaskContext taskContext;
    private final MySqlConnectorConfig connectorConfig;
    private final AbstractConnectorConnection connection;
    private final EventDispatcher<MySqlPartition, TableId> eventDispatcher;
    private final ErrorHandler errorHandler;
    private final ConnectorAdapter connectorAdapter;
    private Instant eventTimestamp;
    private MySqlOffsetContext effectiveOffsetContext;

    public MySqlStreamingChangeEventSource(MySqlConnectorConfig connectorConfig, AbstractConnectorConnection connection, EventDispatcher<MySqlPartition, TableId> dispatcher, ErrorHandler errorHandler, Clock clock, MySqlTaskContext taskContext, MySqlStreamingChangeEventSourceMetrics metrics) {
        this.taskContext = taskContext;
        this.connectorConfig = connectorConfig;
        this.connection = connection;
        this.clock = clock;
        this.eventDispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.metrics = metrics;
        this.connectorAdapter = connectorConfig.getConnectorAdapter();
        this.eventDeserializationFailureHandlingMode = connectorConfig.getEventProcessingFailureHandlingMode();
        this.inconsistentSchemaHandlingMode = connectorConfig.inconsistentSchemaFailureHandlingMode();
        this.client = this.connectorAdapter.getBinaryLogClientConfigurator().configure(taskContext.getBinaryLogClient(), Threads.threadFactory(MySqlConnector.class, (String)connectorConfig.getLogicalName(), (String)"binlog-client", (boolean)false, (boolean)false, x -> this.binaryLogClientThreads.put(x.getName(), (Thread)x)), connection);
        Configuration configuration = connectorConfig.getConfig();
        boolean filterDmlEventsByGtidSource = configuration.getBoolean(MySqlConnectorConfig.GTID_SOURCE_FILTER_DML_EVENTS);
        this.gtidDmlSourceFilter = filterDmlEventsByGtidSource ? connectorConfig.gtidSourceFilter() : null;
        this.isGtidModeEnabled = connection.isGtidModeEnabled();
    }

    protected void onEvent(MySqlOffsetContext offsetContext, Event event) {
        long ts = 0L;
        if (event.getHeader().getEventType() == EventType.HEARTBEAT) {
            this.metrics.setMilliSecondsBehindSource(ts);
            return;
        }
        long eventTs = event.getHeader().getTimestamp();
        if (eventTs == 0L) {
            LOGGER.trace("Received unexpected event with 0 timestamp: {}", (Object)event);
            return;
        }
        this.setEventTimestamp(event, eventTs);
        ts = this.clock.currentTimeInMillis() - this.eventTimestamp.toEpochMilli();
        LOGGER.trace("Current milliseconds behind source: {} ms", (Object)ts);
        this.metrics.setMilliSecondsBehindSource(ts);
    }

    private void setEventTimestamp(Event event, long eventTs) {
        if (this.eventTimestamp == null || this.connection.isMariaDb() || !this.isGtidModeEnabled) {
            this.eventTimestamp = Instant.ofEpochMilli(eventTs);
        } else if (event.getHeader().getEventType() == EventType.GTID) {
            GtidEventData gtidEvent = (GtidEventData)this.unwrapData(event);
            long gtidEventTs = gtidEvent.getOriginalCommitTimestamp();
            this.eventTimestamp = gtidEventTs != 0L ? Instant.EPOCH.plus(gtidEventTs, ChronoUnit.MICROS) : Instant.ofEpochMilli(eventTs);
        }
    }

    protected void ignoreEvent(MySqlOffsetContext offsetContext, Event event) {
        LOGGER.trace("Ignoring event due to missing handler: {}", (Object)event);
    }

    protected void handleEvent(MySqlPartition partition, MySqlOffsetContext offsetContext, ChangeEventSource.ChangeEventSourceContext context, Event event) {
        if (event == null) {
            return;
        }
        EventHeader eventHeader = event.getHeader();
        offsetContext.setBinlogServerId(eventHeader.getServerId());
        EventType eventType = eventHeader.getEventType();
        if (eventType == EventType.ROTATE) {
            EventData eventData = event.getData();
            RotateEventData rotateEventData = eventData instanceof EventDeserializer.EventDataWrapper ? (RotateEventData)((EventDeserializer.EventDataWrapper)eventData).getInternal() : (RotateEventData)eventData;
            offsetContext.setBinlogStartPoint(rotateEventData.getBinlogFilename(), rotateEventData.getBinlogPosition());
        } else if (eventHeader instanceof EventHeaderV4) {
            EventHeaderV4 trackableEventHeader = (EventHeaderV4)eventHeader;
            offsetContext.setEventPosition(trackableEventHeader.getPosition(), trackableEventHeader.getEventLength());
        }
        try {
            this.waitWhenStreamingPaused(context);
            this.eventHandlers.getOrDefault(eventType, (BlockingConsumer<Event>)((BlockingConsumer)e -> this.ignoreEvent(offsetContext, (Event)e))).accept((Object)event);
            this.eventDispatcher.dispatchHeartbeatEvent((Partition)partition, (OffsetContext)offsetContext);
            offsetContext.completeEvent();
            this.lastOffset = offsetContext.getOffset();
            if (this.skipEvent) {
                --this.initialEventsToSkip;
                this.skipEvent = this.initialEventsToSkip > 0L;
            }
        }
        catch (RuntimeException e2) {
            this.logStreamingSourceState();
            this.errorHandler.setProducerThrowable((Throwable)new DebeziumException("Error processing binlog event", (Throwable)e2));
            this.eventHandlers.clear();
            LOGGER.info("Error processing binlog event, and propagating to Kafka Connect so it stops this connector. Future binlog events read before connector is shutdown will be ignored.");
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            this.eventHandlers.clear();
            LOGGER.info("Stopped processing binlog events due to thread interruption");
        }
    }

    protected <T extends EventData> T unwrapData(Event event) {
        EventData eventData = event.getData();
        if (eventData instanceof EventDeserializer.EventDataWrapper) {
            eventData = ((EventDeserializer.EventDataWrapper)eventData).getInternal();
        }
        return (T)eventData;
    }

    protected void handleServerStop(MySqlOffsetContext offsetContext, Event event) {
        LOGGER.debug("Server stopped: {}", (Object)event);
    }

    protected void handleServerHeartbeat(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        LOGGER.trace("Server heartbeat: {}", (Object)event);
        this.eventDispatcher.dispatchServerHeartbeatEvent((Partition)partition, (OffsetContext)offsetContext);
    }

    protected void handleServerIncident(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event) {
        if (event.getData() instanceof EventDataDeserializationExceptionData) {
            this.metrics.onErroneousEvent(partition, "source = " + event);
            EventDataDeserializationExceptionData data = (EventDataDeserializationExceptionData)event.getData();
            EventHeaderV4 eventHeader = (EventHeaderV4)data.getCause().getEventHeader();
            if (this.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL) {
                LOGGER.error("Error while deserializing binlog event at offset {}.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{offsetContext.getOffset(), System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), offsetContext.getSource().binlogFilename()});
                throw new RuntimeException(data.getCause());
            }
            if (this.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN) {
                LOGGER.warn("Error while deserializing binlog event at offset {}.{}This exception will be ignored and the event be skipped.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{offsetContext.getOffset(), System.lineSeparator(), System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), offsetContext.getSource().binlogFilename(), data.getCause()});
            }
        } else {
            LOGGER.error("Server incident: {}", (Object)event);
        }
    }

    protected void handleRotateLogsEvent(MySqlOffsetContext offsetContext, Event event) {
        LOGGER.debug("Rotating logs: {}", (Object)event);
        RotateEventData command = (RotateEventData)this.unwrapData(event);
        assert (command != null);
        this.taskContext.getSchema().clearTableMappings();
    }

    protected void handleGtidEvent(MySqlOffsetContext offsetContext, Event event) {
        String uuid;
        LOGGER.debug("GTID transaction: {}", (Object)event);
        GtidEventData gtidEvent = (GtidEventData)this.unwrapData(event);
        String gtid = gtidEvent.getGtid();
        this.gtidSet.add(gtid);
        offsetContext.startGtid(gtid, this.gtidSet.toString());
        this.ignoreDmlEventByGtidSource = false;
        if (this.gtidDmlSourceFilter != null && gtid != null && !this.gtidDmlSourceFilter.test(uuid = gtid.trim().substring(0, gtid.indexOf(":")))) {
            this.ignoreDmlEventByGtidSource = true;
        }
        this.metrics.onGtidChange(gtid);
    }

    protected void handleMariaDbGtidEvent(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        String uuid;
        LOGGER.debug("MariaDB GTID transaction: {}", (Object)event);
        MariadbGtidEventData gtidEvent = (MariadbGtidEventData)this.unwrapData(event);
        String gtid = String.format("%d-%d-%d", gtidEvent.getDomainId(), event.getHeader().getServerId(), gtidEvent.getSequence());
        this.mariaGtidSet.add(gtid);
        offsetContext.startGtid(gtid, this.mariaGtidSet.toString());
        this.ignoreDmlEventByGtidSource = false;
        if (this.gtidDmlSourceFilter != null && gtid != null && !this.gtidDmlSourceFilter.test(uuid = gtidEvent.getDomainId() + "-" + gtidEvent.getServerId())) {
            this.ignoreDmlEventByGtidSource = true;
        }
        this.metrics.onGtidChange(gtid);
        this.handleTransactionBegin(partition, offsetContext, event, null);
    }

    protected void handleRecordingQuery(MySqlOffsetContext offsetContext, Event event) {
        offsetContext.setQuery(this.connectorAdapter.getRecordingQueryFromEvent((EventData)this.unwrapData(event)));
    }

    protected void handleQueryEvent(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        Instant eventTime = Conversions.toInstantFromMillis((long)this.eventTimestamp.toEpochMilli());
        QueryEventData command = (QueryEventData)this.unwrapData(event);
        LOGGER.debug("Received query command: {}", (Object)event);
        String sql = command.getSql().trim();
        if (sql.equalsIgnoreCase("BEGIN")) {
            this.handleTransactionBegin(partition, offsetContext, event, command.getThreadId());
            return;
        }
        if (sql.equalsIgnoreCase("COMMIT")) {
            this.handleTransactionCompletion(partition, offsetContext, event);
            return;
        }
        String upperCasedStatementBegin = Strings.getBegin((String)sql, (int)7).toUpperCase();
        if (upperCasedStatementBegin.startsWith("XA ")) {
            return;
        }
        if (this.taskContext.getSchema().ddlFilter().test(sql)) {
            LOGGER.debug("DDL '{}' was filtered out of processing", (Object)sql);
            return;
        }
        if (upperCasedStatementBegin.equals("INSERT ") || upperCasedStatementBegin.equals("UPDATE ") || upperCasedStatementBegin.equals("DELETE ")) {
            LOGGER.warn("Received DML '" + sql + "' for processing, binlog probably contains events generated with statement or mixed based replication format");
            return;
        }
        if (sql.equalsIgnoreCase("ROLLBACK")) {
            LOGGER.warn("Rollback statements cannot be handled without binlog buffering, the connector will fail. Please check '{}' to see how to enable buffering", (Object)MySqlConnectorConfig.BUFFER_SIZE_FOR_BINLOG_READER.name());
        }
        List<SchemaChangeEvent> schemaChangeEvents = this.taskContext.getSchema().parseStreamingDdl(partition, sql, command.getDatabase(), offsetContext, eventTime);
        try {
            for (SchemaChangeEvent schemaChangeEvent : schemaChangeEvents) {
                TableId tableId;
                if (this.taskContext.getSchema().skipSchemaChangeEvent(schemaChangeEvent)) continue;
                TableId tableId2 = tableId = schemaChangeEvent.getTables().isEmpty() ? null : ((Table)schemaChangeEvent.getTables().iterator().next()).id();
                if (tableId != null && !this.connectorConfig.getSkippedOperations().contains(Envelope.Operation.TRUNCATE) && schemaChangeEvent.getType().equals((Object)SchemaChangeEvent.SchemaChangeEventType.TRUNCATE)) {
                    this.eventDispatcher.dispatchDataChangeEvent((Partition)partition, (DataCollectionId)tableId, (ChangeRecordEmitter)new MySqlChangeRecordEmitter(partition, (OffsetContext)offsetContext, this.clock, Envelope.Operation.TRUNCATE, null, null, this.connectorConfig));
                }
                this.eventDispatcher.dispatchSchemaChangeEvent((Partition)partition, (OffsetContext)offsetContext, (DataCollectionId)tableId, receiver -> {
                    try {
                        receiver.schemaChangeEvent(schemaChangeEvent);
                    }
                    catch (Exception e) {
                        throw new DebeziumException((Throwable)e);
                    }
                });
            }
        }
        catch (InterruptedException e) {
            LOGGER.info("Processing interrupted");
        }
    }

    private void handleTransactionBegin(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event, Long threadId) throws InterruptedException {
        Instant eventTime = Conversions.toInstantFromMillis((long)this.eventTimestamp.toEpochMilli());
        offsetContext.startNextTransaction();
        this.eventDispatcher.dispatchTransactionStartedEvent((Partition)partition, offsetContext.getTransactionId(), (OffsetContext)offsetContext, eventTime);
        if (threadId != null) {
            offsetContext.setBinlogThread(threadId);
        }
        if (this.initialEventsToSkip != 0L) {
            LOGGER.debug("Restarting partially-processed transaction; change events will not be created for the first {} events plus {} more rows in the next event", (Object)this.initialEventsToSkip, (Object)this.startingRowNumber);
            this.skipEvent = true;
        }
    }

    private void handleTransactionCompletion(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        this.eventDispatcher.dispatchTransactionCommittedEvent((Partition)partition, (OffsetContext)offsetContext, Conversions.toInstantFromMillis((long)this.eventTimestamp.toEpochMilli()));
        offsetContext.commitTransaction();
        offsetContext.setBinlogThread(-1L);
        this.skipEvent = false;
        this.ignoreDmlEventByGtidSource = false;
    }

    protected void handleUpdateTableMetadata(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        TableMapEventData metadata = (TableMapEventData)this.unwrapData(event);
        long tableNumber = metadata.getTableId();
        String databaseName = metadata.getDatabase();
        String tableName = metadata.getTable();
        TableId tableId = new TableId(databaseName, null, tableName);
        if (this.taskContext.getSchema().assignTableNumber(tableNumber, tableId)) {
            LOGGER.debug("Received update table metadata event: {}", (Object)event);
        } else {
            this.informAboutUnknownTableIfRequired(partition, offsetContext, event, tableId);
        }
    }

    protected void handleTransactionPayload(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        TransactionPayloadEventData transactionPayloadEventData = (TransactionPayloadEventData)event.getData();
        EventType eventType = null;
        for (Event uncompressedEvent : transactionPayloadEventData.getUncompressedEvents()) {
            eventType = uncompressedEvent.getHeader().getEventType();
            this.eventHandlers.getOrDefault(eventType, (BlockingConsumer<Event>)((BlockingConsumer)e -> this.ignoreEvent(offsetContext, uncompressedEvent))).accept((Object)uncompressedEvent);
        }
    }

    private void informAboutUnknownTableIfRequired(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event, TableId tableId, Envelope.Operation operation) throws InterruptedException {
        if (tableId != null && this.connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
            this.metrics.onErroneousEvent(partition, "source = " + tableId + ", event " + event, operation);
            EventHeaderV4 eventHeader = (EventHeaderV4)event.getHeader();
            if (this.inconsistentSchemaHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL) {
                LOGGER.error("Encountered change event '{}' at offset {} for table {} whose schema isn't known to this connector. One possible cause is an incomplete database schema history topic. Take a new snapshot in this case.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{event, offsetContext.getOffset(), tableId, System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), offsetContext.getSource().binlogFilename()});
                throw new DebeziumException("Encountered change event for table " + tableId + " whose schema isn't known to this connector");
            }
            if (this.inconsistentSchemaHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN) {
                LOGGER.warn("Encountered change event '{}' at offset {} for table {} whose schema isn't known to this connector. One possible cause is an incomplete database schema history topic. Take a new snapshot in this case.{}The event will be ignored.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{event, offsetContext.getOffset(), tableId, System.lineSeparator(), System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), offsetContext.getSource().binlogFilename()});
            } else {
                LOGGER.debug("Encountered change event '{}' at offset {} for table {} whose schema isn't known to this connector. One possible cause is an incomplete database schema history topic. Take a new snapshot in this case.{}The event will be ignored.{}Use the mysqlbinlog tool to view the problematic event: mysqlbinlog --start-position={} --stop-position={} --verbose {}", new Object[]{event, offsetContext.getOffset(), tableId, System.lineSeparator(), System.lineSeparator(), eventHeader.getPosition(), eventHeader.getNextPosition(), offsetContext.getSource().binlogFilename()});
            }
        } else {
            if (tableId == null) {
                Object eventData = this.unwrapData(event);
                if (eventData instanceof WriteRowsEventData) {
                    tableId = this.taskContext.getSchema().getExcludeTableId(((WriteRowsEventData)eventData).getTableId());
                } else if (eventData instanceof UpdateRowsEventData) {
                    tableId = this.taskContext.getSchema().getExcludeTableId(((UpdateRowsEventData)eventData).getTableId());
                } else if (eventData instanceof DeleteRowsEventData) {
                    tableId = this.taskContext.getSchema().getExcludeTableId(((DeleteRowsEventData)eventData).getTableId());
                }
            }
            LOGGER.trace("Filtered {} event for {}", (Object)event.getHeader().getEventType(), (Object)tableId);
            this.metrics.onFilteredEvent(partition, "source = " + tableId, operation);
            this.eventDispatcher.dispatchFilteredEvent((Partition)partition, (OffsetContext)offsetContext);
        }
    }

    private void informAboutUnknownTableIfRequired(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event, TableId tableId) throws InterruptedException {
        this.informAboutUnknownTableIfRequired(partition, offsetContext, event, tableId, null);
    }

    private void validateChangeEventWithTable(Table table, Object[] before, Object[] after) {
        if (table != null) {
            int columnSize = table.columns().size();
            String message = "Error processing {} of row in {} because it's different column size with internal schema size {}, but {} size {}, restart connector with schema recovery mode.";
            if (before != null && columnSize != before.length) {
                LOGGER.error(message, new Object[]{"before", table.id().table(), columnSize, "before", before.length});
                throw new DebeziumException("Error processing row in " + table.id().table() + ", internal schema size " + columnSize + ", but row size " + before.length + " , restart connector with schema recovery mode.");
            }
            if (after != null && columnSize != after.length) {
                LOGGER.error(message, new Object[]{"after", table.id().table(), columnSize, "after", after.length});
                throw new DebeziumException("Error processing row in " + table.id().table() + ", internal schema size " + columnSize + ", but row size " + after.length + " , restart connector with schema recovery mode.");
            }
        }
    }

    protected void handleInsert(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        this.handleChange(partition, offsetContext, event, Envelope.Operation.CREATE, WriteRowsEventData.class, x -> this.taskContext.getSchema().getTableId(x.getTableId()), WriteRowsEventData::getRows, (tableId, row) -> this.eventDispatcher.dispatchDataChangeEvent((Partition)partition, (DataCollectionId)tableId, (ChangeRecordEmitter)new MySqlChangeRecordEmitter(partition, (OffsetContext)offsetContext, this.clock, Envelope.Operation.CREATE, null, (Serializable[])row, this.connectorConfig)), (tableId, row) -> this.validateChangeEventWithTable(this.taskContext.getSchema().tableFor(tableId), null, (Object[])row));
    }

    protected void handleUpdate(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        this.handleChange(partition, offsetContext, event, Envelope.Operation.UPDATE, UpdateRowsEventData.class, x -> this.taskContext.getSchema().getTableId(x.getTableId()), UpdateRowsEventData::getRows, (tableId, row) -> this.eventDispatcher.dispatchDataChangeEvent((Partition)partition, (DataCollectionId)tableId, (ChangeRecordEmitter)new MySqlChangeRecordEmitter(partition, (OffsetContext)offsetContext, this.clock, Envelope.Operation.UPDATE, (Serializable[])row.getKey(), (Serializable[])row.getValue(), this.connectorConfig)), (tableId, row) -> this.validateChangeEventWithTable(this.taskContext.getSchema().tableFor(tableId), (Object[])row.getKey(), (Object[])row.getValue()));
    }

    protected void handleDelete(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        this.handleChange(partition, offsetContext, event, Envelope.Operation.DELETE, DeleteRowsEventData.class, x -> this.taskContext.getSchema().getTableId(x.getTableId()), DeleteRowsEventData::getRows, (tableId, row) -> this.eventDispatcher.dispatchDataChangeEvent((Partition)partition, (DataCollectionId)tableId, (ChangeRecordEmitter)new MySqlChangeRecordEmitter(partition, (OffsetContext)offsetContext, this.clock, Envelope.Operation.DELETE, (Serializable[])row, null, this.connectorConfig)), (tableId, row) -> this.validateChangeEventWithTable(this.taskContext.getSchema().tableFor(tableId), (Object[])row, null));
    }

    private <T extends EventData, U> void handleChange(MySqlPartition partition, MySqlOffsetContext offsetContext, Event event, Envelope.Operation operation, Class<T> eventDataClass, TableIdProvider<T> tableIdProvider, RowsProvider<T, U> rowsProvider, BinlogChangeEmitter<U> changeEmitter, ChangeEventValidator<U> changeEventValidator) throws InterruptedException {
        if (this.skipEvent) {
            LOGGER.info("Skipping previously processed row event: {}", (Object)event);
            return;
        }
        if (this.ignoreDmlEventByGtidSource) {
            LOGGER.debug("Skipping DML event because this GTID source is filtered: {}", (Object)event);
            return;
        }
        T data = this.unwrapData(event);
        TableId tableId = tableIdProvider.getTableId(data);
        List<U> rows = rowsProvider.getRows(data);
        String changeType = operation.name();
        if (tableId != null && this.taskContext.getSchema().schemaFor(tableId) != null) {
            int count = 0;
            int numRows = rows.size();
            if (this.startingRowNumber < numRows) {
                for (int rowIndex = this.startingRowNumber; rowIndex != numRows; ++rowIndex) {
                    U row = rows.get(rowIndex);
                    changeEventValidator.validate(tableId, row);
                    offsetContext.setRowNumber(rowIndex, numRows);
                    offsetContext.event((DataCollectionId)tableId, this.eventTimestamp);
                    changeEmitter.emit(tableId, row);
                    ++count;
                }
                if (LOGGER.isDebugEnabled()) {
                    if (this.startingRowNumber != 0) {
                        LOGGER.debug("Emitted {} {} record(s) for last {} row(s) in event: {}", new Object[]{count, changeType, numRows - this.startingRowNumber, event});
                    } else {
                        LOGGER.debug("Emitted {} {} record(s) for event: {}", new Object[]{count, changeType, event});
                    }
                }
                offsetContext.changeEventCompleted();
            } else {
                LOGGER.debug("Skipping previously processed {} event: {}", (Object)changeType, (Object)event);
            }
        } else {
            this.informAboutUnknownTableIfRequired(partition, offsetContext, event, tableId, operation);
        }
        this.startingRowNumber = 0;
    }

    protected void viewChange(MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        LOGGER.debug("View Change event: {}", (Object)event);
    }

    protected void prepareTransaction(MySqlOffsetContext offsetContext, Event event) throws InterruptedException {
        LOGGER.debug("XA Prepare event: {}", (Object)event);
    }

    public void init(MySqlOffsetContext offsetContext) {
        this.effectiveOffsetContext = offsetContext != null ? offsetContext : MySqlOffsetContext.initial(this.connectorConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context, MySqlPartition partition, MySqlOffsetContext offsetContext) throws InterruptedException {
        BinaryLogClient.EventListener listener;
        if (!this.connectorConfig.getSnapshotMode().shouldStream()) {
            LOGGER.info("Streaming is disabled for snapshot mode {}", (Object)this.connectorConfig.getSnapshotMode());
            return;
        }
        if (this.connectorConfig.getSnapshotMode() != MySqlConnectorConfig.SnapshotMode.NEVER) {
            this.taskContext.getSchema().assureNonEmptySchema();
        }
        EnumSet skippedOperations = this.connectorConfig.getSkippedOperations();
        this.eventHandlers.put(EventType.STOP, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleServerStop(this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.HEARTBEAT, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleServerHeartbeat(partition, this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.INCIDENT, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleServerIncident(partition, this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.ROTATE, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleRotateLogsEvent(this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.TABLE_MAP, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleUpdateTableMetadata(partition, this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.QUERY, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleQueryEvent(partition, this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.TRANSACTION_PAYLOAD, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleTransactionPayload(partition, this.effectiveOffsetContext, (Event)event)));
        if (!skippedOperations.contains(Envelope.Operation.CREATE)) {
            this.eventHandlers.put(EventType.WRITE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleInsert(partition, this.effectiveOffsetContext, (Event)event)));
            this.eventHandlers.put(EventType.EXT_WRITE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleInsert(partition, this.effectiveOffsetContext, (Event)event)));
        }
        if (!skippedOperations.contains(Envelope.Operation.UPDATE)) {
            this.eventHandlers.put(EventType.UPDATE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleUpdate(partition, this.effectiveOffsetContext, (Event)event)));
            this.eventHandlers.put(EventType.EXT_UPDATE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleUpdate(partition, this.effectiveOffsetContext, (Event)event)));
        }
        if (!skippedOperations.contains(Envelope.Operation.DELETE)) {
            this.eventHandlers.put(EventType.DELETE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleDelete(partition, this.effectiveOffsetContext, (Event)event)));
            this.eventHandlers.put(EventType.EXT_DELETE_ROWS, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleDelete(partition, this.effectiveOffsetContext, (Event)event)));
        }
        this.eventHandlers.put(EventType.VIEW_CHANGE, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.viewChange(this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.XA_PREPARE, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.prepareTransaction(this.effectiveOffsetContext, (Event)event)));
        this.eventHandlers.put(EventType.XID, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleTransactionCompletion(partition, this.effectiveOffsetContext, (Event)event)));
        if (this.connectorConfig.includeSqlQuery()) {
            EventType eventType = this.connectorAdapter.getBinaryLogClientConfigurator().getIncludeSqlQueryEventType();
            this.eventHandlers.put(eventType, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleRecordingQuery(this.effectiveOffsetContext, (Event)event)));
        }
        if (this.connectorConfig.bufferSizeForStreamingChangeEventSource() == 0) {
            listener = event -> this.handleEvent(partition, this.effectiveOffsetContext, context, event);
        } else {
            EventBuffer buffer = new EventBuffer(this.connectorConfig.bufferSizeForStreamingChangeEventSource(), this, context);
            listener = event -> buffer.add(partition, this.effectiveOffsetContext, event);
        }
        this.client.registerEventListener(listener);
        this.client.registerLifecycleListener((BinaryLogClient.LifecycleListener)new ReaderThreadLifecycleListener(this.effectiveOffsetContext));
        this.client.registerEventListener(event -> this.onEvent(this.effectiveOffsetContext, event));
        if (LOGGER.isDebugEnabled()) {
            this.client.registerEventListener(event -> this.logEvent(this.effectiveOffsetContext, event));
        }
        this.metrics.setIsGtidModeEnabled(this.isGtidModeEnabled);
        if (this.isGtidModeEnabled) {
            this.eventHandlers.put(EventType.MARIADB_GTID, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleMariaDbGtidEvent(partition, this.effectiveOffsetContext, (Event)event)));
            this.eventHandlers.put(EventType.GTID, (BlockingConsumer<Event>)((BlockingConsumer)event -> this.handleGtidEvent(this.effectiveOffsetContext, (Event)event)));
            GtidSet availableServerGtidSet = this.connection.knownGtidSet();
            GtidSet purgedServerGtidSet = this.connection.purgedGtidSet();
            LOGGER.info("GTID set purged on server: '{}'", (Object)purgedServerGtidSet);
            GtidSet filteredGtidSet = this.connection.filterGtidSet(this.connectorConfig.gtidSourceFilter(), this.effectiveOffsetContext.gtidSet(), availableServerGtidSet, purgedServerGtidSet);
            if (filteredGtidSet != null) {
                LOGGER.info("Registering binlog reader with GTID set: '{}'", (Object)filteredGtidSet);
                String filteredGtidSetStr = filteredGtidSet.toString();
                this.client.setGtidSet(filteredGtidSetStr);
                this.effectiveOffsetContext.setCompletedGtidSet(filteredGtidSetStr);
                if (this.connection.isMariaDb()) {
                    this.mariaGtidSet = new MariadbGtidSet(filteredGtidSetStr);
                } else {
                    this.gtidSet = new com.github.shyiko.mysql.binlog.GtidSet(filteredGtidSetStr);
                }
            } else {
                this.client.setBinlogFilename(this.effectiveOffsetContext.getSource().binlogFilename());
                this.client.setBinlogPosition(this.effectiveOffsetContext.getSource().binlogPosition());
                this.mariaGtidSet = new MariadbGtidSet("");
                this.gtidSet = new com.github.shyiko.mysql.binlog.GtidSet("");
            }
        } else {
            this.client.setBinlogFilename(this.effectiveOffsetContext.getSource().binlogFilename());
            this.client.setBinlogPosition(this.effectiveOffsetContext.getSource().binlogPosition());
        }
        this.initialEventsToSkip = this.effectiveOffsetContext.eventsToSkipUponRestart();
        LOGGER.info("Skip {} events on streaming start", (Object)this.initialEventsToSkip);
        this.startingRowNumber = this.effectiveOffsetContext.rowsToSkipUponRestart();
        LOGGER.info("Skip {} rows on streaming start", (Object)this.startingRowNumber);
        this.skipEvent = false;
        try {
            if (context.isRunning()) {
                long timeout = this.connectorConfig.getConnectionTimeout().toMillis();
                long started = this.clock.currentTimeInMillis();
                try {
                    LOGGER.debug("Attempting to establish binlog reader connection with timeout of {} ms", (Object)timeout);
                    this.client.connect(timeout);
                    if (this.client.isKeepAlive()) {
                        LOGGER.info("Waiting for keepalive thread to start");
                        Metronome metronome = Metronome.parker((Duration)Duration.ofMillis(100L), (Clock)this.clock);
                        int waitAttempts = 50;
                        boolean keepAliveThreadRunning = false;
                        while (!keepAliveThreadRunning && waitAttempts-- > 0) {
                            for (Thread t : this.binaryLogClientThreads.values()) {
                                if (!t.getName().startsWith(KEEPALIVE_THREAD_NAME) || !t.isAlive()) continue;
                                LOGGER.info("Keepalive thread is running");
                                keepAliveThreadRunning = true;
                            }
                            metronome.pause();
                        }
                    }
                }
                catch (TimeoutException e) {
                    long duration = this.clock.currentTimeInMillis() - started;
                    if ((double)duration > 0.9 * (double)timeout) {
                        double actualSeconds = TimeUnit.MILLISECONDS.toSeconds(duration);
                        throw new DebeziumException("Timed out after " + actualSeconds + " seconds while waiting to connect to MySQL at " + this.connectorConfig.hostname() + ":" + this.connectorConfig.port() + " with user '" + this.connectorConfig.username() + "'", (Throwable)e);
                    }
                }
                catch (AuthenticationException e) {
                    throw new DebeziumException("Failed to authenticate to the MySQL database at " + this.connectorConfig.hostname() + ":" + this.connectorConfig.port() + " with user '" + this.connectorConfig.username() + "'", (Throwable)e);
                }
                catch (Throwable e) {
                    throw new DebeziumException("Unable to connect to the MySQL database at " + this.connectorConfig.hostname() + ":" + this.connectorConfig.port() + " with user '" + this.connectorConfig.username() + "': " + e.getMessage(), e);
                }
            }
            while (context.isRunning()) {
                Thread.sleep(100L);
                this.waitWhenStreamingPaused(context);
            }
        }
        finally {
            try {
                this.client.disconnect();
            }
            catch (Exception e) {
                LOGGER.info("Exception while stopping binary log client", (Throwable)e);
            }
        }
    }

    private void waitWhenStreamingPaused(ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        if (context.isPaused()) {
            LOGGER.info("Streaming will now pause");
            context.streamingPaused();
            context.waitSnapshotCompletion();
            LOGGER.info("Streaming resumed");
        }
    }

    public MySqlOffsetContext getOffsetContext() {
        return this.effectiveOffsetContext;
    }

    private void logStreamingSourceState() {
        this.logStreamingSourceState(Level.ERROR);
    }

    protected void logEvent(MySqlOffsetContext offsetContext, Event event) {
        LOGGER.trace("Received event: {}", (Object)event);
    }

    private void logStreamingSourceState(Level severity) {
        String position = this.client == null ? "N/A" : this.client.getBinlogFilename() + "/" + this.client.getBinlogPosition();
        String message = "Error during binlog processing. Last offset stored = {}, binlog reader near position = {}";
        switch (severity) {
            case WARN: {
                LOGGER.warn("Error during binlog processing. Last offset stored = {}, binlog reader near position = {}", this.lastOffset, (Object)position);
                break;
            }
            case DEBUG: {
                LOGGER.debug("Error during binlog processing. Last offset stored = {}, binlog reader near position = {}", this.lastOffset, (Object)position);
                break;
            }
            default: {
                LOGGER.error("Error during binlog processing. Last offset stored = {}, binlog reader near position = {}", this.lastOffset, (Object)position);
            }
        }
    }

    MySqlStreamingChangeEventSourceMetrics getMetrics() {
        return this.metrics;
    }

    void rewindBinaryLogClient(ChangeEventSource.ChangeEventSourceContext context, BinlogPosition position) {
        try {
            if (context.isRunning()) {
                LOGGER.debug("Rewinding binlog to position {}", (Object)position);
                this.client.disconnect();
                this.client.setBinlogFilename(position.getFilename());
                this.client.setBinlogPosition(position.getPosition());
                this.client.connect();
            }
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error when re-connecting to the MySQL binary log reader", (Throwable)e);
        }
    }

    BinlogPosition getCurrentBinlogPosition() {
        return new BinlogPosition(this.client.getBinlogFilename(), this.client.getBinlogPosition());
    }

    protected DebeziumException wrap(Throwable error) {
        assert (error != null);
        Object msg = error.getMessage();
        if (error instanceof ServerException) {
            ServerException e = (ServerException)error;
            msg = (String)msg + " Error code: " + e.getErrorCode() + "; SQLSTATE: " + e.getSqlState() + ".";
        } else if (error instanceof SQLException) {
            SQLException e = (SQLException)error;
            msg = e.getMessage() + " Error code: " + e.getErrorCode() + "; SQLSTATE: " + e.getSQLState() + ".";
        }
        return new DebeziumException((String)msg, error);
    }

    @FunctionalInterface
    private static interface TableIdProvider<E extends EventData> {
        public TableId getTableId(E var1);
    }

    @FunctionalInterface
    private static interface RowsProvider<E extends EventData, U> {
        public List<U> getRows(E var1);
    }

    @FunctionalInterface
    private static interface BinlogChangeEmitter<T> {
        public void emit(TableId var1, T var2) throws InterruptedException;
    }

    @FunctionalInterface
    private static interface ChangeEventValidator<U> {
        public void validate(TableId var1, U var2);
    }

    protected final class ReaderThreadLifecycleListener
    implements BinaryLogClient.LifecycleListener {
        private final MySqlOffsetContext offsetContext;

        ReaderThreadLifecycleListener(MySqlOffsetContext offsetContext) {
            this.offsetContext = offsetContext;
        }

        public void onDisconnect(BinaryLogClient client) {
            if (LOGGER.isInfoEnabled()) {
                MySqlStreamingChangeEventSource.this.taskContext.temporaryLoggingContext((CommonConnectorConfig)MySqlStreamingChangeEventSource.this.connectorConfig, "binlog", () -> {
                    Map<String, ?> offset = MySqlStreamingChangeEventSource.this.lastOffset;
                    if (offset != null) {
                        LOGGER.info("Stopped reading binlog after {} events, last recorded offset: {}", (Object)MySqlStreamingChangeEventSource.this.totalRecordCounter, offset);
                    } else {
                        LOGGER.info("Stopped reading binlog after {} events, no new offset was recorded", (Object)MySqlStreamingChangeEventSource.this.totalRecordCounter);
                    }
                });
            }
        }

        public void onConnect(BinaryLogClient client) {
            MySqlStreamingChangeEventSource.this.taskContext.configureLoggingContext("binlog");
            LOGGER.info("Connected to binlog at {}:{}, starting at {}", new Object[]{MySqlStreamingChangeEventSource.this.connectorConfig.hostname(), MySqlStreamingChangeEventSource.this.connectorConfig.port(), this.offsetContext});
        }

        public void onCommunicationFailure(BinaryLogClient client, Exception ex) {
            LOGGER.debug("A communication failure event arrived", (Throwable)ex);
            MySqlStreamingChangeEventSource.this.logStreamingSourceState();
            try {
                client.disconnect();
            }
            catch (Exception e) {
                LOGGER.debug("Exception while closing client", (Throwable)e);
            }
            MySqlStreamingChangeEventSource.this.errorHandler.setProducerThrowable((Throwable)MySqlStreamingChangeEventSource.this.wrap(ex));
        }

        public void onEventDeserializationFailure(BinaryLogClient client, Exception ex) {
            if (MySqlStreamingChangeEventSource.this.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL) {
                LOGGER.debug("A deserialization failure event arrived", (Throwable)ex);
                MySqlStreamingChangeEventSource.this.logStreamingSourceState();
                MySqlStreamingChangeEventSource.this.errorHandler.setProducerThrowable((Throwable)MySqlStreamingChangeEventSource.this.wrap(ex));
            } else if (MySqlStreamingChangeEventSource.this.eventDeserializationFailureHandlingMode == CommonConnectorConfig.EventProcessingFailureHandlingMode.WARN) {
                LOGGER.warn("A deserialization failure event arrived", (Throwable)ex);
                MySqlStreamingChangeEventSource.this.logStreamingSourceState(Level.WARN);
            } else {
                LOGGER.debug("A deserialization failure event arrived", (Throwable)ex);
                MySqlStreamingChangeEventSource.this.logStreamingSourceState(Level.DEBUG);
            }
        }
    }

    public static class BinlogPosition {
        final String filename;
        final long position;

        public BinlogPosition(String filename, long position) {
            assert (filename != null);
            this.filename = filename;
            this.position = position;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getPosition() {
            return this.position;
        }

        public String toString() {
            return this.filename + "/" + this.position;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.filename.hashCode();
            result = 31 * result + (int)(this.position ^ this.position >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BinlogPosition other = (BinlogPosition)obj;
            if (!this.filename.equals(other.filename)) {
                return false;
            }
            return this.position == other.position;
        }
    }
}

