/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.zzz;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.connector.mysql.junit.SkipTestDependingOnGtidModeRule;
import io.debezium.connector.mysql.junit.SkipWhenGtidModeIs;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenDatabaseVersion(check=EqualityCheck.LESS_THAN, major=5, minor=6, reason="DDL uses fractional second data types, not supported until MySQL 5.6")
@SkipWhenGtidModeIs(value=SkipWhenGtidModeIs.GtidMode.OFF)
public class ZZZGtidSetIT
extends AbstractConnectorTest {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-connect.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("myServer1", "connector_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private final UniqueDatabase RO_DATABASE = new UniqueDatabase("myServer2", "connector_test_ro", this.DATABASE).withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;
    @Rule
    public TestRule skipTest = new SkipTestDependingOnGtidModeRule();

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.RO_DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    private boolean isGtidModeEnabled() throws SQLException {
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());){
            boolean bl = (Boolean)db.queryAndMap("SHOW GLOBAL VARIABLES LIKE 'GTID_MODE'", rs -> {
                if (rs.next()) {
                    return "ON".equalsIgnoreCase(rs.getString(2));
                }
                throw new IllegalStateException("Cannot obtain GTID status");
            });
            return bl;
        }
    }

    @Test
    @FixFor(value={"DBZ-1184"})
    public void shouldProcessPurgedGtidSet() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        this.purgeDatabaseLogs();
        UniqueDatabase database = new UniqueDatabase("myServer1", "connector_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
        UniqueDatabase ro_database = new UniqueDatabase("myServer2", "connector_test_ro", database).withDbHistoryPath(SCHEMA_HISTORY_PATH);
        ro_database.createAndInitialize();
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)ro_database.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, ro_database.qualifiedTableName("customers"))).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(10);
        Assertions.assertThat((int)records.recordsForTopic(ro_database.topicForTable("customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(ro_database.getDatabaseName()).size()).isEqualTo(6);
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
        records.recordsForTopic(ro_database.topicForTable("customers")).forEach(record -> {
            String gtids = (String)record.sourceOffset().get("gtids");
            Pattern p = Pattern.compile(".*:(.*)-.*");
            Matcher m = p.matcher(gtids);
            m.matches();
            Assertions.assertThat((String)m.group(1)).isNotEqualTo((Object)"1");
        });
        this.stopConnector();
    }

    private void purgeDatabaseLogs() throws SQLException {
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"FLUSH LOGS"});
            List<String> binlogs = this.getBinlogs(connection);
            String lastBinlogName = binlogs.get(binlogs.size() - 1);
            connection.execute(new String[]{"PURGE BINARY LOGS TO '" + lastBinlogName + "'"});
            Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> {
                List<String> binlogsAfterPurge = this.getBinlogs(connection);
                if (binlogsAfterPurge.size() != 1) {
                    Testing.print((Object)("Binlogs before purging: " + binlogs));
                    Testing.print((Object)("Binlogs after purging: " + binlogsAfterPurge));
                }
                return binlogsAfterPurge.size() == 1;
            });
        }
    }

    private List<String> getBinlogs(JdbcConnection connection) throws SQLException {
        return (List)connection.queryAndMap("SHOW BINARY LOGS", rs -> {
            ArrayList<String> binlogs = new ArrayList<String>();
            while (rs.next()) {
                binlogs.add(rs.getString(1));
            }
            return binlogs;
        });
    }

    @Test
    @FixFor(value={"DBZ-1244"})
    public void shouldProcessPurgedLogsWhenDownAndSnapshotNeeded() throws SQLException, InterruptedException {
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        this.purgeDatabaseLogs();
        UniqueDatabase database = new UniqueDatabase("myServer1", "connector_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
        database.createAndInitialize();
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)database.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.WHEN_NEEDED)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, database.qualifiedTableName("customers"))).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(16);
        Assertions.assertThat((int)records.recordsForTopic(database.topicForTable("customers")).size()).isEqualTo(4);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(database.getDatabaseName()).size()).isEqualTo(11);
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
        this.stopConnector();
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(database.getDatabaseName());){
            db.execute(new String[]{"INSERT INTO customers VALUES(default,1,1,1)", "INSERT INTO customers VALUES(default,2,2,2)"});
        }
        this.start(MySqlConnector.class, this.config);
        records = this.consumeRecordsByTopic(2);
        this.stopConnector();
        db = MySqlTestConnection.forTestDatabase(database.getDatabaseName());
        try {
            db.execute(new String[]{"INSERT INTO customers VALUES(default,3,3,3)", "INSERT INTO customers VALUES(default,4,4,4)"});
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        this.purgeDatabaseLogs();
        this.start(MySqlConnector.class, this.config);
        records = this.consumeRecordsByTopic(20);
        Assertions.assertThat((int)records.recordsForTopic(database.topicForTable("customers")).size()).isEqualTo(8);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(database.getDatabaseName()).size()).isEqualTo(11);
        this.stopConnector();
        db = MySqlTestConnection.forTestDatabase(database.getDatabaseName());
        try {
            db.execute(new String[]{"INSERT INTO customers VALUES(default,5,5,5)", "INSERT INTO customers VALUES(default,6,6,6)"});
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        this.purgeDatabaseLogs();
        db = MySqlTestConnection.forTestDatabase(database.getDatabaseName());
        try {
            db.execute(new String[]{"INSERT INTO customers VALUES(default,7,7,7)", "INSERT INTO customers VALUES(default,8,8,8)"});
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        this.start(MySqlConnector.class, this.config);
        records = this.consumeRecordsByTopic(24);
        Assertions.assertThat((int)records.recordsForTopic(database.topicForTable("customers")).size()).isEqualTo(12);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(database.getDatabaseName()).size()).isEqualTo(11);
        this.stopConnector();
    }
}

