/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.io.ByteReader;
import mil.nga.wkb.io.WkbGeometryReader;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@SkipWhenDatabaseVersion(check=EqualityCheck.LESS_THAN, major=5, minor=6, reason="Function ST_GeomFromText not added until MySQL 5.6")
public class MySqlGeometryIT
extends AbstractConnectorTest {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-json.txt").toAbsolutePath();
    private UniqueDatabase DATABASE;
    private DatabaseGeoDifferences databaseDifferences;
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.databaseDifferences = this.databaseGeoDifferences(MySqlTestConnection.isMySQL5() || MySqlTestConnection.isMariaDb());
        this.DATABASE = new UniqueDatabase("geometryit", this.databaseDifferences.geometryDatabaseName()).withDbHistoryPath(SCHEMA_HISTORY_PATH);
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingBinlogAndNoSnapshot() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 2;
        int numDataRecords = this.databaseDifferences.geometryPointTableRecords() + 2;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_222_point")).size()).isEqualTo(this.databaseDifferences.geometryPointTableRecords());
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_507_geometry")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1 + numCreateTables);
        Assertions.assertThat((int)records.databaseNames().size()).isEqualTo(1);
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(numCreateDatabase + numCreateTables);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("regression_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("json_test")).isNull();
        records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).forEach(x$0 -> this.print((SourceRecord)x$0));
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_222_point")) {
                this.assertPoint(value);
            } else if (record.topic().endsWith("dbz_507_geometry")) {
                this.assertGeomRecord(value);
            }
        });
    }

    @Test
    public void shouldConsumeAllEventsFromDatabaseUsingSnapshot() throws SQLException, InterruptedException {
        this.config = this.DATABASE.defaultConfig().build();
        this.start(MySqlConnector.class, this.config);
        int numTables = 2;
        int numDataRecords = this.databaseDifferences.geometryPointTableRecords() + 2;
        int numDdlRecords = numTables * 2 + 3;
        int numSetVariables = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numDdlRecords + numSetVariables + numDataRecords);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.getServerName()).size()).isEqualTo(numDdlRecords + numSetVariables);
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_222_point")).size()).isEqualTo(this.databaseDifferences.geometryPointTableRecords());
        Assertions.assertThat((int)records.recordsForTopic(this.DATABASE.topicForTable("dbz_507_geometry")).size()).isEqualTo(2);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(numTables + 1);
        Assertions.assertThat((Iterable)records.databaseNames()).containsOnly((Object[])new String[]{this.DATABASE.getDatabaseName(), ""});
        Assertions.assertThat((int)records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).size()).isEqualTo(numDdlRecords);
        Assertions.assertThat((List)records.ddlRecordsForDatabase("regression_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("connector_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("readbinlog_test")).isNull();
        Assertions.assertThat((List)records.ddlRecordsForDatabase("json_test")).isNull();
        Assertions.assertThat((int)records.ddlRecordsForDatabase("").size()).isEqualTo(1);
        records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName()).forEach(x$0 -> this.print((SourceRecord)x$0));
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
        records.forEach(record -> {
            Struct value = (Struct)record.value();
            if (record.topic().endsWith("dbz_222_point")) {
                this.assertPoint(value);
            } else if (record.topic().endsWith("dbz_507_geometry")) {
                this.assertGeomRecord(value);
            }
        });
    }

    private void assertPoint(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Testing.debug((Object)after);
        Assertions.assertThat((Integer)i).isNotNull();
        Double expectedX = after.getFloat64("expected_x");
        Double expectedY = after.getFloat64("expected_y");
        Integer expectedSrid = after.getInt32("expected_srid");
        if (after.getStruct("point") != null) {
            Double actualX = after.getStruct("point").getFloat64("x");
            Double actualY = after.getStruct("point").getFloat64("y");
            Integer actualSrid = after.getStruct("point").getInt32("srid");
            this.databaseDifferences.geometryAssertPoints(expectedX, expectedY, actualX, actualY);
            Assertions.assertThat((Integer)actualSrid).isEqualTo((Object)expectedSrid);
            Point point = (Point)WkbGeometryReader.readGeometry((ByteReader)new ByteReader((byte[])after.getStruct("point").get("wkb")));
            this.databaseDifferences.geometryAssertPoints(expectedX, expectedY, point.getX(), point.getY());
        } else if (expectedX != null) {
            Assert.fail((String)"Got a null geometry but didn't expect to");
        }
    }

    private void assertGeomRecord(Struct value) {
        Struct after = value.getStruct("after");
        Integer i = after.getInt32("id");
        Testing.debug((Object)after);
        Assertions.assertThat((Integer)i).isNotNull();
        if (i == 1) {
            Assertions.assertThat((Integer)after.getStruct("geom").getInt32("srid")).isEqualTo(4326);
            Assertions.assertThat((String)DatatypeConverter.printHexBinary((byte[])after.getStruct("geom").getBytes("wkb"))).isEqualTo((Object)"0101000000000000000000F03F000000000000F03F");
            Assertions.assertThat((Integer)after.getStruct("linestring").getInt32("srid")).isEqualTo(3187);
            Assertions.assertThat((String)DatatypeConverter.printHexBinary((byte[])after.getStruct("linestring").getBytes("wkb"))).isEqualTo((Object)"01020000000200000000000000000000000000000000000000000000000000F03F000000000000F03F");
            Assertions.assertThat((Integer)after.getStruct("polygon").getInt32("srid")).isEqualTo(null);
            Assertions.assertThat((String)DatatypeConverter.printHexBinary((byte[])after.getStruct("polygon").getBytes("wkb"))).isEqualTo((Object)"0103000000010000000400000000000000000000000000000000000000000000000000F03F000000000000F03F000000000000F03F000000000000000000000000000000000000000000000000");
            Assertions.assertThat((Integer)after.getStruct("collection").getInt32("srid")).isEqualTo(4326);
            Assertions.assertThat((String)DatatypeConverter.printHexBinary((byte[])after.getStruct("collection").getBytes("wkb"))).isEqualTo((Object)"0107000000020000000101000000000000000000F03F000000000000F03F01020000000200000000000000000000000000000000000000000000000000F03F000000000000F03F");
        } else if (i == 2) {
            Assertions.assertThat((Integer)after.getStruct("geom").getInt32("srid")).isEqualTo(null);
            Assertions.assertThat((String)DatatypeConverter.printHexBinary((byte[])after.getStruct("geom").getBytes("wkb"))).isEqualTo((Object)"01020000000200000000000000000000000000000000000000000000000000F03F000000000000F03F");
            Assertions.assertThat((Object)after.getStruct("linestring")).isNull();
            Assertions.assertThat((Object)after.getStruct("polygon")).isNull();
            Assertions.assertThat((Object)after.getStruct("collection")).isNull();
        }
    }

    private DatabaseGeoDifferences databaseGeoDifferences(boolean mySql5) {
        if (mySql5) {
            return new DatabaseGeoDifferences(){

                @Override
                public String geometryDatabaseName() {
                    return "geometry_test_5";
                }

                @Override
                public int geometryPointTableRecords() {
                    return 4;
                }

                @Override
                public void geometryAssertPoints(Double expectedX, Double expectedY, Double actualX, Double actualY) {
                    Assertions.assertThat((Double)actualX).isEqualTo(expectedX, Assertions.offset((Double)0.01));
                    Assertions.assertThat((Double)actualY).isEqualTo(expectedY, Assertions.offset((Double)0.01));
                }
            };
        }
        return new DatabaseGeoDifferences(){

            @Override
            public String geometryDatabaseName() {
                return "geometry_test_8";
            }

            @Override
            public int geometryPointTableRecords() {
                return 3;
            }

            @Override
            public void geometryAssertPoints(Double expectedX, Double expectedY, Double actualX, Double actualY) {
                Assertions.assertThat((Double)actualX).isEqualTo(expectedY, Assertions.offset((Double)0.01));
                Assertions.assertThat((Double)actualY).isEqualTo(expectedX, Assertions.offset((Double)0.01));
            }
        };
    }

    private static interface DatabaseGeoDifferences {
        public String geometryDatabaseName();

        public int geometryPointTableRecords();

        public void geometryAssertPoints(Double var1, Double var2, Double var3, Double var4);
    }
}

