/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.junit.SkipWhenDatabaseVersions;
import io.debezium.util.Testing;
import java.nio.file.Path;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@SkipWhenDatabaseVersions(value={@SkipWhenDatabaseVersion(check=EqualityCheck.LESS_THAN, major=5, minor=7, reason="Generated values were not added until MySQL 5.7"), @SkipWhenDatabaseVersion(check=EqualityCheck.GREATER_THAN_OR_EQUAL, major=11, reason="MariaDB does not allow you to specify AS and NOT NULL")})
public class MysqlDefaultGeneratedValueIT
extends AbstractConnectorTest {
    private static final int EVENT_COUNT = 49;
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-connect.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("myServer1", "default_value_generated").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-1123"})
    public void generatedValueTest() throws InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(49);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("GENERATED_TABLE")).get(0);
        this.validate(record);
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Integer recordB = ((Struct)record.value()).getStruct("after").getInt32("B");
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Integer recordC = ((Struct)record.value()).getStruct("after").getInt32("C");
        Assertions.assertThat((boolean)schemaB.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo(null);
        Assertions.assertThat((boolean)schemaC.isOptional()).isEqualTo(false);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Integer)recordB).isEqualTo(30);
        Assertions.assertThat((Integer)recordC).isEqualTo(45);
        this.validate(record);
    }
}

