/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.DatabaseDifferences;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import java.sql.SQLException;
import java.util.Map;

public class MySqlTestConnection
extends JdbcConnection {
    private DatabaseDifferences databaseAsserts;
    private MySqlVersion mySqlVersion;
    protected static JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory((String)"jdbc:mysql://${hostname}:${port}/${dbname}", (Field[])new Field[0]);

    public static MySqlTestConnection forTestDatabase(String databaseName) {
        return new MySqlTestConnection((JdbcConfiguration)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.").merge(new Configuration[]{Configuration.fromSystemProperties((String)"driver.")})).withDatabase(databaseName).with("characterEncoding", "utf8")).build());
    }

    public static MySqlTestConnection forTestDatabase(String databaseName, Map<String, Object> urlProperties) {
        JdbcConfiguration.Builder builder = (JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.").merge(new Configuration[]{Configuration.fromSystemProperties((String)"driver.")})).withDatabase(databaseName).with("characterEncoding", "utf8");
        urlProperties.forEach((arg_0, arg_1) -> ((JdbcConfiguration.Builder)builder).with(arg_0, arg_1));
        return new MySqlTestConnection((JdbcConfiguration)builder.build());
    }

    public static MySqlTestConnection forTestDatabase(String databaseName, String username, String password) {
        return new MySqlTestConnection((JdbcConfiguration)JdbcConfiguration.copy((Configuration)Configuration.fromSystemProperties((String)"database.").merge(new Configuration[]{Configuration.fromSystemProperties((String)"driver.")})).withDatabase(databaseName).withUser(username).withPassword(password).build());
    }

    public static boolean isMySQL5() {
        switch (MySqlTestConnection.forTestDatabase("mysql").getMySqlVersion()) {
            case MYSQL_5_5: 
            case MYSQL_5_6: 
            case MYSQL_5_7: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPerconaServer() {
        String comment = MySqlTestConnection.forTestDatabase("mysql").getMySqlVersionComment();
        return comment.startsWith("Percona");
    }

    public static boolean isMariaDb() {
        boolean bl;
        block8: {
            MySqlTestConnection connection = MySqlTestConnection.forTestDatabase("mysql");
            try {
                bl = connection.isVersionCommentMariaDb();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed to resolve if database is MariaDB", e);
                }
            }
            connection.close();
        }
        return bl;
    }

    public boolean isVersionCommentMariaDb() {
        return this.getMySqlVersionComment().toLowerCase().contains("mariadb");
    }

    private static JdbcConfiguration addDefaultSettings(JdbcConfiguration configuration) {
        return JdbcConfiguration.adapt((Configuration)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)configuration.edit().withDefault(JdbcConfiguration.HOSTNAME, "localhost")).withDefault(JdbcConfiguration.PORT, 3306)).withDefault(JdbcConfiguration.USER, "mysqluser")).withDefault(JdbcConfiguration.PASSWORD, "mysqlpw")).build());
    }

    public MySqlTestConnection(JdbcConfiguration config) {
        super(MySqlTestConnection.addDefaultSettings(config), FACTORY, "`", "`");
    }

    public MySqlVersion getMySqlVersion() {
        if (this.mySqlVersion == null) {
            String versionString = this.getMySqlVersionString();
            if (this.isVersionCommentMariaDb()) {
                if (!versionString.startsWith("11.")) {
                    throw new IllegalStateException("Couldn't resolve MariaDB Server version");
                }
                this.mySqlVersion = MySqlVersion.MARIADB_11;
                return this.mySqlVersion;
            }
            if (versionString.startsWith("8.")) {
                this.mySqlVersion = MySqlVersion.MYSQL_8;
            } else if (versionString.startsWith("5.5")) {
                this.mySqlVersion = MySqlVersion.MYSQL_5_5;
            } else if (versionString.startsWith("5.6")) {
                this.mySqlVersion = MySqlVersion.MYSQL_5_6;
            } else if (versionString.startsWith("5.7")) {
                this.mySqlVersion = MySqlVersion.MYSQL_5_7;
            } else {
                throw new IllegalStateException("Couldn't resolve MySQL Server version");
            }
        }
        return this.mySqlVersion;
    }

    public String getMySqlVersionString() {
        String versionString;
        try {
            versionString = (String)this.connect().queryAndMap("SHOW GLOBAL VARIABLES LIKE 'version'", rs -> {
                rs.next();
                return rs.getString(2);
            });
        }
        catch (SQLException e) {
            throw new IllegalStateException("Couldn't obtain MySQL Server version", e);
        }
        return versionString;
    }

    public String getMySqlVersionComment() {
        String versionString;
        try {
            versionString = (String)this.connect().queryAndMap("SHOW GLOBAL VARIABLES LIKE 'version_comment'", rs -> {
                rs.next();
                return rs.getString(2);
            });
        }
        catch (SQLException e) {
            throw new IllegalStateException("Couldn't obtain MySQL Server version comment", e);
        }
        return versionString;
    }

    public boolean isTableIdCaseSensitive() {
        String caseString;
        try {
            caseString = (String)this.connect().queryAndMap("SHOW GLOBAL VARIABLES LIKE 'lower_case_table_names'", rs -> {
                rs.next();
                return rs.getString(2);
            });
        }
        catch (SQLException e) {
            throw new IllegalStateException("Couldn't obtain MySQL Server version comment", e);
        }
        return !"0".equals(caseString);
    }

    public DatabaseDifferences databaseAsserts() {
        if (this.databaseAsserts == null) {
            this.databaseAsserts = this.getMySqlVersion() == MySqlVersion.MARIADB_11 ? new DatabaseDifferences(){

                @Override
                public boolean isCurrentDateTimeDefaultGenerated() {
                    return false;
                }

                @Override
                public String currentDateTimeDefaultOptional(String isoString) {
                    return null;
                }

                @Override
                public void setBinlogRowQueryEventsOff(JdbcConnection connection) throws SQLException {
                    connection.execute(new String[]{"SET binlog_annotate_row_events=OFF"});
                }

                @Override
                public void setBinlogRowQueryEventsOn(JdbcConnection connection) throws SQLException {
                    connection.execute(new String[]{"SET binlog_annotate_row_events=ON"});
                }

                @Override
                public void setBinlogCompressionOff(JdbcConnection connection) throws SQLException {
                    connection.execute(new String[]{"set global log_bin_compress=OFF;"});
                }

                @Override
                public void setBinlogCompressionOn(JdbcConnection connection) throws SQLException {
                    connection.execute(new String[]{"set global log_bin_compress=ON;"});
                }
            } : (this.getMySqlVersion() == MySqlVersion.MYSQL_8 ? new DatabaseDifferences(){

                @Override
                public boolean isCurrentDateTimeDefaultGenerated() {
                    return true;
                }

                @Override
                public String currentDateTimeDefaultOptional(String isoString) {
                    return null;
                }
            } : new DatabaseDifferences(){

                @Override
                public boolean isCurrentDateTimeDefaultGenerated() {
                    return false;
                }

                @Override
                public String currentDateTimeDefaultOptional(String isoString) {
                    return isoString;
                }
            });
        }
        return this.databaseAsserts;
    }

    public static enum MySqlVersion {
        MYSQL_5_5,
        MYSQL_5_6,
        MYSQL_5_7,
        MYSQL_8,
        MARIADB_11;

    }
}

