/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.EnumeratedValue;
import io.debezium.converters.spi.SerializerType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.storage.ConverterConfig;

public class CloudEventsConverterConfig
extends ConverterConfig {
    public static final String CLOUDEVENTS_SERIALIZER_TYPE_CONFIG = "serializer.type";
    public static final String CLOUDEVENTS_SERIALIZER_TYPE_DEFAULT = "json";
    private static final String CLOUDEVENTS_SERIALIZER_TYPE_DOC = "Specify a serializer to serialize CloudEvents values";
    public static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG = "data.serializer.type";
    public static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_DEFAULT = "json";
    private static final String CLOUDEVENTS_DATA_SERIALIZER_TYPE_DOC = "Specify a serializer to serialize the data field of CloudEvents values";
    public static final String CLOUDEVENTS_EXTENSION_ATTRIBUTES_ENABLE_CONFIG = "extension.attributes.enable";
    public static final boolean CLOUDEVENTS_EXTENSION_ATTRIBUTES_ENABLE_DEFAULT = true;
    private static final String CLOUDEVENTS_EXTENSION_ATTRIBUTES_ENABLE_DOC = "Specify whether to include extension attributes to a cloud event";
    public static final String CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_CONFIG = "schema.name.adjustment.mode";
    public static final String CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DEFAULT = "avro";
    private static final String CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DOC = "Specify how schema names should be adjusted for compatibility with the message converter used by the connector, including:'avro' replaces the characters that cannot be used in the Avro type name with underscore (default)'none' does not apply any adjustment";
    public static final String CLOUDEVENTS_METADATA_LOCATION_CONFIG = "metadata.location";
    public static final String CLOUDEVENTS_METADATA_LOCATION_DEFAULT = "value,id:generate,type:generate";
    private static final String CLOUDEVENTS_METADATA_LOCATION_DOC = "Specify from where to retrieve metadata";
    private static final ConfigDef CONFIG = ConverterConfig.newConfigDef();

    public static ConfigDef configDef() {
        return CONFIG;
    }

    public CloudEventsConverterConfig(Map<String, ?> props) {
        super(CONFIG, props);
    }

    public SerializerType cloudeventsSerializerType() {
        return SerializerType.withName(this.getString(CLOUDEVENTS_SERIALIZER_TYPE_CONFIG));
    }

    public SerializerType cloudeventsDataSerializerTypeConfig() {
        return SerializerType.withName(this.getString(CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG));
    }

    public boolean extensionAttributesEnable() {
        return this.getBoolean(CLOUDEVENTS_EXTENSION_ATTRIBUTES_ENABLE_CONFIG);
    }

    public CommonConnectorConfig.SchemaNameAdjustmentMode schemaNameAdjustmentMode() {
        return CommonConnectorConfig.SchemaNameAdjustmentMode.parse(this.getString(CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_CONFIG));
    }

    public MetadataLocation metadataLocation() {
        MetadataLocationValue global;
        List metadataLocations = this.getList(CLOUDEVENTS_METADATA_LOCATION_CONFIG);
        Set<MetadataLocationValue> globalMetadataLocationAllowedValues = Set.of(MetadataLocationValue.VALUE, MetadataLocationValue.HEADER);
        if (!globalMetadataLocationAllowedValues.contains(global = MetadataLocationValue.parse((String)metadataLocations.get(0)))) {
            throw new ConfigException("Global metadata location can't be " + global.name());
        }
        MetadataLocationValue idCustomSource = null;
        MetadataLocationValue typeCustomSource = null;
        block8: for (int i = 1; i < metadataLocations.size(); ++i) {
            String[] parts = ((String)metadataLocations.get(i)).split(":");
            String fieldName = parts[0];
            MetadataLocationValue fieldSource = MetadataLocationValue.parse(parts[1]);
            if (fieldSource == null) {
                throw new ConfigException("Field source `" + parts[1] + "` is not valid");
            }
            switch (fieldName) {
                case "id": {
                    idCustomSource = fieldSource;
                    continue block8;
                }
                case "type": {
                    typeCustomSource = fieldSource;
                    continue block8;
                }
                default: {
                    throw new ConfigException("Field `" + fieldName + "` is not allowed to set custom source");
                }
            }
        }
        return new MetadataLocation(global, idCustomSource != null ? idCustomSource : global, typeCustomSource != null ? typeCustomSource : global);
    }

    static {
        CONFIG.define(CLOUDEVENTS_SERIALIZER_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"json", ConfigDef.Importance.HIGH, CLOUDEVENTS_SERIALIZER_TYPE_DOC);
        CONFIG.define(CLOUDEVENTS_DATA_SERIALIZER_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"json", ConfigDef.Importance.HIGH, CLOUDEVENTS_DATA_SERIALIZER_TYPE_DOC);
        CONFIG.define(CLOUDEVENTS_EXTENSION_ATTRIBUTES_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.HIGH, CLOUDEVENTS_EXTENSION_ATTRIBUTES_ENABLE_DOC);
        CONFIG.define(CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_CONFIG, ConfigDef.Type.STRING, (Object)CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DEFAULT, ConfigDef.Importance.LOW, CLOUDEVENTS_SCHEMA_NAME_ADJUSTMENT_MODE_DOC);
        CONFIG.define(CLOUDEVENTS_METADATA_LOCATION_CONFIG, ConfigDef.Type.LIST, (Object)CLOUDEVENTS_METADATA_LOCATION_DEFAULT, ConfigDef.Importance.HIGH, CLOUDEVENTS_METADATA_LOCATION_DOC);
    }

    public static enum MetadataLocationValue implements EnumeratedValue
    {
        VALUE("value"),
        HEADER("header"),
        GENERATE("generate");

        private final String value;

        private MetadataLocationValue(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static MetadataLocationValue parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (MetadataLocationValue option : MetadataLocationValue.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }
    }

    public class MetadataLocation {
        private final MetadataLocationValue global;
        private final MetadataLocationValue id;
        private final MetadataLocationValue type;

        public MetadataLocation(MetadataLocationValue global, MetadataLocationValue id, MetadataLocationValue type) {
            this.global = global;
            this.id = id;
            this.type = type;
        }

        public MetadataLocationValue global() {
            return this.global;
        }

        public MetadataLocationValue id() {
            return this.id;
        }

        public MetadataLocationValue type() {
            return this.type;
        }
    }
}

