/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.converters.AbstractCloudEventsConverterTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.TableId;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.UUID;
import org.junit.After;
import org.junit.Before;

public class CloudEventsConverterIT
extends AbstractCloudEventsConverterTest<MySqlConnector> {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-connect.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("myServer1", "empty").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private JdbcConnection connection;
    private static final String SETUP_OUTBOX_TABLE = "CREATE TABLE outbox (  id            varchar(36)  not null,  aggregatetype varchar(255) not null,  aggregateid   varchar(255) not null,  type          varchar(255) not null,  payload       json,  CONSTRAINT outbox_pk PRIMARY KEY (id));";

    @Before
    public void beforeEach() throws Exception {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());){
            this.connection = db.connect();
        }
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    protected Class<MySqlConnector> getConnectorClass() {
        return MySqlConnector.class;
    }

    protected String getConnectorName() {
        return "mysql";
    }

    protected String getServerName() {
        return this.DATABASE.getServerName();
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected Configuration.Builder getConfigurationBuilder() {
        return (Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false);
    }

    protected String tableName() {
        return this.tableNameId().toQuotedString('`');
    }

    protected String topicName() {
        return this.DATABASE.topicForTable("outbox");
    }

    protected void createTable() throws Exception {
        this.connection.execute(new String[]{SETUP_OUTBOX_TABLE});
    }

    protected String createInsert(String eventId, String eventType, String aggregateType, String aggregateId, String payloadJson, String additional) {
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO outbox VALUES (");
        insert.append("'").append(UUID.fromString(eventId)).append("'");
        insert.append(", '").append(aggregateType).append("'");
        insert.append(", '").append(aggregateId).append("'");
        insert.append(", '").append(eventType).append("'");
        if (payloadJson == null) {
            insert.append(", null");
        } else if (payloadJson.isEmpty()) {
            insert.append(", ''");
        } else {
            insert.append(", '").append(payloadJson).append("'");
        }
        if (additional != null) {
            insert.append(additional);
        }
        insert.append(")");
        return insert.toString();
    }

    protected void waitForStreamingStarted() throws InterruptedException {
        CloudEventsConverterIT.waitForStreamingRunning((String)"mysql", (String)this.DATABASE.getServerName());
    }

    private TableId tableNameId() {
        return this.tableNameId("a");
    }

    private TableId tableNameId(String table) {
        return TableId.parse((String)this.DATABASE.qualifiedTableName(table));
    }
}

