/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlSnapshotChangeEventSource;
import io.debezium.connector.mysql.SnapshotSourceIT;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenDatabaseVersion;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.util.Collect;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;

@SkipWhenDatabaseVersion(check=EqualityCheck.LESS_THAN, major=5, minor=6, reason="DDL uses fractional second data types, not supported until MySQL 5.6")
public class SnapshotParallelSourceIT
extends SnapshotSourceIT {
    @Override
    protected Configuration.Builder simpleConfig() {
        return (Configuration.Builder)super.simpleConfig().with(MySqlConnectorConfig.SNAPSHOT_MAX_THREADS, 3);
    }

    @Override
    @Ignore
    @Test
    public void shouldSnapshotTablesInRowCountOrderAsc() {
    }

    @Override
    @Ignore
    @Test
    public void shouldSnapshotTablesInRowCountOrderDesc() {
    }

    @Override
    @Ignore
    @Test
    public void shouldSnapshotTablesInLexicographicalOrder() {
    }

    @Override
    @Ignore
    @Test
    public void shouldSnapshotTablesInOrderSpecifiedInTableIncludeList() {
    }

    @Override
    @Ignore
    @Test
    public void shouldSnapshotTablesInOrderSpecifiedInTableIncludeListWithConflictingNames() {
    }

    @Test
    public void shouldParallelCreateSnapshotSchema() throws Exception {
        List includeDatabases = Collect.arrayListOf((Object)this.DATABASE.getDatabaseName(), (Object[])new String[]{this.OTHER_DATABASE.getDatabaseName()});
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.simpleConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, true)).with(MySqlConnectorConfig.SNAPSHOT_LOCKING_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotLockingMode.NONE)).with(MySqlConnectorConfig.DATABASE_INCLUDE_LIST, String.join((CharSequence)",", includeDatabases))).build();
        LogInterceptor logInterceptor = new LogInterceptor(MySqlSnapshotChangeEventSource.class);
        this.start(MySqlConnector.class, this.config);
        SnapshotParallelSourceIT.waitForSnapshotToBeCompleted((String)"mysql", (String)this.DATABASE.getServerName());
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(100);
        List schemaRecords = sourceRecords.recordsForTopic(this.DATABASE.getServerName());
        List sourceDatabases = schemaRecords.stream().map(record -> ((Struct)record.value()).get("databaseName").toString()).filter(includeDatabases::contains).distinct().collect(Collectors.toList());
        Assertions.assertThat((int)sourceDatabases.size()).isEqualTo(2);
        Assertions.assertThat((boolean)logInterceptor.containsMessage("Creating schema snapshot worker pool with 3 worker thread(s)")).isTrue();
    }
}

