/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.AbstractBlockingSnapshotTest;
import io.debezium.relational.TableId;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.junit.After;
import org.junit.Before;

public class BlockingSnapshotIT
extends AbstractBlockingSnapshotTest {
    protected static final String SERVER_NAME = "is_test";
    protected final UniqueDatabase DATABASE = new UniqueDatabase("is_test", "blocking_snapshot-test").withDbHistoryPath(SCHEMA_HISTORY_PATH);

    @Before
    public void before() throws SQLException {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SQL_QUERY, true)).with(MySqlConnectorConfig.USER, "mysqluser")).with(MySqlConnectorConfig.PASSWORD, "mysqlpw")).with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY.getValue())).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(MySqlConnectorConfig.SIGNAL_DATA_COLLECTION, this.DATABASE.qualifiedTableName("debezium_signal"))).with(CommonConnectorConfig.SIGNAL_POLL_INTERVAL_MS, 1);
    }

    protected Configuration.Builder mutableConfig(boolean signalTableOnly, boolean storeOnlyCapturedDdl) {
        if (signalTableOnly) {
            String tableIncludeList = this.DATABASE.qualifiedTableName("c");
        } else {
            String tableIncludeList = this.DATABASE.qualifiedTableName("a") + ", " + this.DATABASE.qualifiedTableName("c");
        }
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.INCLUDE_SQL_QUERY, true)).with(MySqlConnectorConfig.USER, "mysqluser")).with(MySqlConnectorConfig.PASSWORD, "mysqlpw")).with(MySqlConnectorConfig.SNAPSHOT_MODE, MySqlConnectorConfig.SnapshotMode.INITIAL.getValue())).with(MySqlConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(MySqlConnectorConfig.SIGNAL_DATA_COLLECTION, this.DATABASE.qualifiedTableName("debezium_signal"))).with(CommonConnectorConfig.SIGNAL_POLL_INTERVAL_MS, 5)).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, storeOnlyCapturedDdl)).with(MySqlConnectorConfig.SNAPSHOT_MODE_TABLES, this.DATABASE.qualifiedTableName("a"))).with(CommonConnectorConfig.SCHEMA_NAME_ADJUSTMENT_MODE, (EnumeratedValue)CommonConnectorConfig.SchemaNameAdjustmentMode.AVRO);
    }

    protected String connector() {
        return "mysql";
    }

    protected String server() {
        return this.DATABASE.getServerName();
    }

    protected Class<MySqlConnector> connectorClass() {
        return MySqlConnector.class;
    }

    protected JdbcConnection databaseConnection() {
        return MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
    }

    protected String topicName() {
        return this.DATABASE.topicForTable("a");
    }

    protected List<String> topicNames() {
        return List.of(this.DATABASE.topicForTable("a"), this.DATABASE.topicForTable("b"));
    }

    protected String tableName() {
        return this.tableNameId().toQuotedString('`');
    }

    protected List<String> tableNames() {
        String tableA = TableId.parse((String)this.DATABASE.qualifiedTableName("a")).toQuotedString('`');
        String tableB = TableId.parse((String)this.DATABASE.qualifiedTableName("b")).toQuotedString('`');
        return List.of(tableA, tableB);
    }

    protected String signalTableName() {
        return this.tableNameId("debezium_signal").toQuotedString('`');
    }

    protected String signalTableNameSanitized() {
        return this.DATABASE.qualifiedTableName("debezium_signal");
    }

    protected String tableDataCollectionId() {
        return this.tableNameId().toString();
    }

    protected List<String> tableDataCollectionIds() {
        return List.of(this.tableNameId().toString(), this.tableNameId("b").toString());
    }

    private TableId tableNameId() {
        return this.tableNameId("a");
    }

    private TableId tableNameId(String table) {
        return TableId.parse((String)this.DATABASE.qualifiedTableName(table));
    }
}

