/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlDateTimeInKeyIT
extends AbstractConnectorTest {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-decimal-column.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("pkdb", "datetime_key_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-1194"})
    public void shouldAcceptAllZeroDatetimeInPrimaryKey() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).build();
        this.start(MySqlConnector.class, this.config);
        int numDatabase = 3;
        int numTables = 2;
        boolean numInserts = true;
        boolean numOthers = true;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        Assertions.assertThat((Object)records).isNotNull();
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
        List changes = records.recordsForTopic(this.DATABASE.topicForTable("dbz_1194_datetime_key_test"));
        Assertions.assertThat((List)changes).hasSize(1);
        this.assertKey(changes);
        try (Connection conn = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            conn.createStatement().execute("SET sql_mode='';");
            conn.createStatement().execute("INSERT INTO dbz_1194_datetime_key_test VALUES (default, '0000-00-00 00:00:00', '0000-00-00', '00:00:00')");
        }
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((Object)records).isNotNull();
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
        changes = records.recordsForTopic(this.DATABASE.topicForTable("dbz_1194_datetime_key_test"));
        Assertions.assertThat((List)changes).hasSize(1);
        this.assertKey(changes);
        this.stopConnector();
    }

    private void assertKey(List<SourceRecord> changes) {
        Struct key = (Struct)changes.get(0).key();
        Assertions.assertThat((Long)key.getInt64("dtval")).isZero();
        Assertions.assertThat((Long)key.getInt64("tval")).isZero();
        Assertions.assertThat((Integer)key.getInt32("dval")).isZero();
    }
}

