/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlSkipMessagesWithoutChangeConfigIT
extends AbstractConnectorTest {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-decimal.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("skip_messages_db", "skip_messages_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-2979"})
    public void shouldSkipEventsWithNoChangeInIncludedColumnsWhenSkipEnabled() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.COLUMN_INCLUDE_LIST, this.getQualifiedColumnName("id") + "," + this.getQualifiedColumnName("white"))).with(MySqlConnectorConfig.SKIP_MESSAGES_WITHOUT_CHANGE, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(MySqlConnector.class, this.config);
        MySqlSkipMessagesWithoutChangeConfigIT.waitForStreamingRunning((String)"mysql", (String)this.DATABASE.getServerName());
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"insert into debezium_test(id, black, white) values(1, 1, 1)"});
            connection.execute(new String[]{"UPDATE debezium_test SET black=2 where id = 1"});
            connection.execute(new String[]{"UPDATE debezium_test SET white=2 where id = 1"});
            connection.execute(new String[]{"UPDATE debezium_test SET white=3, black=3 where id = 1"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(6);
        List recordsForTopic = records.recordsForTopic(this.DATABASE.topicForTable("debezium_test"));
        Assertions.assertThat((List)recordsForTopic).hasSize(4);
        Struct thirdMessage = ((Struct)((SourceRecord)recordsForTopic.get(2)).value()).getStruct("after");
        Assertions.assertThat((Object)thirdMessage.get("white")).isEqualTo((Object)2);
        Struct forthMessage = ((Struct)((SourceRecord)recordsForTopic.get(3)).value()).getStruct("after");
        Assertions.assertThat((Object)forthMessage.get("white")).isEqualTo((Object)3);
    }

    @Test
    @FixFor(value={"DBZ-2979"})
    public void shouldSkipEventsWithNoChangeInIncludedColumnsWhenSkipEnabledWithExcludeConfig() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.COLUMN_EXCLUDE_LIST, this.getQualifiedColumnName("black"))).with(MySqlConnectorConfig.SKIP_MESSAGES_WITHOUT_CHANGE, true)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(MySqlConnector.class, this.config);
        MySqlSkipMessagesWithoutChangeConfigIT.waitForStreamingRunning((String)"mysql", (String)this.DATABASE.getServerName());
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"insert into debezium_test(id, black, white) values(1, 1, 1)"});
            connection.execute(new String[]{"UPDATE debezium_test SET black=2 where id = 1"});
            connection.execute(new String[]{"UPDATE debezium_test SET white=2 where id = 1"});
            connection.execute(new String[]{"UPDATE debezium_test SET white=3, black=3 where id = 1"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(6);
        List recordsForTopic = records.recordsForTopic(this.DATABASE.topicForTable("debezium_test"));
        Assertions.assertThat((List)recordsForTopic).hasSize(4);
        Struct thirdMessage = ((Struct)((SourceRecord)recordsForTopic.get(2)).value()).getStruct("after");
        Assertions.assertThat((Object)thirdMessage.get("white")).isEqualTo((Object)2);
        Struct forthMessage = ((Struct)((SourceRecord)recordsForTopic.get(3)).value()).getStruct("after");
        Assertions.assertThat((Object)forthMessage.get("white")).isEqualTo((Object)3);
    }

    @Test
    @FixFor(value={"DBZ-2979"})
    public void shouldNotSkipEventsWithNoChangeInIncludedColumnsWhenSkipDisabled() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.COLUMN_INCLUDE_LIST, this.getQualifiedColumnName("id") + "," + this.getQualifiedColumnName("white"))).with(MySqlConnectorConfig.SKIP_MESSAGES_WITHOUT_CHANGE, false)).with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).build();
        this.start(MySqlConnector.class, this.config);
        MySqlSkipMessagesWithoutChangeConfigIT.waitForStreamingRunning((String)"mysql", (String)this.DATABASE.getServerName());
        try (MySqlTestConnection db = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());
             JdbcConnection connection = db.connect();){
            connection.execute(new String[]{"insert into debezium_test(id, black, white) values(1, 1, 1)"});
            connection.execute(new String[]{"UPDATE debezium_test SET black=2 where id = 1"});
            connection.execute(new String[]{"UPDATE debezium_test SET white=2 where id = 1"});
            connection.execute(new String[]{"UPDATE debezium_test SET white=3, black=3 where id = 1"});
        }
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        List recordsForTopic = records.recordsForTopic(this.DATABASE.topicForTable("debezium_test"));
        Assertions.assertThat((List)recordsForTopic).hasSize(5);
        Struct thirdMessage = ((Struct)((SourceRecord)recordsForTopic.get(2)).value()).getStruct("after");
        Assertions.assertThat((Object)thirdMessage.get("white")).isEqualTo((Object)1);
        Struct forthMessage = ((Struct)((SourceRecord)recordsForTopic.get(3)).value()).getStruct("after");
        Assertions.assertThat((Object)forthMessage.get("white")).isEqualTo((Object)2);
        Struct fifthMessage = ((Struct)((SourceRecord)recordsForTopic.get(4)).value()).getStruct("after");
        Assertions.assertThat((Object)fifthMessage.get("white")).isEqualTo((Object)3);
    }

    String getQualifiedColumnName(String column) {
        return String.format("%s.%s", this.DATABASE.qualifiedTableName("debezium_test"), column);
    }
}

