/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlSchemaHistoryIT
extends AbstractConnectorTest {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-json.txt").toAbsolutePath();
    private static final int TABLE_COUNT = 2;
    private UniqueDatabase DATABASE;
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE = new UniqueDatabase("history", "history-dbz").withDbHistoryPath(SCHEMA_HISTORY_PATH);
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-3485"})
    public void shouldUseQuotedNameInDrop() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(MySqlConnector.class, this.config);
        Testing.Print.enable();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(8);
        this.assertDdls(records);
        this.stopConnector();
        this.start(MySqlConnector.class, this.config);
        this.assertConnectorIsRunning();
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-3399"})
    public void shouldStoreSingleRename() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(MySqlConnector.class, this.config);
        Testing.Print.enable();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(8);
        this.assertDdls(records);
        try (MySqlTestConnection connection = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());){
            connection.execute(new String[]{"RENAME TABLE `t-1` TO `new-t-1`"});
        }
        records = this.consumeRecordsByTopic(1);
        List schemaChanges = records.recordsForTopic(this.DATABASE.getServerName());
        Assertions.assertThat((String)this.getDdl(schemaChanges, 0)).startsWith((CharSequence)"RENAME TABLE `t-1` TO `new-t-1`");
        this.stopConnector();
        this.start(MySqlConnector.class, this.config);
        this.assertConnectorIsRunning();
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-3399"})
    public void shouldStoreMultipleRenames() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(MySqlConnector.class, this.config);
        Testing.Print.enable();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(8);
        try (MySqlTestConnection connection = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());){
            connection.execute(new String[]{"RENAME TABLE `t-1` TO `new-t-1`, `t.2` TO `new.t.2`"});
        }
        records = this.consumeRecordsByTopic(2);
        List schemaChanges = records.recordsForTopic(this.DATABASE.getServerName());
        Assertions.assertThat((String)this.getDdl(schemaChanges, 0)).startsWith((CharSequence)"RENAME TABLE `t-1` TO `new-t-1`");
        Assertions.assertThat((String)this.getDdl(schemaChanges, 1)).startsWith((CharSequence)"RENAME TABLE `t.2` TO `new.t.2`");
        this.stopConnector();
        this.start(MySqlConnector.class, this.config);
        this.assertConnectorIsRunning();
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-3399"})
    public void shouldStoreAlterRename() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.SCHEMA_ONLY)).build();
        this.start(MySqlConnector.class, this.config);
        Testing.Print.enable();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(8);
        try (MySqlTestConnection connection = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName());){
            connection.execute(new String[]{"ALTER TABLE `t-1` RENAME TO `new-t-1`"});
        }
        records = this.consumeRecordsByTopic(1);
        List schemaChanges = records.recordsForTopic(this.DATABASE.getServerName());
        Assertions.assertThat((String)this.getDdl(schemaChanges, 0)).startsWith((CharSequence)"ALTER TABLE `t-1` RENAME TO `new-t-1`");
        this.stopConnector();
        this.start(MySqlConnector.class, this.config);
        this.assertConnectorIsRunning();
        this.stopConnector();
    }

    private void assertDdls(AbstractConnectorTest.SourceRecords records) {
        List schemaChanges = records.recordsForTopic(this.DATABASE.getServerName());
        int index = 0;
        Assertions.assertThat((String)this.getDdl(schemaChanges, index++)).startsWith((CharSequence)"SET");
        Assertions.assertThat((String)this.getDdl(schemaChanges, index++)).startsWith((CharSequence)("DROP TABLE IF EXISTS `" + this.DATABASE.getDatabaseName() + "`.`t-1`"));
        Assertions.assertThat((String)this.getDdl(schemaChanges, index++)).startsWith((CharSequence)("DROP TABLE IF EXISTS `" + this.DATABASE.getDatabaseName() + "`.`t.2`"));
        Assertions.assertThat((String)this.getDdl(schemaChanges, index++)).startsWith((CharSequence)("DROP DATABASE IF EXISTS `" + this.DATABASE.getDatabaseName() + "`"));
        Assertions.assertThat((String)this.getDdl(schemaChanges, index++)).startsWith((CharSequence)("CREATE DATABASE `" + this.DATABASE.getDatabaseName() + "`"));
        Assertions.assertThat((String)this.getDdl(schemaChanges, index++)).startsWith((CharSequence)("USE `" + this.DATABASE.getDatabaseName() + "`"));
        Assertions.assertThat((String)this.getDdl(schemaChanges, index++)).startsWith((CharSequence)"CREATE TABLE `t-1`");
        Assertions.assertThat((String)this.getDdl(schemaChanges, index++)).startsWith((CharSequence)"CREATE TABLE `t.2`");
    }

    private String getDdl(List<SourceRecord> schemaChanges, int index) {
        return ((Struct)schemaChanges.get(index).value()).getString("ddl");
    }
}

