/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.junit;

import io.debezium.connector.mysql.junit.SkipWhenSslModeIsNot;
import io.debezium.junit.AnnotationBasedTestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipTestDependingOnSslModeRule
extends AnnotationBasedTestRule {
    private static final String CURRENT_SSL_MODE = System.getProperty("database.ssl.mode", "disabled");

    public Statement apply(Statement base, Description description) {
        SkipWhenSslModeIsNot skipSslMode = (SkipWhenSslModeIsNot)this.hasAnnotation(description, SkipWhenSslModeIsNot.class);
        if (skipSslMode != null && !skipSslMode.value().name().equalsIgnoreCase(CURRENT_SSL_MODE)) {
            String reasonForSkipping = "Current SSL_MODE is " + CURRENT_SSL_MODE + System.lineSeparator() + skipSslMode.reason();
            return SkipTestDependingOnSslModeRule.emptyStatement((String)reasonForSkipping, (Description)description);
        }
        return base;
    }
}

