/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlSourceTypeInSchemaIT
extends AbstractConnectorTest {
    private static final String TYPE_NAME_PARAMETER_KEY = "__debezium.source.column.type";
    private static final String TYPE_LENGTH_PARAMETER_KEY = "__debezium.source.column.length";
    private static final String TYPE_SCALE_PARAMETER_KEY = "__debezium.source.column.scale";
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-schema-parameter.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("schemaparameterit", "source_type_as_schema_parameter_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-644", "DBZ-1222"})
    public void shouldPropagateSourceTypeAsSchemaParameter() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with("column.propagate.source.type", ".*\\.c1,.*\\.c2,.*\\.c3.*,.*\\.f.").build();
        this.start(MySqlConnector.class, this.config);
        int numCreateDatabase = 1;
        int numCreateTables = 1;
        int numInserts = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numInserts);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
        List dmls = records.recordsForTopic(this.DATABASE.topicForTable("dbz_644_source_type_mapped_as_schema_parameter_test"));
        Assertions.assertThat((List)dmls).hasSize(1);
        SourceRecord insert = (SourceRecord)dmls.get(0);
        Field before = insert.valueSchema().field("before");
        Map idSchemaParameters = before.schema().field("id").schema().parameters();
        Assertions.assertThat((Map)idSchemaParameters).isNull();
        Map c1SchemaParameters = before.schema().field("c1").schema().parameters();
        Assertions.assertThat((Map)c1SchemaParameters).contains(new Map.Entry[]{Assertions.entry((Object)TYPE_NAME_PARAMETER_KEY, (Object)"INT")});
        Map c2SchemaParameters = before.schema().field("c2").schema().parameters();
        Assertions.assertThat((Map)c2SchemaParameters).contains(new Map.Entry[]{Assertions.entry((Object)TYPE_NAME_PARAMETER_KEY, (Object)"MEDIUMINT")});
        Map c3aSchemaParameters = before.schema().field("c3a").schema().parameters();
        Assertions.assertThat((Map)c3aSchemaParameters).contains(new Map.Entry[]{Assertions.entry((Object)TYPE_NAME_PARAMETER_KEY, (Object)"NUMERIC"), Assertions.entry((Object)TYPE_LENGTH_PARAMETER_KEY, (Object)"5"), Assertions.entry((Object)TYPE_SCALE_PARAMETER_KEY, (Object)"2")});
        Map c3bSchemaParameters = before.schema().field("c3b").schema().parameters();
        Assertions.assertThat((Map)c3bSchemaParameters).contains(new Map.Entry[]{Assertions.entry((Object)TYPE_NAME_PARAMETER_KEY, (Object)"VARCHAR"), Assertions.entry((Object)TYPE_LENGTH_PARAMETER_KEY, (Object)"128")});
        Map f1SchemaParameters = before.schema().field("f1").schema().parameters();
        Assertions.assertThat((Map)f1SchemaParameters).contains(new Map.Entry[]{Assertions.entry((Object)TYPE_NAME_PARAMETER_KEY, (Object)"FLOAT"), Assertions.entry((Object)TYPE_LENGTH_PARAMETER_KEY, (Object)"10")});
        Map f2SchemaParameters = before.schema().field("f2").schema().parameters();
        Assertions.assertThat((Map)f2SchemaParameters).contains(new Map.Entry[]{Assertions.entry((Object)TYPE_NAME_PARAMETER_KEY, (Object)"FLOAT"), Assertions.entry((Object)TYPE_LENGTH_PARAMETER_KEY, (Object)"8"), Assertions.entry((Object)TYPE_SCALE_PARAMETER_KEY, (Object)"4")});
    }

    @Test
    @FixFor(value={"DBZ-1830"})
    public void shouldPropagateSourceTypeByDatatype() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.NEVER)).with("datatype.propagate.source.type", ".+\\.FLOAT,.+\\.VARCHAR").build();
        this.start(MySqlConnector.class, this.config);
        MySqlSourceTypeInSchemaIT.waitForStreamingRunning((String)"mysql", (String)this.DATABASE.getServerName(), (String)MySqlSourceTypeInSchemaIT.getStreamingNamespace());
        int numCreateDatabase = 1;
        int numCreateTables = 1;
        int numInserts = 1;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(numCreateDatabase + numCreateTables + numInserts);
        this.stopConnector();
        Assertions.assertThat((Object)records).isNotNull();
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
        List dmls = records.recordsForTopic(this.DATABASE.topicForTable("dbz_644_source_type_mapped_as_schema_parameter_test"));
        Assertions.assertThat((List)dmls).hasSize(1);
        SourceRecord insert = (SourceRecord)dmls.get(0);
        Field before = insert.valueSchema().field("before");
        Map idSchemaParameters = before.schema().field("id").schema().parameters();
        Assertions.assertThat((Map)idSchemaParameters).isNull();
        Map c1SchemaParameters = before.schema().field("c1").schema().parameters();
        Assertions.assertThat((Map)c1SchemaParameters).isNull();
        Map c2SchemaParameters = before.schema().field("c2").schema().parameters();
        Assertions.assertThat((Map)c2SchemaParameters).isNull();
        Map c3aSchemaParameters = before.schema().field("c3a").schema().parameters();
        Assertions.assertThat((Map)c3aSchemaParameters).doesNotContain(new Map.Entry[]{Assertions.entry((Object)TYPE_NAME_PARAMETER_KEY, (Object)"NUMERIC")});
        Map c3bSchemaParameters = before.schema().field("c3b").schema().parameters();
        Assertions.assertThat((Map)c3bSchemaParameters).contains(new Map.Entry[]{Assertions.entry((Object)TYPE_NAME_PARAMETER_KEY, (Object)"VARCHAR"), Assertions.entry((Object)TYPE_LENGTH_PARAMETER_KEY, (Object)"128")});
        Map f1SchemaParameters = before.schema().field("f1").schema().parameters();
        Assertions.assertThat((Map)f1SchemaParameters).contains(new Map.Entry[]{Assertions.entry((Object)TYPE_NAME_PARAMETER_KEY, (Object)"FLOAT"), Assertions.entry((Object)TYPE_LENGTH_PARAMETER_KEY, (Object)"10")});
        Map f2SchemaParameters = before.schema().field("f2").schema().parameters();
        Assertions.assertThat((Map)f2SchemaParameters).contains(new Map.Entry[]{Assertions.entry((Object)TYPE_NAME_PARAMETER_KEY, (Object)"FLOAT"), Assertions.entry((Object)TYPE_LENGTH_PARAMETER_KEY, (Object)"8"), Assertions.entry((Object)TYPE_SCALE_PARAMETER_KEY, (Object)"4")});
    }
}

