/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlTestConnection;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MySqlTableAndColumnCommentIT
extends AbstractConnectorTest {
    private static final String COLUMN_COMMENT_PARAMETER_KEY = "__debezium.source.column.comment";
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-comment.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("commentit", "table_column_comment_test").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize();
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    @FixFor(value={"DBZ-4000", "DBZ-4998"})
    public void shouldParseComment() throws SQLException, InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.INCLUDE_SCHEMA_COMMENTS, true)).with("datatype.propagate.source.type", ".+\\.BIGINT,.+\\.VARCHAR").build();
        this.start(MySqlConnector.class, this.config);
        int numDatabase = 3;
        int numTables = 2;
        boolean numInserts = true;
        boolean numOthers = true;
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(7);
        Assertions.assertThat((Object)records).isNotNull();
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
        List ddls = records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName());
        Assertions.assertThat((List)ddls).hasSize(5);
        SourceRecord createTable = (SourceRecord)ddls.get(4);
        List tableChanges = (List)((Struct)createTable.value()).get("tableChanges");
        Struct table = (Struct)((Struct)tableChanges.get(0)).get("table");
        List columns = (List)table.get("columns");
        Assertions.assertThat((Object)((Struct)createTable.value()).get("ts_ms")).isNotNull();
        Assertions.assertThat((Object)table.get("comment")).isEqualTo((Object)"table for dbz-4000");
        Optional<Struct> idOpt = this.getColumnOpt(columns, "id");
        Assertions.assertThat((Object)idOpt.get().get("comment")).isEqualTo((Object)"pk");
        Optional<Struct> nameOpt = this.getColumnOpt(columns, "name");
        Assertions.assertThat((Object)nameOpt.get().get("comment")).isEqualTo((Object)"this is name column");
        Optional<Struct> valueOpt = this.getColumnOpt(columns, "value");
        Assertions.assertThat((Object)valueOpt.get().get("comment")).isEqualTo((Object)"the value is bigint type");
        List dmls = records.recordsForTopic(this.DATABASE.topicForTable("dbz_4000_comment_test"));
        Assertions.assertThat((List)dmls).hasSize(1);
        SourceRecord insert = (SourceRecord)dmls.get(0);
        Field before = insert.valueSchema().field("before");
        Map idSchemaParameters = before.schema().field("id").schema().parameters();
        Assertions.assertThat((Map)idSchemaParameters).isNull();
        Map nameSchemaParameters = before.schema().field("name").schema().parameters();
        Assertions.assertThat((Map)nameSchemaParameters).contains(new Map.Entry[]{Assertions.entry((Object)COLUMN_COMMENT_PARAMETER_KEY, (Object)"this is name column")});
        Map valueSchemaParameters = before.schema().field("value").schema().parameters();
        Assertions.assertThat((Map)valueSchemaParameters).contains(new Map.Entry[]{Assertions.entry((Object)COLUMN_COMMENT_PARAMETER_KEY, (Object)"the value is bigint type")});
        try (Connection conn = MySqlTestConnection.forTestDatabase(this.DATABASE.getDatabaseName()).connection();){
            conn.createStatement().execute("ALTER TABLE dbz_4000_comment_test ADD COLUMN remark TEXT COMMENT 'description'");
        }
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((Object)records).isNotNull();
        records.forEach(x$0 -> this.validate((SourceRecord)x$0));
        ddls = records.ddlRecordsForDatabase(this.DATABASE.getDatabaseName());
        SourceRecord ddl = (SourceRecord)ddls.get(0);
        table = (Struct)((Struct)((List)((Struct)ddl.value()).get("tableChanges")).get(0)).get("table");
        columns = (List)table.get("columns");
        Optional<Struct> remarkOpt = this.getColumnOpt(columns, "remark");
        Assertions.assertThat((Object)remarkOpt.get().get("comment")).isEqualTo((Object)"description");
        Assertions.assertThat((Object)((Struct)ddl.value()).get("ts_ms")).isNotNull();
        this.stopConnector();
    }

    private Optional<Struct> getColumnOpt(List<Struct> columns, String columnName) {
        return columns.stream().filter(f -> f.get("name").toString().equalsIgnoreCase(columnName)).findFirst();
    }
}

