/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.UniqueDatabase;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.Collections;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MysqlDefaultValueAllZeroTimeIT
extends AbstractConnectorTest {
    private static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-connect.txt").toAbsolutePath();
    private final UniqueDatabase DATABASE = new UniqueDatabase("myServer1", "default_value_all_zero_time").withDbHistoryPath(SCHEMA_HISTORY_PATH);
    private Configuration config;

    @Before
    public void beforeEach() {
        this.stopConnector();
        this.DATABASE.createAndInitialize(Collections.singletonMap("sessionVariables", "sql_mode=''"));
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            Testing.Files.delete((Path)SCHEMA_HISTORY_PATH);
        }
    }

    @Test
    public void allZeroDateAndTimeTypeTest() throws InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("all_zero_date_and_time_table"))).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(9);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("all_zero_date_and_time_table")).get(0);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Schema schemaG = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(6)).schema();
        Schema schemaH = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(7)).schema();
        Schema schemaI = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(8)).schema();
        Schema schemaJ = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(9)).schema();
        Schema schemaK = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(10)).schema();
        Schema schemaL = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(11)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)"1970-01-01T00:00:00Z");
        Assertions.assertThat((boolean)schemaB.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo((Object)"1970-01-01T00:00:00Z");
        Assertions.assertThat((boolean)schemaD.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaD.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((boolean)schemaF.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaG.defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((boolean)schemaH.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaH.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaI.defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((boolean)schemaJ.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaJ.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaK.defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((boolean)schemaL.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaL.defaultValue()).isEqualTo(null);
    }

    @Test
    @FixFor(value={"DBZ-4334"})
    public void partZeroDateAndTimeTypeTest() throws InterruptedException {
        this.config = ((Configuration.Builder)((Configuration.Builder)this.DATABASE.defaultConfig().with(MySqlConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MySqlConnectorConfig.SnapshotMode.INITIAL)).with(MySqlConnectorConfig.TABLE_INCLUDE_LIST, this.DATABASE.qualifiedTableName("part_zero_date_and_time_table"))).build();
        this.start(MySqlConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(9);
        SourceRecord record = (SourceRecord)records.recordsForTopic(this.DATABASE.topicForTable("part_zero_date_and_time_table")).get(0);
        Schema schemaA = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(0)).schema();
        Schema schemaB = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(1)).schema();
        Schema schemaC = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(2)).schema();
        Schema schemaD = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(3)).schema();
        Schema schemaE = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(4)).schema();
        Schema schemaF = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(5)).schema();
        Schema schemaG = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(6)).schema();
        Schema schemaH = ((Field)((Field)record.valueSchema().fields().get(1)).schema().fields().get(7)).schema();
        Assertions.assertThat((Object)schemaA.defaultValue()).isEqualTo((Object)"1970-01-01T00:00:00Z");
        Assertions.assertThat((boolean)schemaB.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaB.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaC.defaultValue()).isEqualTo((Object)0L);
        Assertions.assertThat((boolean)schemaD.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaD.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaE.defaultValue()).isEqualTo((Object)0);
        Assertions.assertThat((boolean)schemaF.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaF.defaultValue()).isEqualTo(null);
        Assertions.assertThat((Object)schemaG.defaultValue()).isEqualTo((Object)3600000000L);
        Assertions.assertThat((boolean)schemaH.isOptional()).isEqualTo(true);
        Assertions.assertThat((Object)schemaH.defaultValue()).isEqualTo((Object)3600000000L);
    }
}

